/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.executors;

import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.exceptions.JobExecutionException;
import es.bsc.compss.nio.exceptions.SerializedObjectException;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.executors.Executor;
import es.bsc.compss.nio.worker.executors.util.BinaryInvoker;
import es.bsc.compss.nio.worker.executors.util.DecafInvoker;
import es.bsc.compss.nio.worker.executors.util.Invoker;
import es.bsc.compss.nio.worker.executors.util.MPIInvoker;
import es.bsc.compss.nio.worker.executors.util.OmpSsInvoker;
import es.bsc.compss.nio.worker.executors.util.OpenCLInvoker;
import es.bsc.compss.nio.worker.util.ExternalTaskStatus;
import es.bsc.compss.nio.worker.util.JobsThreadPool;
import es.bsc.compss.nio.worker.util.TaskResultReader;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.RequestQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public abstract class ExternalExecutor
extends Executor {
    protected static final String BINDINGS_RELATIVE_PATH = File.separator + "Bindings" + File.separator + "bindings-common" + File.separator + "lib";
    private static final String ERROR_PIPE_CLOSE = "Error on closing pipe ";
    private static final String ERROR_PIPE_QUIT = "Error sending quit to pipe ";
    private static final String ERROR_UNSUPPORTED_JOB_TYPE = "Bindings don't support non-native tasks";
    private static final boolean IS_STORAGE_ENABLED = System.getProperty("compss.storage.conf") != null && !System.getProperty("compss.storage.conf").equals("") && !System.getProperty("compss.storage.conf").equals("null");
    private static final String STORAGE_CONF = IS_STORAGE_ENABLED ? System.getProperty("compss.storage.conf") : "null";
    public static final int MAX_RETRIES = 3;
    public static final String TOKEN_SEP = " ";
    public static final String TOKEN_NEW_LINE = "\n";
    public static final String END_TASK_TAG = "endTask";
    public static final String ERROR_TASK_TAG = "errorTask";
    public static final String QUIT_TAG = "quit";
    public static final String REMOVE_TAG = "remove";
    public static final String SERIALIZE_TAG = "serialize";
    private static final String EXECUTE_TASK_TAG = "task";
    private final String writePipe;
    private final TaskResultReader taskResultReader;

    public ExternalExecutor(NIOWorker nw, JobsThreadPool pool, RequestQueue<NIOTask> queue, String writePipe, TaskResultReader resultReader) {
        super(nw, pool, queue);
        this.writePipe = writePipe;
        this.taskResultReader = resultReader;
        if (NIOTracer.isActivated()) {
            NIOTracer.disablePThreads();
        }
        this.taskResultReader.start();
        if (NIOTracer.isActivated()) {
            NIOTracer.enablePThreads();
        }
    }

    @Override
    public void setEnvironmentVariables(String hostnames, int numNodes, int cus, MethodResourceDescription reqs) {
        if (LOGGER.isDebugEnabled()) {
            System.out.println("HOSTNAMES: " + hostnames);
            System.out.println("NUM_NODES: " + numNodes);
            System.out.println("CPU_COMPUTING_UNITS: " + cus);
        }
        System.setProperty("COMPSS_HOSTNAMES", hostnames.toString());
        System.setProperty("COMPSS_NUM_NODES", String.valueOf(numNodes));
        System.setProperty("COMPSS_NUM_THREADS", String.valueOf(cus));
    }

    @Override
    public void executeTask(NIOWorker nw, NIOTask nt, String outputsBasename, File taskSandboxWorkingDir, int[] assignedCoreUnits, int[] assignedGPUs) throws Exception {
        switch (nt.getMethodType()) {
            case METHOD: {
                this.executeNativeMethod(nw, nt, outputsBasename, taskSandboxWorkingDir, assignedCoreUnits, assignedGPUs);
                break;
            }
            case BINARY: {
                BinaryInvoker binaryInvoker = new BinaryInvoker(nw, nt, taskSandboxWorkingDir, assignedCoreUnits);
                this.executeNonNativeMethod(outputsBasename, binaryInvoker);
                break;
            }
            case MPI: {
                MPIInvoker mpiInvoker = new MPIInvoker(nw, nt, taskSandboxWorkingDir, assignedCoreUnits);
                this.executeNonNativeMethod(outputsBasename, mpiInvoker);
                break;
            }
            case DECAF: {
                DecafInvoker decafInvoker = new DecafInvoker(nw, nt, taskSandboxWorkingDir, assignedCoreUnits);
                this.executeNonNativeMethod(outputsBasename, decafInvoker);
                break;
            }
            case OMPSS: {
                OmpSsInvoker ompssInvoker = new OmpSsInvoker(nw, nt, taskSandboxWorkingDir, assignedCoreUnits);
                this.executeNonNativeMethod(outputsBasename, ompssInvoker);
                break;
            }
            case OPENCL: {
                OpenCLInvoker openclInvoker = new OpenCLInvoker(nw, nt, taskSandboxWorkingDir, assignedCoreUnits);
                this.executeNonNativeMethod(outputsBasename, openclInvoker);
            }
        }
    }

    private void executeNativeMethod(NIOWorker nw, NIOTask nt, String outputsBasename, File taskSandboxWorkingDir, int[] assignedCoreUnits, int[] assignedGPUs) throws JobExecutionException, SerializedObjectException {
        ArrayList<String> args = this.getTaskExecutionCommand(nw, nt, taskSandboxWorkingDir.getAbsolutePath(), assignedCoreUnits, assignedGPUs);
        ExternalExecutor.addArguments(args, nt, nw);
        this.addThreadAffinity(args, assignedCoreUnits);
        this.addGPUAffinity(args, assignedGPUs);
        this.addHostlist(args);
        String externalCommand = this.getArgumentsAsString(args);
        String command = outputsBasename + ".out" + TOKEN_SEP + outputsBasename + ".err" + TOKEN_SEP + externalCommand;
        this.executeExternal(nt.getJobId(), command, nt, nw);
    }

    private void addHostlist(ArrayList<String> args) {
        String hostlist = System.getProperty("COMPSS_HOSTNAMES");
        if (hostlist != null && !hostlist.isEmpty()) {
            args.add(hostlist);
        } else {
            args.add("-");
        }
    }

    private void addThreadAffinity(ArrayList<String> args, int[] assignedCoreUnits) {
        String computingUnits;
        if (assignedCoreUnits.length == 0) {
            computingUnits = "-";
        } else {
            computingUnits = String.valueOf(assignedCoreUnits[0]);
            for (int i = 1; i < assignedCoreUnits.length; ++i) {
                computingUnits = computingUnits + "," + assignedCoreUnits[i];
            }
        }
        args.add(computingUnits);
    }

    private void addGPUAffinity(ArrayList<String> args, int[] assignedGPUs) {
        String computingUnits;
        if (assignedGPUs.length == 0) {
            computingUnits = "-";
        } else {
            computingUnits = String.valueOf(assignedGPUs[0]);
            for (int i = 1; i < assignedGPUs.length; ++i) {
                computingUnits = computingUnits + "," + assignedGPUs[i];
            }
        }
        args.add(computingUnits);
    }

    private void executeNonNativeMethod(String outputsBasename, Invoker invoker) throws JobExecutionException {
        NIOWorker.registerOutputs(outputsBasename);
        System.out.println("[EXTERNAL EXECUTOR] executeNonNativeTask - Begin task execution");
        try {
            invoker.processTask();
            invoker.serializeBinaryExitValue();
        }
        catch (JobExecutionException jee) {
            System.err.println("[EXTERNAL EXECUTOR] executeNonNativeTask - Error in task execution");
            jee.printStackTrace();
            throw jee;
        }
        finally {
            System.out.println("[EXTERNAL EXECUTOR] executeNonNativeTask - End task execution");
            NIOWorker.unregisterOutputs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        LOGGER.info("Finishing ExternalExecutor");
        LOGGER.debug("Send quit tag to pipe " + this.writePipe);
        boolean done = false;
        int retries = 0;
        while (!done && retries < 3) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(this.writePipe, true);
                String quitCMD = "quit\n";
                output.write(quitCMD.getBytes());
                output.flush();
            }
            catch (Exception e) {
                LOGGER.warn("Error on writing on pipe " + this.writePipe + ". Retrying " + retries + "/" + 3);
                ++retries;
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception e) {
                        ErrorManager.error(ERROR_PIPE_CLOSE + this.writePipe, e);
                    }
                }
            }
            done = true;
        }
        if (!done) {
            ErrorManager.error(ERROR_PIPE_QUIT + this.writePipe);
        }
        LOGGER.debug("Waiting for TaskResultReader");
        Semaphore sem = new Semaphore(0);
        this.taskResultReader.shutdown(sem);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        LOGGER.info("End Finishing ExternalExecutor");
    }

    public abstract ArrayList<String> getTaskExecutionCommand(NIOWorker var1, NIOTask var2, String var3, int[] var4, int[] var5);

    private String getArgumentsAsString(ArrayList<String> args) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String c : args) {
            if (!first) {
                sb.append(TOKEN_SEP);
            } else {
                first = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void addArguments(ArrayList<String> lArgs, NIOTask nt, NIOWorker nw) throws JobExecutionException, SerializedObjectException {
        lArgs.add(Boolean.toString(NIOTracer.isActivated()));
        lArgs.add(Integer.toString(nt.getTaskId()));
        lArgs.add(Boolean.toString(nt.isWorkerDebug()));
        lArgs.add(STORAGE_CONF);
        if (nt.getMethodType() != AbstractMethodImplementation.MethodType.METHOD) {
            throw new JobExecutionException(ERROR_UNSUPPORTED_JOB_TYPE);
        }
        MethodImplementation impl = (MethodImplementation)nt.getMethodImplementation();
        lArgs.add(String.valueOf((Object)impl.getMethodType()));
        lArgs.add(impl.getDeclaringClass());
        lArgs.add(impl.getAlternativeMethodName());
        lArgs.add(String.valueOf(nt.getSlaveWorkersNodeNames().size()));
        lArgs.addAll(nt.getSlaveWorkersNodeNames());
        lArgs.add(String.valueOf(nt.getResourceDescription().getTotalCPUComputingUnits()));
        lArgs.add(Boolean.toString(nt.hasTarget()));
        if (nt.hasReturn()) {
            DataType returnType = nt.getParams().getLast().getType();
            lArgs.add(Integer.toString(returnType.ordinal()));
        } else {
            lArgs.add("null");
        }
        lArgs.add(Integer.toString(nt.getNumParams()));
        block5: for (NIOParam np : nt.getParams()) {
            DataType type = np.getType();
            lArgs.add(Integer.toString(type.ordinal()));
            lArgs.add(Integer.toString(np.getStream().ordinal()));
            lArgs.add(np.getPrefix());
            switch (type) {
                case FILE_T: {
                    String destFile;
                    String originalFile = "";
                    if (np.getData() != null) {
                        originalFile = np.getData().getName();
                    }
                    if (!ExternalExecutor.isRuntimeRenamed(destFile = new File(np.getValue().toString()).getName())) {
                        destFile = originalFile;
                    }
                    lArgs.add(originalFile + ":" + destFile + ":" + np.isPreserveSourceData() + ":" + np.isWriteFinalValue() + ":" + np.getOriginalName());
                    break;
                }
                case OBJECT_T: 
                case PSCO_T: 
                case EXTERNAL_OBJECT_T: {
                    lArgs.add(np.getValue().toString());
                    lArgs.add(np.isWriteFinalValue() ? "W" : "R");
                    break;
                }
                case STRING_T: {
                    String value = np.getValue().toString();
                    String[] vals = value.split(TOKEN_SEP);
                    int numSubStrings = vals.length;
                    lArgs.add(Integer.toString(numSubStrings));
                    for (String v : vals) {
                        lArgs.add(v);
                    }
                    continue block5;
                }
                default: {
                    lArgs.add(np.getValue().toString());
                }
            }
        }
    }

    private static boolean isRuntimeRenamed(String filename) {
        return filename.startsWith("d") && filename.endsWith(".IT");
    }

    private void executeExternal(int jobId, String command, NIOTask nt, NIOWorker nw) throws JobExecutionException {
        int taskType = nt.getTaskType() + 1;
        int taskId = nt.getTaskId();
        if (NIOTracer.isActivated()) {
            this.emitStartTask(taskId, taskType);
        }
        LOGGER.debug("Starting job process ...");
        boolean done = false;
        int retries = 0;
        while (!done && retries < 3) {
            String taskCMD = "task " + jobId + TOKEN_SEP + command + TOKEN_NEW_LINE;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("EXECUTOR COMMAND: " + taskCMD);
            }
            try {
                FileOutputStream output = new FileOutputStream(this.writePipe, true);
                Throwable throwable = null;
                try {
                    output.write(taskCMD.getBytes());
                    output.flush();
                    output.close();
                    done = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (output == null) continue;
                    if (throwable != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (Exception e) {
                LOGGER.debug("Error on pipe write. Retry");
                ++retries;
            }
        }
        if (!done) {
            if (NIOTracer.isActivated()) {
                this.emitEndTask();
            }
            LOGGER.error("ERROR: Could not execute job " + jobId + " because cannot write in pipe");
            throw new JobExecutionException("Job " + jobId + " has failed. Cannot write in pipe");
        }
        LOGGER.debug("Waiting for job " + jobId + " completion");
        Semaphore sem = new Semaphore(0);
        this.taskResultReader.askForTaskEnd(jobId, sem);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        LOGGER.debug("Job " + jobId + " completed. Retrieving task result");
        ExternalTaskStatus taskStatus = this.taskResultReader.getTaskStatus(jobId);
        Integer exitValue = taskStatus.getExitValue();
        if (exitValue != 0) {
            if (NIOTracer.isActivated()) {
                this.emitEndTask();
            }
            throw new JobExecutionException("Job " + jobId + " has failed. Exit values is " + exitValue);
        }
        LOGGER.debug("Updating parameters for job " + jobId);
        for (int i = 0; i < taskStatus.getNumParameters(); ++i) {
            DataType paramType = taskStatus.getParameterType(i);
            if (!paramType.equals((Object)DataType.EXTERNAL_OBJECT_T)) continue;
            String paramValue = taskStatus.getParameterValue(i);
            nt.getParams().get(i).setType(DataType.EXTERNAL_OBJECT_T);
            nt.getParams().get(i).setValue(paramValue);
        }
        if (NIOTracer.isActivated()) {
            this.emitEndTask();
        }
        LOGGER.debug("Job " + jobId + " has finished with exit value 0");
    }

    private void emitStartTask(int taskId, int taskType) {
        NIOTracer.emitEventAndCounters(taskType, NIOTracer.getTaskEventsType());
        NIOTracer.emitEvent(taskId, NIOTracer.getTaskSchedulingType());
    }

    private void emitEndTask() {
        NIOTracer.emitEvent(0L, NIOTracer.getTaskSchedulingType());
        NIOTracer.emitEventAndCounters(0, NIOTracer.getTaskEventsType());
    }
}

