/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.util;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ThreadPrintStream
extends PrintStream {
    private Map<Long, PrintStream> threadToStream = new HashMap<Long, PrintStream>();
    private final String end;
    private final PrintStream defaultStream;

    public ThreadPrintStream(String end, PrintStream defaultStream) {
        super(defaultStream);
        this.end = end;
        this.defaultStream = defaultStream;
    }

    public void registerThread(String name) {
        try {
            PrintStream ps = new PrintStream(name + this.end);
            this.threadToStream.put(Thread.currentThread().getId(), ps);
            ps.print("");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void unregisterThread() {
        try {
            this.close();
            this.threadToStream.remove(Thread.currentThread().getId());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void flush() {
        this.getStream().flush();
    }

    @Override
    public void close() {
        this.getStream().close();
    }

    @Override
    public boolean checkError() {
        return this.getStream().checkError();
    }

    @Override
    public void write(int b) {
        this.getStream().write(b);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.getStream().write(buf, off, len);
    }

    @Override
    public void print(boolean b) {
        this.getStream().print(b);
    }

    @Override
    public void print(char c) {
        this.getStream().print(c);
    }

    @Override
    public void print(int i) {
        this.getStream().print(i);
    }

    @Override
    public void print(long l) {
        this.getStream().print(l);
    }

    @Override
    public void print(float f) {
        this.getStream().print(f);
    }

    @Override
    public void print(double d) {
        this.getStream().print(d);
    }

    @Override
    public void print(char[] s) {
        this.getStream().print(s);
    }

    @Override
    public void print(String s) {
        this.getStream().print(s);
    }

    @Override
    public void print(Object obj) {
        this.getStream().print(obj);
    }

    @Override
    public void println() {
        this.getStream().println();
    }

    @Override
    public void println(boolean x) {
        this.getStream().println(x);
    }

    @Override
    public void println(char x) {
        this.getStream().println(x);
    }

    @Override
    public void println(int x) {
        this.getStream().println(x);
    }

    @Override
    public void println(long x) {
        this.getStream().println(x);
    }

    @Override
    public void println(float x) {
        this.getStream().println(x);
    }

    @Override
    public void println(double x) {
        this.getStream().println(x);
    }

    @Override
    public void println(char[] x) {
        this.getStream().println(x);
    }

    @Override
    public void println(String x) {
        this.getStream().println(x);
    }

    @Override
    public void println(Object x) {
        this.getStream().println(x);
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        return this.getStream().printf(format, args);
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.getStream().format(l, format, args);
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        return this.getStream().format(format, args);
    }

    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        return this.getStream().format(l, format, args);
    }

    @Override
    public PrintStream append(CharSequence csq) {
        return this.getStream().append(csq);
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        return this.getStream().append(csq, start, end);
    }

    @Override
    public PrintStream append(char c) {
        return this.getStream().append(c);
    }

    public PrintStream getStream() {
        PrintStream ps = this.threadToStream.get(Thread.currentThread().getId());
        if (ps == null) {
            ps = this.defaultStream;
        }
        return ps;
    }
}

