/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.components;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.binders.BindToMap;
import es.bsc.compss.nio.worker.binders.BindToResource;
import es.bsc.compss.nio.worker.binders.ThreadBinder;
import es.bsc.compss.nio.worker.binders.Unbinded;
import es.bsc.compss.nio.worker.exceptions.InitializationException;
import es.bsc.compss.nio.worker.exceptions.InvalidMapException;
import es.bsc.compss.nio.worker.exceptions.UnsufficientAvailableComputingUnitsException;
import es.bsc.compss.nio.worker.util.CThreadPool;
import es.bsc.compss.nio.worker.util.ExternalThreadPool;
import es.bsc.compss.nio.worker.util.JavaThreadPool;
import es.bsc.compss.nio.worker.util.JobsThreadPool;
import es.bsc.compss.nio.worker.util.PersistentCThreadPool;
import es.bsc.compss.nio.worker.util.PythonThreadPool;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutionManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.ExecManager");
    private final JobsThreadPool pool;
    private final ThreadBinder binderCPUs;
    private final ThreadBinder binderGPUs;
    private final ThreadBinder binderFPGAs;

    public ExecutionManager(NIOWorker nw, int computingUnitsCPU, int computingUnitsGPU, int computingUnitsFPGA, String cpuMap, String gpuMap, String fpgaMap, int limitOfTasks) throws InvalidMapException {
        LOGGER.info("Instantiate Execution Manager");
        int numThreads = limitOfTasks > 0 ? Math.min(limitOfTasks, computingUnitsCPU) : computingUnitsCPU;
        String lang = nw.getLang();
        switch (COMPSsConstants.Lang.valueOf(lang.toUpperCase())) {
            case JAVA: {
                this.pool = new JavaThreadPool(nw, numThreads);
                break;
            }
            case PYTHON: {
                this.pool = new PythonThreadPool(nw, numThreads);
                break;
            }
            case C: {
                if (NIOWorker.isPersistentEnabled()) {
                    this.pool = new PersistentCThreadPool(nw, numThreads);
                    break;
                }
                this.pool = new CThreadPool(nw, numThreads);
                break;
            }
            default: {
                this.pool = null;
                LOGGER.error("Incorrect language " + lang + " in worker " + nw.getHostName());
            }
        }
        LOGGER.debug("Instantiate CPU Binder with " + computingUnitsCPU + " CUs");
        switch (cpuMap) {
            case "disabled": {
                this.binderCPUs = new Unbinded();
                break;
            }
            case "automatic": {
                String resourceMap = BindToMap.getResourceCPUDescription();
                this.binderCPUs = new BindToMap(computingUnitsCPU, resourceMap);
                break;
            }
            default: {
                this.binderCPUs = new BindToMap(computingUnitsCPU, cpuMap);
            }
        }
        LOGGER.debug("Instantiate GPU Binder with " + computingUnitsGPU + " CUs");
        switch (gpuMap) {
            case "disabled": {
                this.binderGPUs = new Unbinded();
                break;
            }
            case "automatic": {
                this.binderGPUs = new BindToResource(computingUnitsGPU);
                break;
            }
            default: {
                this.binderGPUs = new BindToMap(computingUnitsGPU, gpuMap);
            }
        }
        LOGGER.debug("Instantiate FPGA Binder with " + computingUnitsFPGA + " CUs");
        switch (fpgaMap) {
            case "disabled": {
                this.binderFPGAs = new Unbinded();
                break;
            }
            case "automatic": {
                this.binderFPGAs = new BindToResource(computingUnitsFPGA);
                break;
            }
            default: {
                this.binderFPGAs = new BindToMap(computingUnitsFPGA, fpgaMap);
            }
        }
    }

    public void init() throws InitializationException {
        LOGGER.info("Init Execution Manager");
        this.pool.startThreads();
    }

    public void enqueue(NIOTask nt) {
        this.pool.enqueue(nt);
    }

    public void stop() {
        LOGGER.info("Stopping Threads...");
        this.pool.stopThreads();
    }

    public int[] bind(int jobId, int numCUs, BinderType type) throws UnsufficientAvailableComputingUnitsException {
        switch (type) {
            case CPU: {
                return this.binderCPUs.bindComputingUnits(jobId, numCUs);
            }
            case GPU: {
                return this.binderGPUs.bindComputingUnits(jobId, numCUs);
            }
            case FPGA: {
                return this.binderFPGAs.bindComputingUnits(jobId, numCUs);
            }
        }
        return null;
    }

    public void release(int jobId, BinderType type) {
        switch (type) {
            case CPU: {
                this.binderCPUs.releaseComputingUnits(jobId);
            }
            case GPU: {
                this.binderGPUs.releaseComputingUnits(jobId);
            }
            case FPGA: {
                this.binderFPGAs.releaseComputingUnits(jobId);
            }
        }
    }

    public void removeExternalData(String absFileName) {
        int index;
        String filename;
        LOGGER.debug("Trying to remove external data");
        if (this.pool instanceof ExternalThreadPool && (filename = new File(absFileName).getName()).startsWith("d") && filename.endsWith(".IT") && (index = filename.indexOf(95)) > 0) {
            LOGGER.debug("calling remove");
            ((ExternalThreadPool)this.pool).removeExternalData(filename);
        }
    }

    public boolean serializeExternalData(String name, String path) {
        if (this.pool instanceof ExternalThreadPool) {
            return ((ExternalThreadPool)this.pool).serializeExternalData(name, path);
        }
        return false;
    }

    public static enum BinderType {
        CPU,
        GPU,
        FPGA;

    }
}

