/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio;

import es.bsc.comm.CommProperties;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.MessageHandler;
import es.bsc.comm.Node;
import es.bsc.comm.event.Event;
import es.bsc.comm.exceptions.CommException;
import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.nio.NIOListener;
import es.bsc.comm.nio.event.NIOEvent;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOEventManager
extends EventManager<NIOEvent> {
    private static final Logger LOGGER = LogManager.getLogger("Communication.NIO.EventManager");
    private static final long REESTABLISH_PERIOD = 30000L;
    private NIOConnection closingConnection;
    private boolean nioListenerOn = false;
    private long lastReestablish = System.currentTimeMillis();

    public NIOEventManager(MessageHandler receiver) {
        super(receiver);
    }

    @Override
    public void init(String propertiesFile) throws CommException {
        CommProperties.importProperties(propertiesFile);
        NIOListener.init(this);
    }

    @Override
    public void startServer(Node n) throws CommException {
        NIOListener.startServer(n);
    }

    @Override
    public void run() {
        new NIOListener().start();
        this.nioListenerOn = true;
        super.run();
    }

    @Override
    protected void logProcessingEvent(Event e) {
        if (e instanceof NIOEvent) {
            NIOEvent ne = (NIOEvent)e;
            LOGGER.debug("Processing " + (Object)((Object)ne.getEventType()) + " NIOEvent");
        }
    }

    @Override
    public Connection startConnection(Node n) {
        return NIOListener.startConnection(n);
    }

    @Override
    public void shutdown(Connection c) {
        LOGGER.debug("Shutting down the communication platform");
        this.closingConnection = (NIOConnection)c;
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSpecificStop() {
        LOGGER.debug("NIOEventManager handle specific stop");
        NIOListener.shutdown(this.closingConnection);
        LinkedList privateEvents = new LinkedList();
        while (this.nioListenerOn) {
            NIOEventManager nIOEventManager = this;
            synchronized (nIOEventManager) {
                LinkedList list = (LinkedList)this.events;
                this.events = privateEvents;
                privateEvents = list;
            }
            while (!privateEvents.isEmpty()) {
                NIOEvent event = (NIOEvent)privateEvents.removeFirst();
                if (event == null) {
                    return;
                }
                event.processEventOnConnection(this);
            }
            this.waitForEvents();
        }
    }

    public void listennerStopped() {
        this.nioListenerOn = false;
        this.addEvent(null);
    }

    @Override
    protected void specificActions() {
        long now = System.currentTimeMillis();
        if (this.lastReestablish + 30000L > now) {
            return;
        }
        this.lastReestablish = now;
        NIOConnection.establishPendingConnections();
    }

    @Override
    protected final long waitEventsTimeout() {
        return 30000L;
    }
}

