/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.stage;

import es.bsc.comm.CommProperties;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.InternalConnection;
import es.bsc.comm.exceptions.CommException;
import es.bsc.comm.exceptions.StageException;
import es.bsc.comm.exceptions.ViabilityException;
import es.bsc.comm.stage.Token;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public abstract class Stage {
    private final boolean notifyErrors;

    public Stage(boolean notifyErrors) {
        this.notifyErrors = notifyErrors;
    }

    public boolean isNotifyErrors() {
        return this.notifyErrors;
    }

    public abstract boolean isShutdown();

    public abstract boolean checkViability(boolean var1, List<ByteBuffer> var2, List<ByteBuffer> var3) throws ViabilityException;

    public abstract void start(InternalConnection var1, List<ByteBuffer> var2, List<ByteBuffer> var3) throws StageException;

    public abstract void progress(InternalConnection var1, List<ByteBuffer> var2, List<ByteBuffer> var3) throws StageException;

    public abstract boolean isComplete(List<ByteBuffer> var1, List<ByteBuffer> var2);

    public abstract void notifyCompletion(Connection var1, EventManager<?> var2);

    public abstract void notifyError(Connection var1, EventManager<?> var2, CommException var3);

    public abstract void pause(InternalConnection var1);

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToken(Token token, List<ByteBuffer> transmit) {
        if (token.isCompletelyRead()) {
            return;
        }
        if (transmit.size() < CommProperties.getMaxBufferedPackets()) {
            ByteBuffer bsizeArray = ByteBuffer.wrap(token.getSizeArray());
            ByteBuffer bb = ByteBuffer.wrap(token.getArray());
            List<ByteBuffer> list = transmit;
            synchronized (list) {
                transmit.add(bsizeArray);
                transmit.add(bb);
            }
            token.setReadComplete();
        }
    }

    protected void loadToken(Token token, List<ByteBuffer> received) {
        while (!received.isEmpty() && !token.isCompletelyFilled()) {
            this.loadTokenPacket(token, received);
        }
    }

    protected void loadTokenPacket(Token t, List<ByteBuffer> received) {
        LinkedList rec = (LinkedList)received;
        ByteBuffer bb = (ByteBuffer)rec.removeFirst();
        t.load(bb);
        if (bb.hasRemaining()) {
            rec.addFirst(bb);
        }
    }
}

