/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.executors;

import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.exceptions.JobExecutionException;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.executors.AbstractExternalExecutor;
import es.bsc.compss.nio.worker.util.ExternalTaskStatus;
import es.bsc.compss.nio.worker.util.JobsThreadPool;
import es.bsc.compss.nio.worker.util.TaskResultReader;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.RequestQueue;
import java.io.FileOutputStream;
import java.util.concurrent.Semaphore;

public abstract class ExternalExecutor
extends AbstractExternalExecutor {
    private static final String ERROR_PIPE_CLOSE = "Error on closing pipe ";
    private static final String ERROR_PIPE_QUIT = "Error sending quit to pipe ";
    private final String writePipe;
    private final TaskResultReader taskResultReader;

    public ExternalExecutor(NIOWorker nw, JobsThreadPool pool, RequestQueue<NIOTask> queue, String writePipe, TaskResultReader resultReader) {
        super(nw, pool, queue);
        this.writePipe = writePipe;
        this.taskResultReader = resultReader;
        if (NIOTracer.isActivated()) {
            NIOTracer.disablePThreads();
        }
        this.taskResultReader.start();
        if (NIOTracer.isActivated()) {
            NIOTracer.enablePThreads();
        }
    }

    @Override
    public void start() {
        LOGGER.info("ExternalExecutor started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        LOGGER.info("Finishing ExternalExecutor");
        LOGGER.debug("Send quit tag to pipe " + this.writePipe);
        boolean done = false;
        int retries = 0;
        while (!done && retries < 3) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(this.writePipe, true);
                String quitCMD = "quit\n";
                output.write(quitCMD.getBytes());
                output.flush();
            }
            catch (Exception e) {
                LOGGER.warn("Error on writing on pipe " + this.writePipe + ". Retrying " + retries + "/" + 3);
                ++retries;
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception e) {
                        ErrorManager.error(ERROR_PIPE_CLOSE + this.writePipe, e);
                    }
                }
            }
            done = true;
        }
        if (!done) {
            ErrorManager.error(ERROR_PIPE_QUIT + this.writePipe);
        }
        LOGGER.debug("Waiting for TaskResultReader");
        Semaphore sem = new Semaphore(0);
        this.taskResultReader.shutdown(sem);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        LOGGER.info("End Finishing ExternalExecutor");
    }

    @Override
    protected void executeExternal(int jobId, String command, NIOTask nt, NIOWorker nw) throws JobExecutionException {
        int taskType = nt.getTaskType() + 1;
        int taskId = nt.getTaskId();
        if (NIOTracer.isActivated()) {
            ExternalExecutor.emitStartTask(taskId, taskType);
        }
        LOGGER.debug("Starting job process ...");
        boolean done = false;
        int retries = 0;
        while (!done && retries < 3) {
            String taskCMD = "task " + jobId + " " + command + "\n";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("EXECUTOR COMMAND: " + taskCMD);
            }
            try {
                FileOutputStream output = new FileOutputStream(this.writePipe, true);
                Throwable throwable = null;
                try {
                    output.write(taskCMD.getBytes());
                    output.flush();
                    output.close();
                    done = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (output == null) continue;
                    if (throwable != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (Exception e) {
                LOGGER.debug("Error on pipe write. Retry");
                ++retries;
            }
        }
        if (!done) {
            if (NIOTracer.isActivated()) {
                ExternalExecutor.emitEndTask();
            }
            LOGGER.error("ERROR: Could not execute job " + jobId + " because cannot write in pipe");
            throw new JobExecutionException("Job " + jobId + " has failed. Cannot write in pipe");
        }
        LOGGER.debug("Waiting for job " + jobId + " completion");
        Semaphore sem = new Semaphore(0);
        this.taskResultReader.askForTaskEnd(jobId, sem);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        LOGGER.debug("Job " + jobId + " completed. Retrieving task result");
        ExternalTaskStatus taskStatus = this.taskResultReader.getTaskStatus(jobId);
        Integer exitValue = taskStatus.getExitValue();
        if (exitValue != 0) {
            if (NIOTracer.isActivated()) {
                ExternalExecutor.emitEndTask();
            }
            throw new JobExecutionException("Job " + jobId + " has failed. Exit values is " + exitValue);
        }
        LOGGER.debug("Updating parameters for job " + jobId);
        for (int i = 0; i < taskStatus.getNumParameters(); ++i) {
            DataType paramType = taskStatus.getParameterType(i);
            if (!paramType.equals((Object)DataType.EXTERNAL_PSCO_T)) continue;
            String paramValue = taskStatus.getParameterValue(i);
            nt.getParams().get(i).setType(DataType.EXTERNAL_PSCO_T);
            nt.getParams().get(i).setValue(paramValue);
        }
        if (NIOTracer.isActivated()) {
            ExternalExecutor.emitEndTask();
        }
        LOGGER.debug("Job " + jobId + " has finished with exit value 0");
    }
}

