/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.executors;

import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.exceptions.JobExecutionException;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.executors.AbstractExternalExecutor;
import es.bsc.compss.nio.worker.util.ExternalTaskStatus;
import es.bsc.compss.nio.worker.util.JobsThreadPool;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.util.RequestQueue;

public abstract class PersistentExternalExecutor
extends AbstractExternalExecutor {
    public PersistentExternalExecutor(NIOWorker nw, JobsThreadPool pool, RequestQueue<NIOTask> queue) {
        super(nw, pool, queue);
    }

    public static native String executeInBinding(String var0);

    public static native void initThread();

    public static native void finishThread();

    @Override
    public void finish() {
        LOGGER.info("Finishing Persistent Executor");
        PersistentExternalExecutor.finishThread();
        LOGGER.info("End Finishing ExternalExecutor");
    }

    @Override
    public void start() {
        LOGGER.info("Starting Persistent Executor");
        PersistentExternalExecutor.initThread();
        LOGGER.info("Persistent Executor started");
    }

    @Override
    protected void executeExternal(int jobId, String command, NIOTask nt, NIOWorker nw) throws JobExecutionException {
        ExternalTaskStatus taskStatus;
        Integer exitValue;
        int taskType = nt.getTaskType() + 1;
        int taskId = nt.getTaskId();
        if (NIOTracer.isActivated()) {
            PersistentExternalExecutor.emitStartTask(taskId, taskType);
        }
        String taskCMD = "task " + jobId + " " + command + "\n";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing in binding: " + taskCMD);
        }
        String results = PersistentExternalExecutor.executeInBinding(taskCMD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Result: " + results);
        }
        if ((exitValue = (taskStatus = new ExternalTaskStatus(results.split(" "))).getExitValue()) != 0) {
            if (NIOTracer.isActivated()) {
                PersistentExternalExecutor.emitEndTask();
            }
            throw new JobExecutionException("Job " + jobId + " has failed. Exit values is " + exitValue);
        }
        LOGGER.debug("Updating parameters for job " + jobId);
        for (int i = 0; i < taskStatus.getNumParameters(); ++i) {
            DataType paramType = taskStatus.getParameterType(i);
            if (!paramType.equals((Object)DataType.EXTERNAL_PSCO_T)) continue;
            String paramValue = taskStatus.getParameterValue(i);
            nt.getParams().get(i).setType(DataType.EXTERNAL_PSCO_T);
            nt.getParams().get(i).setValue(paramValue);
        }
        if (NIOTracer.isActivated()) {
            PersistentExternalExecutor.emitEndTask();
        }
        LOGGER.debug("Job " + jobId + " has finished with exit value 0");
    }

    static {
        System.loadLibrary("bindings_common");
    }
}

