/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.util;

import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.util.Ender;
import es.bsc.compss.nio.worker.util.JobsThreadPool;
import es.bsc.compss.nio.worker.util.TaskResultReader;
import es.bsc.compss.nio.worker.util.ThreadPrintStream;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.StreamGobbler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExternalThreadPool
extends JobsThreadPool {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.ThreadPool");
    private static final String ERROR_PB = "Error starting ProcessBuilder";
    private static final String ERROR_GC = "Error generating worker external launch command";
    protected static final String PIPER_SCRIPT_RELATIVE_PATH = "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "adaptors" + File.separator + "nio" + File.separator + "pipers" + File.separator;
    private static final String PIPE_SCRIPT_NAME = "bindings_piper.sh";
    private static final String PIPE_FILE_BASENAME = "pipe_";
    private static final int PIPE_CREATION_TIME = 50;
    protected final String installDir;
    private final String piperScript;
    protected final String[] writePipeFiles;
    protected final String[] readPipeFiles;
    protected TaskResultReader[] taskResultReader;
    protected final String writeDataPipeFile;
    protected final String readDataPipeFile;
    protected static FileOutputStream writeDataStream;
    private Process piper;
    private StreamGobbler outputGobbler;
    private StreamGobbler errorGobbler;

    public ExternalThreadPool(NIOWorker nw, int size) {
        super(nw, size);
        int i;
        this.installDir = nw.getInstallDir();
        String workingDir = nw.getWorkingDir();
        this.piperScript = this.installDir + PIPER_SCRIPT_RELATIVE_PATH + PIPE_SCRIPT_NAME;
        this.writePipeFiles = new String[size];
        this.readPipeFiles = new String[size];
        for (i = 0; i < size; ++i) {
            this.writePipeFiles[i] = workingDir + PIPE_FILE_BASENAME + UUID.randomUUID().hashCode();
            this.readPipeFiles[i] = workingDir + PIPE_FILE_BASENAME + UUID.randomUUID().hashCode();
        }
        this.writeDataPipeFile = workingDir + PIPE_FILE_BASENAME + UUID.randomUUID().hashCode();
        this.readDataPipeFile = workingDir + PIPE_FILE_BASENAME + UUID.randomUUID().hashCode();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PIPE Script: " + this.piperScript);
            StringBuilder writes = new StringBuilder();
            writes.append("WRITE PIPE Files: ");
            for (int i2 = 0; i2 < this.writePipeFiles.length; ++i2) {
                writes.append(this.writePipeFiles[i2]).append(" ");
            }
            writes.append("\n");
            LOGGER.debug(writes.toString());
            StringBuilder reads = new StringBuilder();
            reads.append("READ PIPE Files: ");
            for (int i3 = 0; i3 < this.readPipeFiles.length; ++i3) {
                reads.append(this.readPipeFiles[i3]).append(" ");
            }
            reads.append("\n");
            LOGGER.debug(reads.toString());
            LOGGER.debug("WRITE DATA PIPE: " + this.writeDataPipeFile);
            LOGGER.debug("READ DATA PIPE: " + this.readDataPipeFile);
        }
        this.init();
        this.taskResultReader = new TaskResultReader[size];
        for (i = 0; i < size; ++i) {
            this.taskResultReader[i] = new TaskResultReader(this.readPipeFiles[i]);
        }
        LOGGER.debug("Add ExternalExecutor shutdown hook");
        Runtime.getRuntime().addShutdownHook(new Ender(this));
    }

    private String constructGeneralArgs() {
        int i;
        StringBuilder cmd = new StringBuilder();
        cmd.append(this.size).append(" ");
        cmd.append(this.writeDataPipeFile).append(" ");
        cmd.append(this.readDataPipeFile).append(" ");
        cmd.append(this.writePipeFiles.length).append(" ");
        for (i = 0; i < this.writePipeFiles.length; ++i) {
            cmd.append(this.writePipeFiles[i]).append(" ");
        }
        cmd.append(this.readPipeFiles.length).append(" ");
        for (i = 0; i < this.readPipeFiles.length; ++i) {
            cmd.append(this.readPipeFiles[i]).append(" ");
        }
        return cmd.toString();
    }

    private void init() {
        LOGGER.info("Init piper ProcessBuilder");
        String generalArgs = this.constructGeneralArgs();
        String specificArgs = this.getLaunchCommand();
        if (specificArgs == null) {
            ErrorManager.error(ERROR_GC);
            return;
        }
        ProcessBuilder pb = new ProcessBuilder(this.piperScript, generalArgs, specificArgs);
        try {
            Map<String, String> env = this.getEnvironment(this.nw);
            this.addEnvironment(env, this.nw);
            pb.directory(new File(this.getPBWorkingDir()));
            pb.environment().putAll(env);
            pb.environment().remove("LD_PRELOAD");
            pb.environment().remove("EXTRAE_CONFIG_FILE");
            if (NIOTracer.isActivated()) {
                NIOTracer.emitEvent(Long.parseLong(NIOTracer.getHostID()), NIOTracer.getSyncType());
            }
            this.piper = pb.start();
            LOGGER.debug("Starting stdout/stderr gobblers ...");
            try {
                this.piper.getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            PrintStream out = ((ThreadPrintStream)System.out).getStream();
            PrintStream err = ((ThreadPrintStream)System.err).getStream();
            this.outputGobbler = new StreamGobbler(this.piper.getInputStream(), out, LOGGER);
            this.errorGobbler = new StreamGobbler(this.piper.getErrorStream(), err, LOGGER);
            this.outputGobbler.start();
            this.errorGobbler.start();
        }
        catch (IOException e) {
            ErrorManager.error(ERROR_PB, e);
        }
        try {
            Thread.sleep(50 * this.size);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String getPBWorkingDir() {
        return this.nw.getWorkingDir();
    }

    private void addEnvironment(Map<String, String> env, NIOWorker nw) {
        env.put("COMPSS_WORKING_DIR", nw.getWorkingDir());
        env.put("COMPSS_APP_DIR", nw.getAppDir());
        if (LOGGER.isDebugEnabled()) {
            env.put("COMPSS_BINDINGS_DEBUG", "1");
        }
    }

    @Override
    protected void specificStop() {
        try {
            LOGGER.info("Waiting for finishing piper process");
            int exitCode = this.piper.waitFor();
            if (NIOTracer.isActivated()) {
                NIOTracer.emitEvent(0L, NIOTracer.getSyncType());
            }
            this.outputGobbler.join();
            this.errorGobbler.join();
            if (exitCode != 0) {
                ErrorManager.error("ExternalExecutor piper ended with " + exitCode + " status");
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.piper != null) {
                if (this.piper.getInputStream() != null) {
                    try {
                        this.piper.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.piper.getErrorStream() != null) {
                    try {
                        this.piper.getErrorStream().close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        LOGGER.info("ExternalThreadPool finished");
    }

    public static void ender(ExternalThreadPool etp) {
        LOGGER.info("Starting ExternalThreadPool ender");
        etp.piper.destroy();
    }

    public abstract String getLaunchCommand();

    public abstract Map<String, String> getEnvironment(NIOWorker var1);

    public abstract void removeExternalData(String var1);

    public abstract boolean serializeExternalData(String var1, String var2);
}

