/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.util;

import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.exceptions.InitializationException;
import es.bsc.compss.nio.worker.executors.CPersistentExecutor;
import es.bsc.compss.nio.worker.util.JobsThreadPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PersistentCThreadPool
extends JobsThreadPool {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.ThreadPool");
    private static final String LOG_PREFIX = "[PersistentCThreadPool] ";

    public PersistentCThreadPool(NIOWorker nw, int size) {
        super(nw, size);
    }

    @Override
    protected void specificStop() {
        LOGGER.info("PersistentCThreadPool finished");
    }

    @Override
    public void startThreads() throws InitializationException {
        LOGGER.info("[PersistentCThreadPool] Start threads for persistent C binding");
        int i = 0;
        for (Thread t : this.workerThreads) {
            CPersistentExecutor executor = new CPersistentExecutor(this.nw, this, this.queue);
            t = new Thread(executor);
            t.setName("JobsThreadPool pool thread # " + i);
            t.start();
            ++i;
        }
        this.sem.acquireUninterruptibly(this.size);
        LOGGER.debug("[PersistentCThreadPool] Finished starting persistent C Threads");
    }
}

