/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.util;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.exceptions.InitializationException;
import es.bsc.compss.nio.worker.executors.PythonExecutor;
import es.bsc.compss.nio.worker.util.ExternalThreadPool;
import es.bsc.compss.util.ErrorManager;
import java.io.File;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PythonThreadPool
extends ExternalThreadPool {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.ThreadPool");
    private static final String WORKER_PY_RELATIVE_PATH = File.separator + "pycompss" + File.separator + "worker" + File.separator + "piper_worker.py";

    public PythonThreadPool(NIOWorker nw, int size) {
        super(nw, size);
    }

    @Override
    public void startThreads() throws InitializationException {
        LOGGER.info("Start threads of ThreadPool");
        int i = 0;
        for (Thread t : this.workerThreads) {
            PythonExecutor executor = new PythonExecutor(this.nw, this, this.queue, this.writePipeFiles[i], this.taskResultReader[i]);
            t = new Thread(executor);
            t.setName("JobsThreadPool pool thread # " + i);
            t.start();
            ++i;
        }
        this.sem.acquireUninterruptibly(this.size);
    }

    @Override
    public String getLaunchCommand() {
        int i;
        StringBuilder cmd = new StringBuilder();
        cmd.append((Object)COMPSsConstants.Lang.PYTHON).append(" ");
        cmd.append(NIOWorker.getPythonVirtualEnvironment()).append(" ");
        cmd.append(NIOWorker.getPythonPropagateVirtualEnvironment()).append(" ");
        cmd.append(NIOWorker.isTracingEnabled()).append(" ");
        cmd.append(NIOWorker.getPythonInterpreter()).append(" ").append("-u").append(" ");
        cmd.append(this.installDir).append(PythonExecutor.PYCOMPSS_RELATIVE_PATH).append(File.separator).append(NIOWorker.getPythonVersion()).append(WORKER_PY_RELATIVE_PATH).append(" ");
        cmd.append(NIOWorker.isWorkerDebugEnabled()).append(" ");
        cmd.append(NIOWorker.isTracingEnabled()).append(" ");
        cmd.append(NIOWorker.getStorageConf()).append(" ");
        cmd.append(this.size).append(" ");
        for (i = 0; i < this.writePipeFiles.length; ++i) {
            cmd.append(this.writePipeFiles[i]).append(" ");
        }
        for (i = 0; i < this.readPipeFiles.length; ++i) {
            cmd.append(this.readPipeFiles[i]).append(" ");
        }
        return cmd.toString();
    }

    @Override
    public Map<String, String> getEnvironment(NIOWorker nw) {
        return PythonExecutor.getEnvironment(nw);
    }

    @Override
    protected String getPBWorkingDir() {
        String workingDir = this.nw.getWorkingDir();
        if (NIOTracer.isActivated() && !new File(workingDir = workingDir + "python").mkdirs()) {
            ErrorManager.error("Could not create working dir for python tracefiles, path: " + workingDir);
        }
        return workingDir;
    }

    @Override
    public void removeExternalData(String dataID) {
    }

    @Override
    public boolean serializeExternalData(String name, String path) {
        return false;
    }
}

