/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OpenCLImplementation
extends AbstractMethodImplementation
implements Externalizable {
    private String kernel;
    private String workingDir;

    public OpenCLImplementation() {
    }

    public OpenCLImplementation(String kernel, String workingDir, Integer coreId, Integer implementationId, MethodResourceDescription annot) {
        super(coreId, implementationId, annot);
        this.kernel = kernel;
        this.workingDir = workingDir;
    }

    public String getKernel() {
        return this.kernel;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public AbstractMethodImplementation.MethodType getMethodType() {
        return AbstractMethodImplementation.MethodType.OPENCL;
    }

    @Override
    public String getMethodDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("[KERNEL=").append(this.kernel);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return super.toString() + " OpenCL Method with kernel " + this.kernel;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.kernel = (String)in.readObject();
        this.workingDir = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.kernel);
        out.writeObject(this.workingDir);
    }
}

