/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor.utils;

import es.bsc.compss.executor.Executor;
import es.bsc.compss.executor.ExecutorContext;
import es.bsc.compss.executor.types.Execution;
import es.bsc.compss.executor.utils.ExecutionPlatformMirror;
import es.bsc.compss.executor.utils.ResourceManager;
import es.bsc.compss.executor.utils.ThreadedProperties;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.exceptions.UnsufficientAvailableComputingUnitsException;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.util.RequestQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutionPlatform
implements ExecutorContext {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.ThreadPool");
    protected final InvocationContext context;
    protected final int size;
    protected final ResourceManager rm;
    protected final Thread[] workerThreads;
    protected final RequestQueue<Execution> queue;
    protected final Semaphore sem;
    protected final Map<Class<?>, ExecutionPlatformMirror> mirrors;

    public ExecutionPlatform(String platformName, InvocationContext context, int size, ResourceManager resManager) {
        LOGGER.info("Init JobsThreadPool");
        this.context = context;
        this.size = size;
        System.setProperties(new ThreadedProperties(System.getProperties()));
        this.queue = new RequestQueue();
        this.sem = new Semaphore(size);
        this.workerThreads = new Thread[size];
        for (int i = 0; i < size; ++i) {
            Executor executor = new Executor(context, this, "compute" + i){

                @Override
                public void run() {
                    super.run();
                    ExecutionPlatform.this.sem.release();
                }
            };
            Thread t = new Thread(executor);
            t.setName(platformName + " compute thread # " + i);
            this.workerThreads[i] = t;
        }
        this.rm = resManager;
        this.mirrors = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Execution exec) {
        RequestQueue<Execution> requestQueue = this.queue;
        synchronized (requestQueue) {
            this.queue.enqueue(exec);
        }
    }

    public void start() {
        LOGGER.info("Start threads of ThreadPool");
        for (Thread t : this.workerThreads) {
            t.start();
        }
        this.sem.acquireUninterruptibly(this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOGGER.info("Stopping Jobs Thread Pool");
        RequestQueue<Execution> requestQueue = this.queue;
        synchronized (requestQueue) {
            for (int i = 0; i < this.size; ++i) {
                this.queue.addToFront(null);
            }
            this.queue.wakeUpAll();
        }
        this.sem.acquireUninterruptibly(this.size);
        this.joinThreads();
        LOGGER.info("ThreadPool stopped");
        LOGGER.info("Stopping mirrors");
        for (ExecutionPlatformMirror mirror : this.mirrors.values()) {
            mirror.stop();
        }
    }

    private void joinThreads() {
        for (Thread t : this.workerThreads) {
            if (t == null) continue;
            try {
                t.join();
                t = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Runtime.getRuntime().gc();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Execution getJob() {
        return this.queue.dequeue();
    }

    @Override
    public ResourceManager.InvocationResources acquireResources(int jobId, ResourceDescription requirements) throws UnsufficientAvailableComputingUnitsException {
        return this.rm.acquireResources(jobId, requirements);
    }

    @Override
    public void releaseResources(int jobId) {
        this.rm.releaseResources(jobId);
    }

    @Override
    public ExecutionPlatformMirror getMirror(Class<?> invoker) {
        return this.mirrors.get(invoker);
    }

    @Override
    public void registerMirror(Class<?> invoker, ExecutionPlatformMirror mirror) {
        this.mirrors.put(invoker, mirror);
    }
}

