/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external.piped;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.executor.ExecutorContext;
import es.bsc.compss.executor.utils.PipePair;
import es.bsc.compss.executor.utils.PipedMirror;
import es.bsc.compss.executor.utils.ResourceManager;
import es.bsc.compss.invokers.external.commands.ExecuteTaskExternalCommand;
import es.bsc.compss.invokers.external.piped.PipedInvoker;
import es.bsc.compss.invokers.external.piped.commands.ExecuteTaskPipeCommand;
import es.bsc.compss.invokers.types.CParams;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class PythonInvoker
extends PipedInvoker {
    public PythonInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, ResourceManager.InvocationResources assignedResources, PipePair pipes) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources, pipes);
    }

    @Override
    protected ExecuteTaskExternalCommand getTaskExecutionCommand(InvocationContext context, Invocation invocation, String sandBox, ResourceManager.InvocationResources assignedResources) {
        ExecuteTaskPipeCommand taskExecution = new ExecuteTaskPipeCommand(invocation.getJobId());
        return taskExecution;
    }

    public static PipedMirror getMirror(InvocationContext context, ExecutorContext platform) {
        int threads = platform.getSize();
        return new PythonMirror(context, threads);
    }

    private static class PythonMirror
    extends PipedMirror {
        protected static final String BINDINGS_RELATIVE_PATH = File.separator + "Bindings" + File.separator + "bindings-common" + File.separator + "lib";
        public static final String PYCOMPSS_RELATIVE_PATH = File.separator + "Bindings" + File.separator + "python";
        private static final String WORKER_PY_RELATIVE_PATH = File.separator + "pycompss" + File.separator + "worker" + File.separator + "piper_worker.py";
        private static final String ENV_LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
        private static final String ENV_PYTHONPATH = "PYTHONPATH";
        private final PythonParams pyParams;
        private final String pyCOMPSsHome;

        public PythonMirror(InvocationContext context, int size) {
            super(context, size);
            this.pyParams = (PythonParams)context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
            String installDir = context.getInstallDir();
            this.pyCOMPSsHome = installDir + PYCOMPSS_RELATIVE_PATH + File.separator + this.pyParams.getPythonVersion();
            this.init(context);
        }

        @Override
        public String getLaunchCommand(InvocationContext context) {
            int i;
            StringBuilder cmd = new StringBuilder();
            cmd.append((Object)COMPSsConstants.Lang.PYTHON).append(" ");
            cmd.append(this.pyParams.getPythonVirtualEnvironment()).append(" ");
            cmd.append(this.pyParams.getPythonPropagateVirtualEnvironment()).append(" ");
            cmd.append(Tracer.isActivated()).append(" ");
            cmd.append(this.pyParams.getPythonInterpreter()).append(" ").append("-u").append(" ");
            cmd.append(this.pyCOMPSsHome).append(WORKER_PY_RELATIVE_PATH).append(" ");
            cmd.append(LOGGER.isDebugEnabled()).append(" ");
            cmd.append(Tracer.isActivated()).append(" ");
            cmd.append(context.getStorageConf()).append(" ");
            cmd.append(this.size).append(" ");
            String computePipes = this.basePipePath + "compute";
            for (i = 0; i < this.size; ++i) {
                cmd.append(computePipes).append(i).append(".outbound").append(" ");
            }
            for (i = 0; i < this.size; ++i) {
                cmd.append(computePipes).append(i).append(".inbound").append(" ");
            }
            return cmd.toString();
        }

        @Override
        public Map<String, String> getEnvironment(InvocationContext context) {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("PYCOMPSS_HOME", this.pyCOMPSsHome);
            String pythonPath = System.getenv(ENV_PYTHONPATH);
            pythonPath = pythonPath == null ? this.pyCOMPSsHome + ":" + this.pyParams.getPythonPath() + ":" + context.getAppDir() : this.pyCOMPSsHome + ":" + this.pyParams.getPythonPath() + ":" + context.getAppDir() + pythonPath;
            env.put(ENV_PYTHONPATH, pythonPath);
            String ldLibraryPath = System.getenv(ENV_LD_LIBRARY_PATH);
            CParams cParams = (CParams)context.getLanguageParams(COMPSsConstants.Lang.C);
            ldLibraryPath = ldLibraryPath == null ? cParams.getLibraryPath() : ldLibraryPath.concat(":" + cParams.getLibraryPath());
            String bindingsHome = context.getInstallDir() + BINDINGS_RELATIVE_PATH;
            ldLibraryPath = ldLibraryPath.concat(":" + bindingsHome);
            env.put(ENV_LD_LIBRARY_PATH, ldLibraryPath);
            return env;
        }

        @Override
        protected String getPBWorkingDir(InvocationContext context) {
            String workingDir = super.getPBWorkingDir(context);
            if (Tracer.isActivated() && !new File(workingDir = workingDir + "python").mkdirs()) {
                ErrorManager.error("Could not create working dir for python tracefiles, path: " + workingDir);
            }
            return workingDir;
        }
    }
}

