/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.nio.NIOURI;
import es.bsc.compss.nio.commands.NIOData;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Stream;
import es.bsc.compss.types.execution.InvocationParam;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.util.List;

public class NIOParam
implements Externalizable,
InvocationParam {
    private String dataMgmtId;
    private DataType type;
    private Stream stream;
    private String prefix;
    private String name;
    private boolean preserveSourceData;
    private boolean writeFinalValue;
    private Object value;
    private NIOData source;
    private String originalName;
    private Class<?> valueClass;

    public NIOParam() {
    }

    public NIOParam(String dataMgmtId, DataType type, Stream stream, String prefix, String name, boolean preserveSourceData, boolean writeFinalValue, Object value, NIOData data, String originalName) {
        this.dataMgmtId = dataMgmtId;
        this.type = type;
        this.stream = stream;
        this.prefix = prefix;
        this.name = name;
        this.value = value;
        this.preserveSourceData = preserveSourceData;
        this.writeFinalValue = writeFinalValue;
        this.source = data;
        this.originalName = originalName;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public Stream getStream() {
        return this.stream;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPreserveSourceData() {
        return this.preserveSourceData;
    }

    @Override
    public boolean isWriteFinalValue() {
        return this.writeFinalValue;
    }

    public NIOData getData() {
        return this.source;
    }

    @Override
    public String getDataMgmtId() {
        return this.dataMgmtId;
    }

    @Override
    public String getSourceDataId() {
        return this.source.getDataMgmtId();
    }

    public List<NIOURI> getSources() {
        return this.source.getSources();
    }

    @Override
    public String getOriginalName() {
        return this.originalName;
    }

    @Override
    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setType(DataType type) {
        this.type = type;
    }

    @Override
    public void setValue(Object o) {
        this.value = o;
    }

    @Override
    public void setValueClass(Class<?> valueClass) {
        this.valueClass = valueClass;
    }

    @Override
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dataMgmtId = (String)in.readObject();
        this.type = (DataType)((Object)in.readObject());
        this.stream = (Stream)((Object)in.readObject());
        this.prefix = in.readUTF();
        this.name = in.readUTF();
        this.preserveSourceData = in.readBoolean();
        this.writeFinalValue = in.readBoolean();
        this.originalName = (String)in.readObject();
        this.value = in.readObject();
        try {
            this.source = (NIOData)in.readObject();
        }
        catch (OptionalDataException e) {
            this.source = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.dataMgmtId);
        out.writeObject((Object)this.type);
        out.writeObject((Object)this.stream);
        out.writeUTF(this.prefix);
        out.writeUTF(this.name);
        out.writeBoolean(this.preserveSourceData);
        out.writeBoolean(this.writeFinalValue);
        out.writeObject(this.originalName);
        out.writeObject(this.value);
        if (this.source != null) {
            out.writeObject(this.source);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[PARAM");
        sb.append("[MGMT ID = ").append(this.dataMgmtId).append("]");
        sb.append("[TYPE = ").append((Object)this.type).append("]");
        sb.append("[STREAM = ").append((Object)this.stream).append("]");
        sb.append("[PREFIX = ").append(this.prefix).append("]");
        sb.append("[NAME = ").append(this.name).append("]");
        sb.append("[PRESERVE SOURCE DATA = ").append(this.preserveSourceData).append("]");
        sb.append("[WRITE FINAL VALUE = ").append(this.writeFinalValue).append("]");
        sb.append("[ORIGINAL NAME = ").append(this.originalName).append("]");
        sb.append("[VALUE = ").append(this.value).append("]");
        sb.append("[DATA ").append(this.source).append("]");
        sb.append("]");
        return sb.toString();
    }
}

