/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NIOTask
implements Externalizable,
Invocation {
    private COMPSsConstants.Lang lang;
    private boolean workerDebug;
    private AbstractMethodImplementation impl;
    private LinkedList<NIOParam> arguments;
    private NIOParam target;
    private LinkedList<NIOParam> results;
    private MethodResourceDescription reqs;
    private List<String> slaveWorkersNodeNames;
    private int taskId;
    private Implementation.TaskType taskType;
    private int jobId;
    private Job.JobHistory history;
    private int transferGroupId;
    private int numReturns;

    public NIOTask() {
    }

    public NIOTask(String lang, boolean workerDebug, AbstractMethodImplementation impl, boolean hasTarget, int numReturns, LinkedList<NIOParam> params, int numParams, MethodResourceDescription reqs, List<String> slaveWorkersNodeNames, int taskId, Implementation.TaskType taskType, int jobId, Job.JobHistory hist, int transferGroupId) {
        NIOParam p;
        this.lang = COMPSsConstants.Lang.valueOf(lang.toUpperCase());
        this.workerDebug = workerDebug;
        this.impl = impl;
        this.arguments = new LinkedList();
        this.results = new LinkedList();
        Iterator<NIOParam> paramItr = params.descendingIterator();
        if (this.lang == COMPSsConstants.Lang.PYTHON) {
            if (hasTarget) {
                NIOParam p2;
                this.target = p2 = paramItr.next();
            }
            for (int rIdx = 0; rIdx < numReturns; ++rIdx) {
                p = paramItr.next();
                this.results.addFirst(p);
            }
        } else {
            for (int rIdx = 0; rIdx < numReturns; ++rIdx) {
                p = paramItr.next();
                this.results.addFirst(p);
            }
            if (hasTarget) {
                NIOParam p3;
                this.target = p3 = paramItr.next();
            }
        }
        while (paramItr.hasNext()) {
            NIOParam p4 = paramItr.next();
            this.arguments.addFirst(p4);
        }
        this.reqs = reqs;
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
        this.taskType = taskType;
        this.taskId = taskId;
        this.jobId = jobId;
        this.history = hist;
        this.transferGroupId = transferGroupId;
        this.numReturns = numReturns;
    }

    @Override
    public COMPSsConstants.Lang getLang() {
        return this.lang;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.workerDebug;
    }

    public String getMethodDefinition() {
        return this.impl.getMethodDefinition();
    }

    @Override
    public AbstractMethodImplementation getMethodImplementation() {
        return this.impl;
    }

    public List<NIOParam> getParams() {
        return this.arguments;
    }

    @Override
    public NIOParam getTarget() {
        return this.target;
    }

    public List<NIOParam> getResults() {
        return this.results;
    }

    public int getNumReturns() {
        return this.numReturns;
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public Implementation.TaskType getTaskType() {
        return this.taskType;
    }

    @Override
    public int getJobId() {
        return this.jobId;
    }

    @Override
    public Job.JobHistory getHistory() {
        return this.history;
    }

    public int getTransferGroupId() {
        return this.transferGroupId;
    }

    @Override
    public MethodResourceDescription getRequirements() {
        return this.reqs;
    }

    @Override
    public List<String> getSlaveNodesNames() {
        return this.slaveWorkersNodeNames;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lang = COMPSsConstants.Lang.valueOf((String)in.readObject());
        this.workerDebug = in.readBoolean();
        this.impl = (AbstractMethodImplementation)in.readObject();
        this.numReturns = in.readInt();
        this.arguments = (LinkedList)in.readObject();
        this.target = (NIOParam)in.readObject();
        this.results = (LinkedList)in.readObject();
        this.reqs = (MethodResourceDescription)in.readObject();
        this.slaveWorkersNodeNames = (ArrayList)in.readObject();
        this.taskType = Implementation.TaskType.values()[in.readInt()];
        this.taskId = in.readInt();
        this.jobId = in.readInt();
        this.history = (Job.JobHistory)((Object)in.readObject());
        this.transferGroupId = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.lang.toString());
        out.writeBoolean(this.workerDebug);
        out.writeObject(this.impl);
        out.writeInt(this.numReturns);
        out.writeObject(this.arguments);
        out.writeObject(this.target);
        out.writeObject(this.results);
        out.writeObject(this.reqs);
        out.writeObject(this.slaveWorkersNodeNames);
        out.writeInt(this.taskType.ordinal());
        out.writeInt(this.taskId);
        out.writeInt(this.jobId);
        out.writeObject((Object)this.history);
        out.writeInt(this.transferGroupId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[TASK ");
        sb.append("[LANG= ").append((Object)this.lang).append("]");
        sb.append("[TASK TYPE= ").append((Object)this.taskType).append("]");
        sb.append("[TASK ID= ").append(this.taskId).append("]");
        sb.append("[JOB ID= ").append(this.jobId).append("]");
        sb.append("[HISTORY= ").append((Object)this.history).append("]");
        sb.append("[IMPLEMENTATION= ").append(this.impl.getMethodDefinition()).append("]");
        sb.append(" [PARAMS ");
        for (NIOParam param : this.arguments) {
            sb.append(param);
        }
        if (this.target != null) {
            sb.append(this.target);
        }
        for (NIOParam param : this.results) {
            sb.append(param);
        }
        sb.append("]");
        sb.append("[REQUIREMENTS= ").append(this.reqs).append("]");
        sb.append("[SLAVE_WORKERS_NODE_NAMES= ");
        for (String name : this.slaveWorkersNodeNames) {
            sb.append("[SW_NAME=").append(name).append("]");
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

