/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.components;

import es.bsc.compss.util.Serializer;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;
import storage.StorageObject;

public class DataRegister {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker");
    private boolean inMemory;
    private Object value;
    private String storageId;
    private final List<String> files = new LinkedList<String>();
    private final List<BindingLocation> bindingLocations = new LinkedList<BindingLocation>();

    public void setValue(Object value) {
        if (value instanceof StorageObject) {
            this.storageId = ((StorageObject)value).getID();
        }
        this.value = value;
        this.inMemory = true;
    }

    public void removeValue() {
        this.inMemory = false;
        this.value = null;
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    public Object getValue() {
        return this.value;
    }

    public Object loadValue() throws IOException, ClassNotFoundException, NoSourcesException, StorageException {
        if (this.storageId != null) {
            LOGGER.debug("   - Retrieving psco " + this.storageId + " from Storage");
            if (Tracer.isActivated()) {
                Tracer.emitEvent(Tracer.Event.STORAGE_GETBYID.getId(), Tracer.Event.STORAGE_GETBYID.getType());
            }
            try {
                Object obj;
                Object object = obj = StorageItf.getByID(this.storageId);
                return object;
            }
            catch (StorageException e) {
                LOGGER.error("Cannot getByID PSCO " + this.storageId, (Throwable)e);
                throw e;
            }
            finally {
                if (Tracer.isActivated()) {
                    Tracer.emitEvent(0L, Tracer.Event.STORAGE_GETBYID.getType());
                }
            }
        }
        IOException io = null;
        ClassNotFoundException cnf = null;
        if (!this.inMemory) {
            for (String path : this.files) {
                try {
                    this.setValue(Serializer.deserialize(path));
                    return this.value;
                }
                catch (IOException ioe) {
                    io = ioe;
                }
                catch (ClassNotFoundException cnfe) {
                    cnf = cnfe;
                }
            }
            if (cnf != null) {
                throw cnf;
            }
            if (io != null) {
                throw io;
            }
        } else {
            return this.value;
        }
        throw new NoSourcesException();
    }

    public Object cloneValue() throws StorageException, ClassNotFoundException, IOException, NoSourcesException {
        if (this.storageId != null) {
            return StorageItf.getByID(this.storageId);
        }
        if (!this.inMemory) {
            IOException io = null;
            ClassNotFoundException cnf = null;
            for (String path : this.files) {
                try {
                    return Serializer.deserialize(path);
                }
                catch (IOException ioe) {
                    io = ioe;
                }
                catch (ClassNotFoundException cnfe) {
                    cnf = cnfe;
                }
            }
            if (cnf != null) {
                throw cnf;
            }
            if (io != null) {
                throw io;
            }
        } else {
            return Serializer.deserialize(Serializer.serialize(this.value));
        }
        throw new NoSourcesException();
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public String getStorageId() {
        return this.storageId;
    }

    public void addFileLocation(String file) {
        this.files.add(file);
    }

    public void removeFileLocation(String path) {
        this.files.remove(path);
    }

    public List<String> getFileLocations() {
        return this.files;
    }

    public void addBindingLocation(BindingLocation loc) {
        this.bindingLocations.add(loc);
    }

    public boolean isLocal() {
        return this.inMemory || !this.files.isEmpty() || this.storageId != null || !this.bindingLocations.isEmpty();
    }

    public void clear() {
        this.storageId = null;
        this.removeValue();
        for (String path : this.files) {
            try {
                File f = new File(path);
                f.delete();
            }
            catch (Exception exception) {}
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t Memory:");
        if (this.inMemory) {
            sb.append("<").append(this.value).append(">");
        } else {
            sb.append(" NOT PRESENT");
        }
        sb.append("\n");
        sb.append("\t Bindings:\n");
        for (BindingLocation bLoc : this.bindingLocations) {
            sb.append("\t-").append(bLoc.toString()).append("\n");
        }
        sb.append("\t Storage ID:").append(this.storageId).append("\n");
        sb.append("\t Files:\n");
        for (String file : this.files) {
            sb.append("\t-").append(file).append("\n");
        }
        return sb.toString();
    }

    public static class NoSourcesException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoSourcesException() {
            super("No sources form where to load the value");
        }
    }

    public static interface BindingLocation {
    }
}

