/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.components;

import es.bsc.compss.data.DataManager;
import es.bsc.compss.data.DataProvider;
import es.bsc.compss.nio.worker.components.DataRegister;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamURI;
import es.bsc.compss.types.execution.exceptions.InitializationException;
import es.bsc.compss.util.BindingDataManager;
import es.bsc.compss.util.ErrorManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;

public class DataManagerImpl
implements DataManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker");
    private final DataProvider provider;
    private final String hostName;
    private final String baseFolder;
    private final String storageConf;
    private final HashMap<String, DataRegister> registry = new HashMap();

    public DataManagerImpl(String hostName, String baseFolder, DataProvider provider) {
        this.provider = provider;
        this.hostName = hostName;
        this.baseFolder = baseFolder;
        String storageCfg = System.getProperty("compss.storage.conf");
        if (storageCfg == null || storageCfg.equals("") || storageCfg.equals("null")) {
            storageCfg = null;
        }
        this.storageConf = storageCfg;
    }

    @Override
    public void init() throws InitializationException {
        if (this.storageConf != null) {
            try {
                StorageItf.init(this.storageConf);
            }
            catch (StorageException e) {
                ErrorManager.fatal("Error loading storage configuration file: " + this.storageConf, e);
            }
        } else {
            LOGGER.warn("No storage configuration file passed");
        }
    }

    @Override
    public String getStorageConf() {
        return this.storageConf;
    }

    @Override
    public void stop() {
        if (this.storageConf != null) {
            try {
                StorageItf.finish();
            }
            catch (StorageException e) {
                LOGGER.error("Error releasing storage library: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObsoletes(List<String> obsoletes) {
        try {
            for (String name : obsoletes) {
                if (name.startsWith(File.separator)) {
                    LOGGER.debug("Removing file " + name);
                    File f = new File(name);
                    if (!f.delete()) {
                        LOGGER.error("Error removing file " + f.getAbsolutePath());
                    }
                }
                String dataName = new File(name).getName();
                DataRegister register = null;
                Object object = this.registry;
                synchronized (object) {
                    register = this.registry.remove(dataName);
                    LOGGER.debug(dataName + " removed from cache.");
                }
                if (register != null) {
                    object = register;
                    synchronized (object) {
                        register.clear();
                    }
                }
                LOGGER.debug(name + " removed from cache.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception", (Throwable)e);
        }
    }

    @Override
    public void fetchParam(InvocationParam param, int paramIdx, DataManager.FetchDataListener tt) {
        switch (param.getType()) {
            case OBJECT_T: {
                this.fetchObject(param, paramIdx, tt);
                break;
            }
            case PSCO_T: {
                this.fetchPSCO(param, paramIdx, tt);
                break;
            }
            case BINDING_OBJECT_T: {
                this.fetchBindingObject(param, paramIdx, tt);
                break;
            }
            case FILE_T: {
                this.fetchFile(param, paramIdx, tt);
                break;
            }
            case EXTERNAL_PSCO_T: {
                tt.fetchedValue();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataRegister getOriginalDataRegister(InvocationParam param) {
        DataRegister originalRegister;
        String originalRename = param.getSourceDataId();
        boolean newRegister = false;
        Object object = this.registry;
        synchronized (object) {
            originalRegister = this.registry.get(originalRename);
            if (originalRegister == null) {
                originalRegister = new DataRegister();
                this.registry.put(originalRename, originalRegister);
                newRegister = true;
            }
        }
        if (newRegister) {
            object = originalRegister;
            synchronized (object) {
                for (InvocationParamURI invocationParamURI : param.getSources()) {
                    switch (invocationParamURI.getProtocol()) {
                        case FILE_URI: {
                            if (!invocationParamURI.isHost(this.hostName)) break;
                            originalRegister.addFileLocation(invocationParamURI.getPath());
                            break;
                        }
                        case PERSISTENT_URI: {
                            String pscoId = invocationParamURI.getPath();
                            originalRegister.setStorageId(pscoId);
                            break;
                        }
                        case OBJECT_URI: 
                        case BINDING_URI: {
                            if (!invocationParamURI.isHost(this.hostName)) break;
                            LOGGER.error("WORKER IS NOT AWARE OF THE PRESENCE OF A" + (invocationParamURI.getProtocol() == DataLocation.Protocol.OBJECT_URI ? "N OBJECT " : " BINDING OBJECT "));
                            break;
                        }
                        case SHARED_URI: {
                            break;
                        }
                    }
                }
            }
        }
        return originalRegister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchObject(InvocationParam param, int index, DataManager.FetchDataListener tt) {
        String finalRename = param.getDataMgmtId();
        String originalRename = param.getSourceDataId();
        LOGGER.debug("   - " + finalRename + " registered as object.");
        DataRegister originalRegister = this.getOriginalDataRegister(param);
        LOGGER.debug("   - Checking if " + finalRename + " is in cache.");
        DataRegister dataRegister = originalRegister;
        synchronized (dataRegister) {
            if (originalRegister.isLocal()) {
                if (finalRename.equals(originalRename)) {
                    try {
                        originalRegister.loadValue();
                    }
                    catch (Exception e) {
                        LOGGER.error(e);
                    }
                } else {
                    try {
                        Object o;
                        if (param.isPreserveSourceData()) {
                            o = originalRegister.cloneValue();
                        } else {
                            o = originalRegister.loadValue();
                            originalRegister.removeValue();
                        }
                        DataRegister dr = new DataRegister();
                        dr.setValue(o);
                        this.registry.put(finalRename, dr);
                    }
                    catch (Exception e) {
                        LOGGER.error(e);
                    }
                }
                this.fetchedLocalParameter(param, index, tt);
            } else {
                this.transferParameter(param, index, tt);
            }
        }
    }

    private void fetchBindingObject(InvocationParam param, int index, DataManager.FetchDataListener tt) {
        String name = (String)param.getValue();
        LOGGER.debug("   - " + name + " registered as binding object.");
        String[] extObjVals = name.split("#");
        String value = extObjVals[0];
        int type = Integer.parseInt(extObjVals[1]);
        int elements = Integer.parseInt(extObjVals[2]);
        boolean askTransfer = false;
        LOGGER.debug("   - Checking if " + value + " is in binding cache.");
        boolean cached = BindingDataManager.isInBinding(value);
        if (!cached) {
            int res;
            BindingObject bo;
            boolean locationsInCache = false;
            LOGGER.debug("   - Checking if " + value + " locations are catched");
            for (InvocationParamURI invocationParamURI : param.getSources()) {
                String string = invocationParamURI.getPath();
                bo = BindingObject.generate(string);
                if (!BindingDataManager.isInBinding(bo.getId())) continue;
                LOGGER.debug("   - Parameter " + index + "(" + value + ") location found in cache.");
                if (param.isPreserveSourceData()) {
                    LOGGER.debug("   - Parameter " + index + "(" + value + ") preserves sources. CACHE-COPYING");
                    res = BindingDataManager.copyCachedData(bo.getId(), value);
                    if (res != 0) {
                        LOGGER.error("CACHE-COPY from " + bo.getId() + " to " + value + " has failed. ");
                        break;
                    }
                } else {
                    LOGGER.debug("   - Parameter " + index + "(" + value + ") erases sources. CACHE-MOVING");
                    res = BindingDataManager.moveCachedData(bo.getId(), value);
                    if (res != 0) {
                        LOGGER.error("CACHE-MOVE from " + string + " to " + value + " has failed. ");
                        break;
                    }
                }
                locationsInCache = true;
                break;
            }
            if (!locationsInCache) {
                boolean existInHost = false;
                LOGGER.debug("   - Checking if " + name + " locations are in host");
                for (InvocationParamURI invocationParamURI : param.getSources()) {
                    if (!invocationParamURI.isHost(this.hostName)) continue;
                    bo = BindingObject.generate(invocationParamURI.getPath());
                    LOGGER.debug("   - Parameter " + index + "(" + name + ") found at host with location " + invocationParamURI.getPath() + " Checking if in cache...");
                    if (BindingDataManager.isInBinding(bo.getId())) {
                        LOGGER.debug("   - Parameter " + index + "(" + value + ") location found in cache.");
                        if (param.isPreserveSourceData()) {
                            LOGGER.debug("   - Parameter " + index + "(" + value + ") preserves sources. CACHE-COPYING");
                            res = BindingDataManager.copyCachedData(bo.getId(), value);
                            if (res != 0) {
                                LOGGER.error("CACHE-COPY from " + bo.getId() + " to " + value + " has failed. ");
                            }
                        } else {
                            LOGGER.debug("   - Parameter " + index + "(" + value + ") erases sources. CACHE-MOVING");
                            res = BindingDataManager.moveCachedData(bo.getId(), value);
                            if (res != 0) {
                                LOGGER.error("CACHE-MOVE from " + bo.getId() + " to " + value + " has failed. ");
                            }
                        }
                        existInHost = true;
                        continue;
                    }
                    LOGGER.debug("   - Parameter " + index + "(" + name + ") not in cache.");
                    if (!new File(this.baseFolder + File.separator + invocationParamURI.getPath()).exists()) continue;
                    res = BindingDataManager.loadFromFile(value, invocationParamURI.getPath(), type, elements);
                    if (res == 0) {
                        existInHost = true;
                        continue;
                    }
                    LOGGER.error("Error loading " + param.getValue() + " from file " + invocationParamURI.getPath());
                }
                if (!existInHost) {
                    askTransfer = true;
                }
            }
        }
        this.askForTransfer(askTransfer, param, index, tt);
    }

    private void fetchPSCO(InvocationParam param, int paramIdx, DataManager.FetchDataListener tt) {
        String finalRename = param.getDataMgmtId();
        String pscoId = (String)param.getValue();
        LOGGER.debug("   - " + pscoId + " registered as PSCO.");
        DataRegister dr = new DataRegister();
        dr.setStorageId(pscoId);
        this.registry.put(finalRename, dr);
        tt.fetchedValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFile(InvocationParam param, int index, DataManager.FetchDataListener tt) {
        DataRegister originalRegister;
        LOGGER.debug("   - " + (String)param.getValue() + " registered as file.");
        String originalName = param.getSourceDataId();
        String expectedFileLocation = param.getValue().toString();
        LOGGER.debug("   - Checking if file " + (String)param.getValue() + " exists.");
        File f = new File(expectedFileLocation);
        if (f.exists()) {
            LOGGER.info("- Parameter " + index + "(" + expectedFileLocation + ") already exists.");
            this.fetchedLocalParameter(param, index, tt);
            return;
        }
        LOGGER.debug("   - Checking if " + expectedFileLocation + " exists in worker");
        DataRegister dataRegister = originalRegister = this.getOriginalDataRegister(param);
        synchronized (dataRegister) {
            if (originalRegister.isLocal()) {
                LOGGER.debug("   - Parameter " + index + "(" + expectedFileLocation + ") found at host.");
                File target = new File(expectedFileLocation);
                List<String> files = originalRegister.getFileLocations();
                for (String path : files) {
                    File source = new File(path);
                    try {
                        LOGGER.debug("   - Parameter " + index + "(" + expectedFileLocation + ") " + (param.isPreserveSourceData() ? "preserves sources. COPYING" : "erases sources. MOVING"));
                        LOGGER.debug("         Source: " + source);
                        LOGGER.debug("         Target: " + target);
                        if (param.isPreserveSourceData()) {
                            Files.copy(source.toPath(), target.toPath(), new CopyOption[0]);
                        } else {
                            try {
                                Files.move(source.toPath(), target.toPath(), StandardCopyOption.ATOMIC_MOVE);
                            }
                            catch (AtomicMoveNotSupportedException amnse) {
                                LOGGER.warn("WARN: AtomicMoveNotSupportedException. File cannot be atomically moved. Trying to move without atomic");
                                Files.move(source.toPath(), target.toPath(), new CopyOption[0]);
                            }
                            originalRegister.removeFileLocation(path);
                        }
                        DataRegister dr = new DataRegister();
                        dr.addFileLocation(path);
                        this.registry.put(originalName, dr);
                        this.fetchedLocalParameter(param, index, tt);
                        return;
                    }
                    catch (IOException ioe) {
                        LOGGER.error("IOException", (Throwable)ioe);
                    }
                }
            } else {
                LOGGER.info("- Parameter " + index + "(" + expectedFileLocation + ") does not exist, requesting data transfer");
                this.transferParameter(param, index, tt);
            }
        }
    }

    @Override
    public void loadParam(InvocationParam param) throws Exception {
        switch (param.getType()) {
            case OBJECT_T: 
            case PSCO_T: {
                this.loadObject(param);
                break;
            }
            case BINDING_OBJECT_T: 
            case FILE_T: 
            case EXTERNAL_PSCO_T: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadObject(InvocationParam param) throws Exception {
        DataRegister register;
        String rename = param.getDataMgmtId();
        Object o = null;
        Object object = this.registry;
        synchronized (object) {
            register = this.registry.get(rename);
        }
        object = register;
        synchronized (object) {
            o = register.loadValue();
        }
        param.setValue(o);
    }

    @Override
    public void storeParam(InvocationParam param) {
        switch (param.getType()) {
            case OBJECT_T: {
                this.storeObject(param.getDataMgmtId(), param.getValue());
                break;
            }
            case PSCO_T: 
            case EXTERNAL_PSCO_T: {
                break;
            }
            case BINDING_OBJECT_T: {
                break;
            }
            case FILE_T: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeObject(String rename, Object value) {
        DataRegister register;
        Object object = this.registry;
        synchronized (object) {
            register = this.registry.get(rename);
            if (register == null) {
                register = new DataRegister();
                this.registry.put(rename, register);
            }
        }
        object = register;
        synchronized (object) {
            register.setValue(value);
        }
    }

    @Override
    public void storeValue(String name, Object value) {
        this.storeObject(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeFile(String rename, String path) {
        DataRegister register;
        Object object = this.registry;
        synchronized (object) {
            register = this.registry.get(rename);
            if (register == null) {
                register = new DataRegister();
                this.registry.put(rename, register);
            }
        }
        object = register;
        synchronized (object) {
            register.addFileLocation(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(String dataMgmtId) {
        DataRegister register;
        Object o = null;
        Object object = this.registry;
        synchronized (object) {
            register = this.registry.get(dataMgmtId);
        }
        object = register;
        synchronized (object) {
            try {
                o = register.loadValue();
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (DataRegister.NoSourcesException noSourcesException) {
            }
            catch (StorageException storageException) {
                // empty catch block
            }
        }
        return o;
    }

    private void askForTransfer(boolean askTransfer, InvocationParam param, int index, DataManager.FetchDataListener tt) {
        if (askTransfer) {
            this.transferParameter(param, index, tt);
        } else {
            this.fetchedLocalParameter(param, index, tt);
        }
    }

    private void fetchedLocalParameter(InvocationParam param, int index, DataManager.FetchDataListener tt) {
        LOGGER.info("- Parameter " + index + "(" + (String)param.getValue() + ") already exists.");
        tt.fetchedValue();
    }

    private void transferParameter(InvocationParam param, int index, DataManager.FetchDataListener tt) {
        LOGGER.info("- Parameter " + index + "(" + (String)param.getValue() + ") does not exist, requesting data transfer");
        this.provider.askForTransfer(param, index, tt);
    }
}

