/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.stage;

import es.bsc.comm.CommProperties;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.InternalConnection;
import es.bsc.comm.exceptions.CommException;
import es.bsc.comm.exceptions.SerializerException;
import es.bsc.comm.exceptions.StageException;
import es.bsc.comm.exceptions.ViabilityException;
import es.bsc.comm.stage.Token;
import es.bsc.comm.stage.Transfer;
import es.bsc.comm.util.ByteBufferOutputStream;
import es.bsc.comm.util.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Reception
extends Transfer {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.comm.Stage");
    private static final Object tokenLock = new Object();
    private static Integer tokens = CommProperties.getMaxReceives();
    private static LinkedList<InternalConnection> pausedConnections = new LinkedList();
    private boolean destInit;
    private OutputStream streamOut;
    private boolean hasToken = false;
    private Token token;

    public Reception() {
        super(true);
        this.remainingSize = 0L;
        this.destInit = false;
    }

    public Reception(boolean notifyErrors) {
        super(notifyErrors);
        this.remainingSize = 0L;
        this.destInit = false;
    }

    public Reception(Transfer.Destination destination) {
        super(true);
        this.type = Transfer.Type.DATA;
        this.destination = destination;
        this.destInit = true;
    }

    public Reception(Transfer.Destination destination, boolean notifyErrors) {
        super(notifyErrors);
        this.type = Transfer.Type.DATA;
        this.destination = destination;
        this.destInit = true;
    }

    public Reception(Transfer.Type type) {
        super(true);
        this.type = type;
        this.destination = Transfer.Destination.OBJECT;
        this.destInit = false;
    }

    public Reception(Transfer.Type type, boolean notifyErrors) {
        super(notifyErrors);
        this.type = type;
        this.destination = Transfer.Destination.OBJECT;
        this.destInit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void increaseTokens() {
        Object object = tokenLock;
        synchronized (object) {
            tokens = tokens + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decreaseTokens() {
        Object object = tokenLock;
        synchronized (object) {
            tokens = tokens - 1;
        }
    }

    public void initTransfer(Token t) throws FileNotFoundException {
        byte[] header = t.get(16);
        ByteBuffer bb = ByteBuffer.wrap(header);
        long size = bb.getLong();
        if (!this.destInit) {
            this.destInit = true;
            this.type = Transfer.Type.values()[bb.getInt()];
            this.destination = Transfer.Destination.values()[bb.getInt()];
        }
        this.setSize(size);
        this.openStream();
    }

    private void openStream() throws FileNotFoundException {
        if (this.destination == Transfer.Destination.FILE) {
            this.streamOut = new FileOutputStream(this.getFileName(), false);
        } else if (this.destination == Transfer.Destination.BYTEBUFFER) {
            ByteBuffer bb = ByteBuffer.allocateDirect((int)this.totalSize);
            this.streamOut = new ByteBufferOutputStream(bb);
        } else {
            this.streamOut = new ByteArrayOutputStream((int)this.totalSize);
        }
    }

    private void write(Token t) throws StageException {
        try {
            long length = Math.min(this.remainingSize, (long)t.length());
            byte[] content = t.get((int)length);
            this.streamOut.write(content);
            this.remainingSize -= (long)content.length;
        }
        catch (IOException ioe) {
            throw new StageException(ioe);
        }
        if (this.remainingSize == 0L) {
            try {
                this.closeStream();
            }
            catch (SerializerException | IOException e) {
                throw new StageException(e);
            }
        }
    }

    private void closeStream() throws IOException, SerializerException {
        if (this.destination == Transfer.Destination.OBJECT || this.destination == Transfer.Destination.ARRAY) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.streamOut;
            this.array = baos.toByteArray();
            if (this.destination == Transfer.Destination.OBJECT) {
                this.object = Serializer.deserialize(this.array);
            }
        } else if (this.destination == Transfer.Destination.BYTEBUFFER) {
            ByteBufferOutputStream bbos = (ByteBufferOutputStream)this.streamOut;
            this.buffer = bbos.getByteBuffer();
        }
        try {
            this.streamOut.close();
        }
        catch (IOException e) {
            LOGGER.error("Error closing output stream on connection " + this, (Throwable)e);
        }
    }

    public void setReceptionDefaultFileName(String fname) {
        this.fileName = fname;
    }

    @Override
    public Transfer.Direction getDirection() {
        return Transfer.Direction.RECEIVE;
    }

    @Override
    public void start(InternalConnection connection, List<ByteBuffer> received, List<ByteBuffer> transmit) {
        this.token = new Token();
        Reception.decreaseTokens();
        this.hasToken = true;
    }

    @Override
    public void progress(InternalConnection connection, List<ByteBuffer> received, List<ByteBuffer> transmit) throws StageException {
        while (!this.token.isCompletelyFilled() && !received.isEmpty()) {
            this.loadToken(this.token, received);
            if (!this.token.isCompletelyFilled()) continue;
            if (!this.destInit || !this.sizeInit) {
                try {
                    this.initTransfer(this.token);
                }
                catch (FileNotFoundException fnfe) {
                    throw new StageException(fnfe);
                }
            }
            this.write(this.token);
            if (this.remainingSize <= 0L) continue;
            this.token = new Token();
        }
    }

    @Override
    public boolean checkViability(boolean closedCommunication, List<ByteBuffer> received, List<ByteBuffer> transmit) throws ViabilityException {
        if (!closedCommunication || !received.isEmpty()) {
            return tokens > 0;
        }
        throw new ViabilityException("Channel was already closed (" + closedCommunication + ") or buffer if empty (" + received.isEmpty() + ") for connection " + this);
    }

    @Override
    public void pause(InternalConnection ic) {
        pausedConnections.add(ic);
    }

    @Override
    public boolean isComplete(List<ByteBuffer> received, List<ByteBuffer> transmit) {
        return this.sizeInit && this.remainingSize == 0L;
    }

    @Override
    public void notifyCompletion(Connection c, EventManager<?> em) {
        LOGGER.info("Reception stage " + this + " completed in connection " + c.hashCode());
        if (this.isData()) {
            em.dataReceived(c, this);
        } else if (this.isCommand()) {
            em.commandReceived(c, this);
        }
        Reception.increaseTokens();
        this.hasToken = false;
        if (!pausedConnections.isEmpty()) {
            InternalConnection ic = pausedConnections.removeFirst();
            ic.resume();
        }
    }

    @Override
    public void notifyError(Connection c, EventManager<?> em, CommException exc) {
        LOGGER.error("Error notified in Reception stage " + this + " in connection " + c.hashCode());
        if (super.isNotifyErrors()) {
            em.notifyError(c, this, exc);
        }
        if (this.hasToken) {
            Reception.increaseTokens();
            this.hasToken = false;
            if (!pausedConnections.isEmpty()) {
                InternalConnection ic = pausedConnections.removeFirst();
                ic.resume();
            }
        }
    }

    @Override
    public boolean isSubmission() {
        return false;
    }
}

