/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers;

import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.executor.utils.ResourceManager;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.util.Tracer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Invoker {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor.Invoker");
    protected static final String ERROR_METHOD_DEFINITION = "Incorrect method definition for task of type ";
    protected static final String ERROR_TASK_EXECUTION = "ERROR: Exception executing task (user code)";
    protected static final String ERROR_UNKNOWN_TYPE = "ERROR: Unrecognised type";
    public static final String COMPSS_NUM_NODES = "COMPSS_NUM_NODES";
    public static final String COMPSS_HOSTNAMES = "COMPSS_HOSTNAMES";
    public static final String COMPSS_NUM_THREADS = "COMPSS_NUM_THREADS";
    public static final String OMP_NUM_THREADS = "OMP_NUM_THREADS";
    protected final InvocationContext context;
    protected final Invocation invocation;
    protected final File taskSandboxWorkingDir;
    protected final ResourceManager.InvocationResources assignedResources;
    protected final int computingUnits;
    protected final String workers;
    protected final int numWorkers;

    public Invoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, ResourceManager.InvocationResources assignedResources) throws JobExecutionException {
        this.context = context;
        this.invocation = invocation;
        this.taskSandboxWorkingDir = taskSandboxWorkingDir;
        this.assignedResources = assignedResources;
        ResourceDescription rd = this.invocation.getRequirements();
        this.computingUnits = this.invocation.getTaskType() == Implementation.TaskType.METHOD ? ((MethodResourceDescription)rd).getTotalCPUComputingUnits() : 0;
        List<String> hostnames = invocation.getSlaveNodesNames();
        hostnames.add(context.getHostName());
        this.numWorkers = hostnames.size();
        boolean firstElement = true;
        StringBuilder hostnamesSTR = new StringBuilder();
        for (String hostname : hostnames) {
            int i;
            if (hostname.endsWith("-ib0")) {
                hostname = hostname.substring(0, hostname.lastIndexOf("-ib0"));
            }
            if (firstElement) {
                firstElement = false;
                hostnamesSTR.append(hostname);
                for (i = 1; i < this.computingUnits; ++i) {
                    hostnamesSTR.append(",").append(hostname);
                }
                continue;
            }
            for (i = 0; i < this.computingUnits; ++i) {
                hostnamesSTR.append(",").append(hostname);
            }
        }
        this.workers = hostnamesSTR.toString();
        AbstractMethodImplementation impl = invocation.getMethodImplementation();
        int paramIdx = 0;
        for (InvocationParam invocationParam : invocation.getParams()) {
            this.processParameter(invocationParam);
            if (invocationParam.getValue() == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Object parameter ").append(paramIdx);
                stringBuilder.append(" with renaming ").append(invocationParam.getDataMgmtId());
                stringBuilder.append(" in MethodDefinition ").append(impl.getMethodDefinition());
                stringBuilder.append(" is null!").append("\n");
                throw new JobExecutionException(stringBuilder.toString());
            }
            ++paramIdx;
        }
        if (invocation.getTarget() != null) {
            this.processParameter(invocation.getTarget());
        }
        if (invocation.isDebugEnabled()) {
            PrintStream out = context.getThreadOutStream();
            out.println("WORKER - Parameters of execution:");
            out.println("  * Method type: " + (Object)((Object)impl.getMethodType()));
            out.println("  * Method definition: " + impl.getMethodDefinition());
            out.print("  * Parameter types:");
            for (InvocationParam invocationParam : invocation.getParams()) {
                out.print(" " + invocationParam.getValueClass().getName());
            }
            out.println("");
            out.print("  * Parameter values:");
            for (InvocationParam invocationParam : invocation.getParams()) {
                out.print(" " + invocationParam.getValue());
            }
            out.println("");
            out.print("  * Parameter streams:");
            for (InvocationParam invocationParam : invocation.getParams()) {
                out.print(" " + (Object)((Object)invocationParam.getStream()));
            }
            if (invocation.getTarget() != null) {
                out.print(" " + (Object)((Object)invocation.getTarget().getStream()));
            }
            out.println("");
            out.print("  * Parameter prefixes:");
            for (InvocationParam invocationParam : invocation.getParams()) {
                out.print(" " + invocationParam.getPrefix());
            }
            if (invocation.getTarget() != null) {
                out.print(" " + invocation.getTarget().getPrefix());
            }
            out.println("");
            out.println("  * Has Target: " + (invocation.getTarget() != null));
            out.println("  * Has Return: " + (invocation.getResults() != null));
        }
    }

    private void processParameter(InvocationParam np) throws JobExecutionException {
        try {
            this.context.loadParam(np);
            Object obj = np.getValue();
            switch (np.getType()) {
                case BOOLEAN_T: {
                    np.setValueClass(Boolean.TYPE);
                    break;
                }
                case CHAR_T: {
                    np.setValueClass(Character.TYPE);
                    break;
                }
                case BYTE_T: {
                    np.setValueClass(Byte.TYPE);
                    break;
                }
                case SHORT_T: {
                    np.setValueClass(Short.TYPE);
                    break;
                }
                case INT_T: {
                    np.setValueClass(Integer.TYPE);
                    break;
                }
                case LONG_T: {
                    np.setValueClass(Long.TYPE);
                    break;
                }
                case FLOAT_T: {
                    np.setValueClass(Float.TYPE);
                    break;
                }
                case DOUBLE_T: {
                    np.setValueClass(Double.TYPE);
                    break;
                }
                case STRING_T: 
                case FILE_T: 
                case BINDING_OBJECT_T: 
                case EXTERNAL_PSCO_T: {
                    np.setValueClass(String.class);
                    break;
                }
                case OBJECT_T: 
                case COLLECTION_T: 
                case PSCO_T: {
                    if (obj != null) {
                        np.setValueClass(obj.getClass());
                    }
                    break;
                }
                default: {
                    throw new JobExecutionException(ERROR_UNKNOWN_TYPE + (Object)((Object)np.getType()));
                }
            }
        }
        catch (Exception e) {
            throw new JobExecutionException(e.getMessage(), e);
        }
    }

    public void processTask() throws JobExecutionException {
        this.invoke();
        try {
            this.storeFinalValues();
        }
        catch (Exception e) {
            throw new JobExecutionException("Error storing a task result", e);
        }
    }

    public void serializeBinaryExitValue(InvocationParam returnParam, Object exitValue) throws JobExecutionException {
        LOGGER.debug("Checking binary exit value serialization");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("- Param Type: " + returnParam.getType().name());
            LOGGER.debug("- Preserve source data: " + returnParam.isPreserveSourceData());
            LOGGER.debug("- Write final value: " + returnParam.isWriteFinalValue());
            LOGGER.debug("- Prefix: " + returnParam.getPrefix());
        }
        if (returnParam.getType().equals((Object)DataType.FILE_T)) {
            String renaming = returnParam.getOriginalName();
            LOGGER.info("Writing Binary Exit Value (" + exitValue.toString() + ") to " + renaming);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(renaming));){
                String value = "0000I" + exitValue + "\n.\n";
                writer.write(value);
                writer.flush();
            }
            catch (IOException ioe) {
                throw new JobExecutionException("ERROR: Cannot serialize binary exit value for bindings", ioe);
            }
        }
    }

    private void storeFinalValues() throws Exception {
        for (InvocationParam invocationParam : this.invocation.getParams()) {
            this.storeValue(invocationParam);
        }
        if (this.invocation.getTarget() != null) {
            this.storeValue(this.invocation.getTarget());
        }
        for (InvocationParam invocationParam : this.invocation.getResults()) {
            this.storeValue(invocationParam);
        }
    }

    private void storeValue(InvocationParam np) throws Exception {
        if (np.isWriteFinalValue()) {
            this.context.storeParam(np);
        }
    }

    private void invoke() throws JobExecutionException {
        this.emitStartTask();
        try {
            this.setEnvironmentVariables();
            this.invokeMethod();
        }
        catch (JobExecutionException jee) {
            throw jee;
        }
        finally {
            this.emitEndTask();
        }
    }

    private void setEnvironmentVariables() {
        System.setProperty(COMPSS_NUM_NODES, String.valueOf(this.numWorkers));
        System.setProperty(COMPSS_HOSTNAMES, this.workers);
        System.setProperty(COMPSS_NUM_THREADS, String.valueOf(this.computingUnits));
        System.setProperty(OMP_NUM_THREADS, String.valueOf(this.computingUnits));
        System.out.println("[INVOKER] COMPSS_HOSTNAMES: " + this.workers);
        System.out.println("[INVOKER] COMPSS_NUM_NODES: " + this.numWorkers);
        System.out.println("[INVOKER] COMPSS_NUM_THREADS: " + this.computingUnits);
    }

    private void emitStartTask() {
        if (Tracer.isActivated()) {
            int coreId = this.invocation.getMethodImplementation().getCoreId() + 1;
            int taskId = this.invocation.getTaskId();
            Tracer.emitEventAndCounters(coreId, Tracer.getTaskEventsType());
            Tracer.emitEvent(taskId, Tracer.getTaskSchedulingType());
        }
    }

    private void emitEndTask() {
        if (Tracer.isActivated()) {
            Tracer.emitEventAndCounters(0, Tracer.getTaskEventsType());
            Tracer.emitEvent(0L, Tracer.getTaskSchedulingType());
        }
    }

    protected abstract void invokeMethod() throws JobExecutionException;

    protected static String writeHostfile(File taskSandboxWorkingDir, String workers) throws InvokeExecutionException {
        String uuid = UUID.randomUUID().toString();
        String filename = taskSandboxWorkingDir.getAbsolutePath() + File.separator + uuid + ".hostfile";
        String workersInLines = workers.replace(',', '\n');
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filename));){
            writer.write(workersInLines);
        }
        catch (IOException ioe) {
            throw new InvokeExecutionException("ERROR: Cannot write hostfile", ioe);
        }
        return filename;
    }
}

