/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.utils;

import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.stage.Transfer;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.utils.NIOBindingObjectReceiver;
import es.bsc.compss.nio.utils.NIOBindingObjectStream;
import es.bsc.compss.nio.utils.NIOBindingObjectTransferListener;
import es.bsc.compss.util.BindingDataManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOBindingDataManager
extends BindingDataManager {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final Map<NIOConnection, NIOBindingObjectTransferListener> LISTENERS = new ConcurrentHashMap<NIOConnection, NIOBindingObjectTransferListener>();

    public static native int sendNativeObject(String var0, NIOBindingObjectStream var1);

    public static native int receiveNativeObject(String var0, int var1, NIOBindingObjectStream var2);

    public static void receiveBindingObject(NIOAgent agent, NIOConnection c, String sourceId, int type) {
        Semaphore sem = new Semaphore(0);
        NIOBindingObjectTransferListener nbol = new NIOBindingObjectTransferListener(agent, sem);
        LISTENERS.put(c, nbol);
        NIOBindingObjectStream nbos = new NIOBindingObjectStream(c, nbol);
        NIOBindingObjectReceiver receiver = new NIOBindingObjectReceiver(c, sourceId, type, nbos);
        Thread t = new Thread(receiver);
        t.setName("BindingObjectReceiver_" + sourceId);
        t.start();
    }

    public static void receivedPartialBindingObject(NIOConnection c, Transfer t) {
        NIOBindingObjectTransferListener nbol = LISTENERS.get(c);
        nbol.setTransfer(t);
        nbol.notifyEnd();
    }

    public static void objectReceived(NIOConnection c) {
        NIOBindingObjectTransferListener nbol = LISTENERS.remove(c);
        nbol.getAgent().receivedData(c, nbol.getTransfer());
    }

    static {
        System.loadLibrary("bindings_common");
    }
}

