/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers;

import es.bsc.compss.executor.utils.ResourceManager;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.JavaInvoker;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.util.List;
import java.util.concurrent.Semaphore;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import storage.CallbackEvent;
import storage.CallbackHandler;
import storage.StorageException;
import storage.StorageItf;
import storage.StubItf;

public class StorageInvoker
extends JavaInvoker {
    private static final String ERROR_CLASS_NOT_FOUND = "ERROR: Target object class not found";
    private static final String ERROR_EXTERNAL_NO_PSCO = "ERROR: External ExecuteTask can only be used with target PSCOs";
    private static final String ERROR_STORAGE_CALL = "ERROR: External executeTask call failed";
    private static final String ERROR_CALLBACK_INTERRUPTED = "ERROR: External callback interrupted";
    private static final String ERROR_EXTERNAL_EXECUTION = "ERROR: External Task Execution failed";
    private static final String WARN_RET_VALUE_EXCEPTION = "WARN: Exception on externalExecution return value";

    public StorageInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, ResourceManager.InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
    }

    @Override
    public Object runMethod() throws JobExecutionException {
        String descriptor;
        int n = this.method.getParameterAnnotations().length;
        ClassPool pool = ClassPool.getDefault();
        Class<?>[] cParams = this.method.getParameterTypes();
        CtClass[] ctParams = new CtClass[n];
        for (int i = 0; i < n; ++i) {
            try {
                ctParams[i] = pool.getCtClass(cParams[i].getName());
                continue;
            }
            catch (NotFoundException e) {
                throw new JobExecutionException("ERROR: Target object class not found " + cParams[i].getName(), e);
            }
        }
        try {
            descriptor = this.method.getName() + Descriptor.ofMethod(pool.getCtClass(this.method.getReturnType().getName()), ctParams);
        }
        catch (NotFoundException e) {
            throw new JobExecutionException("ERROR: Target object class not found " + this.method.getReturnType().getName(), e);
        }
        String id = null;
        try {
            id = ((StubItf)this.invocation.getTarget().getValue()).getID();
        }
        catch (Exception e) {
            throw new JobExecutionException(ERROR_EXTERNAL_NO_PSCO, e);
        }
        if (id == null) {
            throw new JobExecutionException(ERROR_EXTERNAL_NO_PSCO);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("External ExecuteTask " + this.method.getName() + " with target PSCO Id " + id + " in " + this.context.getHostName());
        } else {
            LOGGER.info("External ExecuteTask " + this.method.getName());
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(Tracer.Event.STORAGE_EXECUTETASK.getId(), Tracer.Event.STORAGE_EXECUTETASK.getType());
        }
        List<? extends InvocationParam> params = this.invocation.getParams();
        Object[] values = new Object[params.size()];
        int paramIdx = 0;
        for (InvocationParam invocationParam : params) {
            values[paramIdx++] = invocationParam.getValue();
        }
        CallbackHandlerPSCO callback = new CallbackHandlerPSCO();
        try {
            String string = StorageItf.executeTask(id, descriptor, values, this.context.getHostName(), callback);
            LOGGER.debug(string);
            callback.waitForCompletion();
        }
        catch (StorageException storageException) {
            throw new JobExecutionException(ERROR_STORAGE_CALL, storageException);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new JobExecutionException(ERROR_CALLBACK_INTERRUPTED, interruptedException);
        }
        finally {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, Tracer.Event.STORAGE_EXECUTETASK.getType());
            }
        }
        CallbackEvent.EventType eventType = callback.getStatus();
        if (!eventType.equals((Object)CallbackEvent.EventType.SUCCESS)) {
            throw new JobExecutionException(ERROR_EXTERNAL_EXECUTION);
        }
        Object retValue = null;
        if (this.method.getReturnType().getName().compareTo(Void.TYPE.getName()) != 0) {
            try {
                retValue = callback.getResult();
            }
            catch (StorageException e) {
                LOGGER.warn(WARN_RET_VALUE_EXCEPTION, (Throwable)e);
                retValue = null;
            }
        }
        return retValue;
    }

    private class CallbackHandlerPSCO
    extends CallbackHandler {
        private CallbackEvent event;
        private Semaphore sem = new Semaphore(0);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void eventListener(CallbackEvent e) {
            this.event = e;
            Invoker.LOGGER.debug("Received event task finished with callback id " + this.event.getRequestID());
            CallbackHandlerPSCO callbackHandlerPSCO = this;
            synchronized (callbackHandlerPSCO) {
                this.notifyAll();
            }
            this.sem.release();
        }

        public void waitForCompletion() throws InterruptedException {
            this.sem.acquire();
        }

        public CallbackEvent.EventType getStatus() {
            return this.event.getType();
        }

        public Object getResult() throws StorageException {
            return StorageItf.getResult(this.event);
        }
    }
}

