/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.util;

import es.bsc.compss.nio.worker.util.ExternalTaskStatus;
import es.bsc.compss.util.ErrorManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskResultReader
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    private static final String ERROR_PIPE_QUIT = "Error finishing readPipeFile ";
    private static final String ERROR_PIPE_NOT_FOUND = "Pipe cannot be found";
    private static final String ERROR_PIPE_NOT_READ = "Pipe cannot be read";
    private final String readPipeFile;
    private final Map<Integer, ExternalTaskStatus> jobIdsToStatus;
    private final Map<Integer, Semaphore> jobIdsToWaiters;
    private boolean haveWaiters;
    private boolean mustStop;
    private Semaphore stopSem;

    public TaskResultReader(String readPipeFile) {
        this.readPipeFile = readPipeFile;
        this.mustStop = false;
        this.haveWaiters = false;
        this.jobIdsToStatus = new HashMap<Integer, ExternalTaskStatus>();
        this.jobIdsToWaiters = new HashMap<Integer, Semaphore>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.info("TaskResultReader running");
        while (!this.mustStop || this.haveWaiters) {
            this.readFromPipe();
            Map<Integer, Semaphore> map = this.jobIdsToWaiters;
            synchronized (map) {
                this.haveWaiters = !this.jobIdsToWaiters.isEmpty();
            }
        }
        LOGGER.debug("TaskResultReader stoped with: mustStop = " + this.mustStop + " Waiters = " + this.haveWaiters);
        this.stopSem.release();
    }

    public void shutdown(Semaphore sem) {
        LOGGER.info("Ask for shutdown");
        this.mustStop = true;
        this.stopSem = sem;
        LOGGER.debug("Send quit tag to pipe");
        boolean done = false;
        int retries = 0;
        while (!done && retries < 3) {
            try {
                FileOutputStream output = new FileOutputStream(this.readPipeFile, true);
                Throwable throwable = null;
                try {
                    String quitCMD = "quit\n";
                    output.write(quitCMD.getBytes());
                    output.flush();
                    done = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (output == null) continue;
                    if (throwable != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.warn("Error on writing on pipe. Retrying " + retries + "/" + 3);
                ++retries;
            }
        }
        if (!done) {
            ErrorManager.error(ERROR_PIPE_QUIT + this.readPipeFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void askForTaskEnd(int jobId, Semaphore waiter) {
        LOGGER.debug("Ask for task " + jobId + " end");
        Map<Integer, Object> map = this.jobIdsToStatus;
        synchronized (map) {
            ExternalTaskStatus status = this.jobIdsToStatus.get(jobId);
            if (status != null) {
                waiter.release();
                return;
            }
        }
        map = this.jobIdsToWaiters;
        synchronized (map) {
            this.jobIdsToWaiters.put(jobId, waiter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalTaskStatus getTaskStatus(int jobId) {
        Map<Integer, ExternalTaskStatus> map = this.jobIdsToStatus;
        synchronized (map) {
            ExternalTaskStatus taskStatus = this.jobIdsToStatus.get(jobId);
            this.jobIdsToStatus.remove(jobId);
            return taskStatus;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readFromPipe() {
        try (FileInputStream input = new FileInputStream(this.readPipeFile);
             BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line = reader.readLine();
            if (line == null) return;
            String[] result = line.split(" ");
            if (result.length < 1) {
                LOGGER.warn("Skipping line: " + line);
                return;
            }
            switch (result[0]) {
                case "quit": {
                    LOGGER.debug("Received quit message");
                    return;
                }
                case "endTask": {
                    LOGGER.debug("Received endTask message: " + line);
                    this.processEndTaskTag(result);
                    return;
                }
                case "errorTask": {
                    LOGGER.debug("Received erroTask message: " + line);
                    this.processErrorTaskTag();
                    return;
                }
            }
            LOGGER.warn("Unrecognised tag: " + result[0] + ". Skipping message");
            return;
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.debug(ERROR_PIPE_NOT_FOUND);
            return;
        }
        catch (IOException ioe) {
            LOGGER.error(ERROR_PIPE_NOT_READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEndTaskTag(String[] line) {
        if (line.length < 3) {
            LOGGER.warn("WARN: Skipping endTask line because is malformed");
            return;
        }
        Integer jobId = Integer.parseInt(line[1]);
        ExternalTaskStatus taskStatus = new ExternalTaskStatus(line);
        Map<Integer, Object> map = this.jobIdsToStatus;
        synchronized (map) {
            this.jobIdsToStatus.put(jobId, taskStatus);
        }
        LOGGER.debug("Read job " + jobId + " with status " + taskStatus);
        map = this.jobIdsToWaiters;
        synchronized (map) {
            Semaphore waiter = this.jobIdsToWaiters.get(jobId);
            if (waiter != null) {
                waiter.release();
                this.jobIdsToWaiters.remove(jobId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processErrorTaskTag() {
        Map<Integer, Semaphore> map = this.jobIdsToWaiters;
        synchronized (map) {
            for (Map.Entry<Integer, Semaphore> entry : this.jobIdsToWaiters.entrySet()) {
                Integer jobId = entry.getKey();
                Semaphore waiter = entry.getValue();
                Integer exitValue = -1;
                ExternalTaskStatus taskStatus = new ExternalTaskStatus(exitValue);
                Map<Integer, ExternalTaskStatus> map2 = this.jobIdsToStatus;
                synchronized (map2) {
                    this.jobIdsToStatus.put(jobId, taskStatus);
                }
                waiter.release();
            }
            this.jobIdsToWaiters.clear();
        }
    }
}

