/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external.piped;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.executor.external.piped.ControlPipePair;
import es.bsc.compss.executor.external.piped.PipedMirror;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PythonMirror
extends PipedMirror {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor.Invoker");
    private static final String BINDINGS_RELATIVE_PATH = File.separator + "Bindings" + File.separator + "bindings-common" + File.separator + "lib";
    public static final String PYCOMPSS_RELATIVE_PATH = File.separator + "Bindings" + File.separator + "python";
    private static final String WORKER_PY_RELATIVE_PATH = File.separator + "pycompss" + File.separator + "worker" + File.separator + "piper_worker.py";
    private static final String MPI_WORKER_PY_RELATIVE_PATH = File.separator + "pycompss" + File.separator + "worker" + File.separator + "mpi_piper_worker.py";
    private static final String ENV_LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String ENV_PYTHONPATH = "PYTHONPATH";
    private final PythonParams pyParams;
    private final String pyCOMPSsHome;

    public PythonMirror(InvocationContext context, int size) {
        super(context, size);
        this.pyParams = (PythonParams)context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
        String installDir = context.getInstallDir();
        this.pyCOMPSsHome = installDir + PYCOMPSS_RELATIVE_PATH + File.separator + this.pyParams.getPythonVersion();
        this.init(context);
    }

    @Override
    public String getPipeBuilderContext() {
        StringBuilder cmd = new StringBuilder();
        cmd.append((Object)COMPSsConstants.Lang.PYTHON).append(" ");
        cmd.append(this.pyParams.getPythonVirtualEnvironment()).append(" ");
        cmd.append(this.pyParams.getPythonPropagateVirtualEnvironment()).append(" ");
        cmd.append(this.pyParams.usePythonMpiWorker()).append(" ");
        cmd.append(this.size + 1).append(" ");
        cmd.append(this.pyParams.getPythonInterpreter()).append(" ");
        return cmd.toString();
    }

    @Override
    public String getLaunchWorkerCommand(InvocationContext context, ControlPipePair pipe) {
        int i;
        StringBuilder cmd = new StringBuilder();
        if (this.pyParams.usePythonMpiWorker().booleanValue()) {
            cmd.append("mpirun").append(" ").append("-np").append(" ").append(this.size + 1).append(" ");
        }
        cmd.append(this.pyParams.getPythonInterpreter()).append(" ").append("-u").append(" ");
        cmd.append(this.pyCOMPSsHome);
        if (this.pyParams.usePythonMpiWorker().booleanValue()) {
            cmd.append(MPI_WORKER_PY_RELATIVE_PATH).append(" ");
        } else {
            cmd.append(WORKER_PY_RELATIVE_PATH).append(" ");
        }
        cmd.append(LOGGER.isDebugEnabled()).append(" ");
        cmd.append(Tracer.getLevel()).append(" ");
        cmd.append(context.getStorageConf()).append(" ");
        cmd.append(context.getStreamingBackend().name()).append(" ");
        cmd.append(context.getStreamingMasterName()).append(" ");
        cmd.append(context.getStreamingMasterPort()).append(" ");
        cmd.append(this.size).append(" ");
        String computePipes = this.basePipePath + "compute";
        for (i = 0; i < this.size; ++i) {
            cmd.append(computePipes).append(i).append(".outbound").append(" ");
        }
        for (i = 0; i < this.size; ++i) {
            cmd.append(computePipes).append(i).append(".inbound").append(" ");
        }
        cmd.append(pipe.getOutboundPipe()).append(" ");
        cmd.append(pipe.getInboundPipe());
        return cmd.toString();
    }

    @Override
    public Map<String, String> getEnvironment(InvocationContext context) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PYCOMPSS_HOME", this.pyCOMPSsHome);
        String pythonPath = System.getenv(ENV_PYTHONPATH);
        pythonPath = pythonPath == null ? this.pyCOMPSsHome + ":" + this.pyParams.getPythonPath() + ":" + context.getAppDir() : this.pyCOMPSsHome + ":" + this.pyParams.getPythonPath() + ":" + context.getAppDir() + pythonPath;
        env.put(ENV_PYTHONPATH, pythonPath);
        String ldLibraryPath = System.getenv(ENV_LD_LIBRARY_PATH);
        String bindingsHome = context.getInstallDir() + BINDINGS_RELATIVE_PATH;
        ldLibraryPath = ldLibraryPath.concat(":" + bindingsHome);
        env.put(ENV_LD_LIBRARY_PATH, ldLibraryPath);
        return env;
    }

    @Override
    protected String getPBWorkingDir(InvocationContext context) {
        String workingDir = super.getPBWorkingDir(context);
        if (Tracer.isActivated() && !new File(workingDir = workingDir + "python").mkdirs()) {
            ErrorManager.error("Could not create working dir for python tracefiles, path: " + workingDir);
        }
        return workingDir;
    }
}

