/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.commands;

import es.bsc.comm.Connection;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.NIOData;
import es.bsc.compss.nio.commands.Command;
import es.bsc.compss.nio.commands.CommandType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CommandDataDemand
extends Command
implements Externalizable {
    private NIOData d;
    private int id;

    public CommandDataDemand() {
    }

    public CommandDataDemand(NIOAgent agent, NIOData d, int receiverID) {
        super(agent);
        this.d = d;
        this.id = receiverID;
    }

    @Override
    public CommandType getType() {
        return CommandType.DATA_DEMAND;
    }

    @Override
    public void handle(Connection c) {
        boolean slot = this.agent.tryAcquireSendSlot(c);
        if (!slot) {
            this.agent.sendData(c, this.d, this.id);
        } else {
            this.agent.sendData(c, this.d, this.id);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.d = (NIOData)in.readObject();
        this.id = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.d);
        out.writeInt(this.id);
    }

    public String toString() {
        return "Request for sending data " + this.d;
    }
}

