/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.listeners;

import es.bsc.compss.data.MultiOperationFetchListener;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.worker.NIOWorker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskFetchOperationsListener
extends MultiOperationFetchListener {
    private static final Logger WORKER_LOGGER = LogManager.getLogger("es.bsc.compss.Worker");
    private final NIOTask task;
    private final NIOWorker nw;

    public TaskFetchOperationsListener(NIOTask task, NIOWorker nw) {
        this.task = task;
        this.nw = nw;
    }

    public NIOTask getTask() {
        return this.task;
    }

    @Override
    public void doCompleted() {
        Long stTime = this.nw.getTimes(this.task.getJobId());
        if (stTime != null) {
            long duration = System.currentTimeMillis() - stTime;
            WORKER_LOGGER.info(" [Profile] Transfer: " + duration);
        }
        this.nw.executeTask(this.task);
    }

    @Override
    public void doFailure(String failedDataId, Exception cause) {
        String baseJobPath = this.nw.getStandardStreamsPath(this.task);
        String errorMessage = "Worker closed because the data " + failedDataId + " couldn't be retrieved.";
        String taskFileOutName = baseJobPath + ".out";
        this.nw.checkStreamFileExistence(taskFileOutName, "out", errorMessage);
        String taskFileErrName = baseJobPath + ".err";
        this.nw.checkStreamFileExistence(taskFileErrName, "err", errorMessage);
        this.nw.sendTaskDone(this.task, false);
    }
}

