/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MultiNodeImplementation
extends AbstractMethodImplementation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 2;
    private String declaringClass;
    private String methodName;

    public MultiNodeImplementation() {
    }

    public MultiNodeImplementation(String methodClass, String methodName, Integer coreId, Integer implementationId, MethodResourceDescription requirements) {
        super(coreId, implementationId, requirements);
        this.declaringClass = methodClass;
        this.methodName = methodName;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.MULTI_NODE;
    }

    @Override
    public String getMethodDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("[DECLARING CLASS=").append(this.declaringClass);
        sb.append(", METHOD NAME=").append(this.methodName);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return super.toString() + " Multi-Node Method declared in class " + this.declaringClass + "." + this.methodName + ": " + this.requirements.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.declaringClass = (String)in.readObject();
        this.methodName = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.declaringClass);
        out.writeObject(this.methodName);
    }
}

