/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker;

import es.bsc.comm.Connection;
import es.bsc.comm.exceptions.CommException;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.stage.Transfer;
import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.data.DataManager;
import es.bsc.compss.data.DataProvider;
import es.bsc.compss.data.FetchDataListener;
import es.bsc.compss.data.MultiOperationFetchListener;
import es.bsc.compss.executor.ExecutionManager;
import es.bsc.compss.executor.types.Execution;
import es.bsc.compss.executor.types.ExecutionListener;
import es.bsc.compss.executor.utils.ThreadedPrintStream;
import es.bsc.compss.invokers.types.CParams;
import es.bsc.compss.invokers.types.JavaParams;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.NIOData;
import es.bsc.compss.nio.NIOMessageHandler;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.commands.CommandDataReceived;
import es.bsc.compss.nio.commands.CommandExecutorShutdownACK;
import es.bsc.compss.nio.commands.CommandNIOTaskDone;
import es.bsc.compss.nio.commands.CommandShutdownACK;
import es.bsc.compss.nio.commands.workerfiles.CommandWorkerDebugFilesDone;
import es.bsc.compss.nio.datarequest.WorkerDataRequest;
import es.bsc.compss.nio.exceptions.DataNotAvailableException;
import es.bsc.compss.nio.listeners.FetchDataOperationListener;
import es.bsc.compss.nio.listeners.TaskFetchOperationsListener;
import es.bsc.compss.nio.requests.DataRequest;
import es.bsc.compss.nio.worker.components.DataManagerImpl;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.InitializationException;
import es.bsc.compss.types.execution.exceptions.UnloadableValueException;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.worker.COMPSsException;
import es.bsc.distrostreamlib.server.types.StreamBackend;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOWorker
extends NIOAgent
implements InvocationContext,
DataProvider {
    private static final Logger WORKER_LOGGER = LogManager.getLogger("es.bsc.compss.Worker");
    private static final boolean WORKER_LOGGER_DEBUG = WORKER_LOGGER.isDebugEnabled();
    private static final String EXECUTION_MANAGER_ERR = "Error starting ExecutionManager";
    private static final String DATA_MANAGER_ERROR = "Error starting DataManager";
    private static final String ERROR_INCORRECT_NUM_PARAMS = "Error: Incorrect number of parameters";
    private static final boolean REMOVE_WD;
    private static final ThreadedPrintStream OUT;
    private static final ThreadedPrintStream ERR;
    public static final String SUFFIX_OUT = ".out";
    public static final String SUFFIX_ERR = ".err";
    private final String deploymentId;
    private final boolean transferLogs;
    private final String hostName;
    private final String workingDir;
    private final String installDir;
    private final String appDir;
    private final COMPSsConstants.TaskExecution executionType;
    private final boolean persistentC;
    private final LanguageParams[] langParams;
    private final Map<Integer, Long> times;
    private final ExecutionManager executionManager;
    private final DataManager dataManager;

    public NIOWorker(boolean transferLogs, int snd, int rcv, String hostName, String masterName, int masterPort, int streamingPort, int computingUnitsCPU, int computingUnitsGPU, int computingUnitsFPGA, String cpuMap, String gpuMap, String fpgaMap, int limitOfTasks, String appUuid, String traceFlag, String traceHost, String storageConf, COMPSsConstants.TaskExecution executionType, boolean persistentC, String workingDir, String installDir, String appDir, JavaParams javaParams, PythonParams pyParams, CParams cParams) {
        super(snd, rcv, masterPort);
        this.transferLogs = transferLogs;
        WORKER_LOGGER.info("NIO Worker init");
        this.tracingLevel = Integer.parseInt(traceFlag);
        NIOTracer.init(this.tracingLevel);
        if (NIOTracer.extraeEnabled()) {
            NIOTracer.emitEvent(TraceEvent.START.getId(), TraceEvent.START.getType());
        }
        if (NIOTracer.extraeEnabled() || NIOTracer.scorepEnabled() || NIOTracer.mapEnabled()) {
            try {
                this.tracingId = Integer.parseInt(traceHost);
                NIOTracer.setWorkerInfo(installDir, hostName, workingDir, this.tracingId);
            }
            catch (Exception e) {
                WORKER_LOGGER.error("No valid hostID provided to the tracing system. Provided ID: " + hostName);
            }
        }
        this.deploymentId = appUuid;
        this.hostName = hostName;
        this.workingDir = workingDir.endsWith(File.separator) ? workingDir : workingDir + File.separator;
        this.installDir = installDir.endsWith(File.separator) ? installDir : installDir + File.separator;
        this.appDir = appDir.equals("null") ? "" : appDir;
        this.executionType = executionType;
        System.setProperty("compss.storage.conf", storageConf);
        this.persistentC = persistentC;
        this.langParams = new LanguageParams[COMPSsConstants.Lang.values().length];
        this.langParams[COMPSsConstants.Lang.JAVA.ordinal()] = javaParams;
        this.langParams[COMPSsConstants.Lang.PYTHON.ordinal()] = pyParams;
        this.langParams[COMPSsConstants.Lang.C.ordinal()] = cParams;
        this.times = new HashMap<Integer, Long>();
        this.masterNode = null;
        if (masterName != null && !masterName.isEmpty() && !masterName.equals("null")) {
            this.masterNode = new NIONode(masterName, masterPort);
        }
        this.dataManager = new DataManagerImpl(this.hostName, masterName, streamingPort, workingDir, this);
        try {
            this.dataManager.init();
        }
        catch (InitializationException ie) {
            ErrorManager.error(DATA_MANAGER_ERROR, ie);
        }
        this.executionManager = new ExecutionManager(this, computingUnitsCPU, cpuMap, computingUnitsGPU, gpuMap, computingUnitsFPGA, fpgaMap, limitOfTasks);
        if (this.tracingLevel == 1) {
            NIOTracer.enablePThreads();
        }
        try {
            this.executionManager.init();
        }
        catch (InitializationException ie) {
            ErrorManager.error(EXECUTION_MANAGER_ERR, ie);
        }
        if (this.tracingLevel == 1) {
            NIOTracer.disablePThreads();
        }
    }

    @Override
    public void setWorkerIsReady(String nodeName) {
    }

    @Override
    public void setMaster(NIONode master) {
        if (this.masterNode == null) {
            this.masterNode = new NIONode(master.getIp(), this.masterPort);
        }
    }

    @Override
    public boolean isMyUuid(String uuid, String nodeName) {
        return uuid.equals(this.deploymentId) && nodeName.equals(this.hostName);
    }

    @Override
    public void receivedNewTask(NIONode master, NIOTask task, List<String> obsoleteFiles) {
        WORKER_LOGGER.info("Received Job " + task);
        if (WORKER_LOGGER_DEBUG) {
            WORKER_LOGGER.debug("ARGUMENTS:");
            for (InvocationParam invocationParam : task.getParams()) {
                WORKER_LOGGER.info("    -" + invocationParam.getPrefix() + " " + (Object)((Object)invocationParam.getType()) + ":" + invocationParam.getValue());
            }
            WORKER_LOGGER.debug("TARGET:");
            if (task.getTarget() != null) {
                WORKER_LOGGER.info("    -" + task.getTarget().getPrefix() + " " + (Object)((Object)task.getTarget().getType()) + ":" + task.getTarget().getValue());
            }
            WORKER_LOGGER.debug("RESULTS:");
            for (InvocationParam invocationParam : task.getResults()) {
                WORKER_LOGGER.info("    -" + invocationParam.getPrefix() + " " + (Object)((Object)invocationParam.getType()) + ":" + invocationParam.getValue());
            }
        }
        if (NIOTracer.extraeEnabled()) {
            NIOTracer.emitEvent(TraceEvent.WORKER_RECEIVED_NEW_TASK.getId(), TraceEvent.WORKER_RECEIVED_NEW_TASK.getType());
        }
        long obsolSt = System.currentTimeMillis();
        if (obsoleteFiles != null) {
            this.removeObsolete(obsoleteFiles);
        }
        long obsolEnd = System.currentTimeMillis();
        long obsolDuration = obsolEnd - obsolSt;
        WORKER_LOGGER.info("Checking parameters");
        TaskFetchOperationsListener listener = new TaskFetchOperationsListener(task, this);
        int paramIdx = 0;
        for (NIOParam param : task.getParams()) {
            WORKER_LOGGER.info("Checking parameter " + param);
            ++paramIdx;
            if (param.getData() == null) continue;
            if (WORKER_LOGGER_DEBUG) {
                WORKER_LOGGER.debug("- Checking transfers for data " + param.getDataMgmtId() + " for parameter " + paramIdx);
            }
            listener.addOperation();
            this.dataManager.fetchParam(param, paramIdx, listener);
        }
        WORKER_LOGGER.info("Checking target");
        NIOParam targetParam = task.getTarget();
        if (targetParam != null) {
            WORKER_LOGGER.debug("- Checking transfers for data " + targetParam.getDataMgmtId() + " for target parameter");
            listener.addOperation();
            this.dataManager.fetchParam(targetParam, -1, listener);
        }
        if (NIOTracer.extraeEnabled()) {
            NIOTracer.emitEvent(listener.getTask().getTaskId(), NIOTracer.getTaskTransfersType());
        }
        this.requestTransfers();
        if (NIOTracer.extraeEnabled()) {
            NIOTracer.emitEvent(0L, NIOTracer.getTaskTransfersType());
        }
        long paramsEnd = System.currentTimeMillis();
        long paramsDuration = paramsEnd - obsolEnd;
        WORKER_LOGGER.info("[Profile] Obsolete Processing: " + obsolDuration + " Processing " + paramsDuration);
        WORKER_LOGGER.info("[Profile] Pending parameters: " + listener.getMissingOperations());
        this.times.put(task.getJobId(), paramsEnd);
        listener.enable();
        if (NIOTracer.extraeEnabled()) {
            NIOTracer.emitEvent(0L, TraceEvent.WORKER_RECEIVED_NEW_TASK.getType());
        }
    }

    @Override
    public void receivedNewDataFetchOrder(NIOParam data, int transferId) {
        FetchDataOperationListener listener = new FetchDataOperationListener(transferId, this);
        if (data != null) {
            WORKER_LOGGER.debug("- Checking transfers for data " + data.getDataMgmtId());
            listener.addOperation();
            this.dataManager.fetchParam(data, -1, listener);
        }
        this.requestTransfers();
    }

    @Override
    public void askForTransfer(InvocationParam param, int index, FetchDataListener listener) {
        WorkerDataRequest dr = new WorkerDataRequest(listener, param.getType(), ((NIOParam)param).getData(), (String)param.getValue());
        this.addTransferRequest(dr);
    }

    @Override
    public boolean isTransferingData(InvocationParam param) {
        List<DataRequest> requests = this.getDataRequests(((NIOParam)param).getData().getDataMgmtId());
        return requests != null && !requests.isEmpty();
    }

    @Override
    protected void handleDataToSendNotAvailable(Connection c, NIOData d) {
        WORKER_LOGGER.debug("Handling data not available");
        ErrorManager.warn("Data " + d.getDataMgmtId() + "in this worker " + this.getHostName() + " could not be sent to master.");
        c.finishConnection();
    }

    @Override
    public void handleRequestedDataNotAvailableError(List<DataRequest> failedRequests, String dataId) {
        for (DataRequest dr : failedRequests) {
            WorkerDataRequest wdr = (WorkerDataRequest)dr;
            wdr.getListener().errorFetchingValue(dataId, new DataNotAvailableException(dataId));
        }
    }

    @Override
    public void receivedValue(Transfer.Destination type, String dataId, Object object, List<DataRequest> achievedRequests) {
        if (type == Transfer.Destination.OBJECT) {
            WORKER_LOGGER.info("Received data " + dataId + " with associated object " + object);
            this.dataManager.storeValue(dataId, object);
        } else {
            String nameId = new File(dataId).getName();
            WORKER_LOGGER.info("Received data " + nameId + " with path " + dataId);
            this.dataManager.storeFile(nameId, dataId);
        }
        for (DataRequest dr : achievedRequests) {
            WorkerDataRequest wdr = (WorkerDataRequest)dr;
            wdr.getListener().fetchedValue(dataId);
            if (NIOTracer.extraeEnabled()) {
                NIOTracer.emitDataTransferEvent("0");
            }
            if (!WORKER_LOGGER_DEBUG) continue;
            WORKER_LOGGER.debug("Pending parameters: " + ((MultiOperationFetchListener)wdr.getListener()).getMissingOperations());
        }
    }

    public Connection startConnection() {
        return TM.startConnection(this.masterNode);
    }

    public void sendTaskDone(Invocation invocation, boolean successful, Exception e) {
        NIOTask nt = (NIOTask)invocation;
        int jobId = nt.getJobId();
        int taskId = nt.getTaskId();
        Connection c = TM.startConnection(this.masterNode);
        NIOTaskResult tr = new NIOTaskResult(jobId, nt.getParams(), nt.getTarget(), nt.getResults());
        if (WORKER_LOGGER_DEBUG) {
            WORKER_LOGGER.debug("RESULT FOR JOB " + jobId + " (TASK ID: " + taskId + ")");
            WORKER_LOGGER.debug(tr);
        }
        CommandNIOTaskDone cmd = null;
        cmd = e instanceof COMPSsException ? new CommandNIOTaskDone(tr, successful, (COMPSsException)e) : new CommandNIOTaskDone(tr, successful, null);
        c.sendCommand(cmd);
        if (this.transferLogs || !successful) {
            String taskFileOutName = this.getStandardStreamsPath(invocation) + SUFFIX_OUT;
            this.checkStreamFileExistence(taskFileOutName, "out", "Autogenerated Empty file. An error was produced before generating any log in the stdout");
            String taskFileErrName = this.getStandardStreamsPath(invocation) + SUFFIX_ERR;
            this.checkStreamFileExistence(taskFileErrName, "err", "Autogenerated Empty file. An error was produced before generating any log in the stderr");
            if (WORKER_LOGGER_DEBUG) {
                WORKER_LOGGER.debug("Sending file " + taskFileOutName + ", for connection: " + c.hashCode());
            }
            c.sendDataFile(taskFileOutName);
            if (WORKER_LOGGER_DEBUG) {
                WORKER_LOGGER.debug("Sending file " + taskFileErrName + ", for connection: " + c.hashCode());
            }
            c.sendDataFile(taskFileErrName);
        }
        c.finishConnection();
        if (WORKER_LOGGER_DEBUG) {
            WORKER_LOGGER.debug("Job " + jobId + "(Task " + taskId + ") send job done");
        }
    }

    public void checkStreamFileExistence(String taskFileName, String streamName, String errorMessage) {
        File taskFile = new File(taskFileName);
        if (!taskFile.exists()) {
            try (FileOutputStream stream = new FileOutputStream(taskFile);){
                stream.write(errorMessage.getBytes());
                stream.close();
            }
            catch (IOException ioe) {
                WORKER_LOGGER.error("IOException writing worker " + streamName + " file: " + taskFile, (Throwable)ioe);
            }
        }
    }

    public void executeTask(NIOTask task) {
        if (WORKER_LOGGER_DEBUG) {
            WORKER_LOGGER.debug("Enqueueing job " + task.getJobId() + " for execution.");
        }
        Execution e = new Execution(task, new ExecutionListener(){

            @Override
            public void notifyEnd(Invocation invocation, boolean success, COMPSsException exception) {
                NIOWorker.this.sendTaskDone(invocation, success, exception);
            }
        });
        this.executionManager.enqueue(e);
        if (WORKER_LOGGER_DEBUG) {
            WORKER_LOGGER.debug("Notifying presence of all data for job " + task.getJobId() + ".");
        }
        CommandDataReceived cdr = new CommandDataReceived(task.getTransferGroupId());
        Connection c = TM.startConnection(this.masterNode);
        c.sendCommand(cdr);
        c.finishConnection();
    }

    @Override
    public void cancelRunningTask(NIONode node, int jobId) {
        this.executionManager.cancelJob(jobId);
    }

    public void removeObsolete(List<String> obsolete) {
        this.dataManager.removeObsoletes(obsolete);
    }

    @Override
    public void shutdownExecutionManager(Connection closingConnection) {
        WORKER_LOGGER.debug("Stopping Execution Manager...");
        this.executionManager.stop();
        if (closingConnection != null) {
            closingConnection.sendCommand(new CommandExecutorShutdownACK());
            closingConnection.finishConnection();
        }
    }

    @Override
    public void shutdownExecutionManagerNotification(Connection c) {
        ErrorManager.warn("Shutdown execution ACK notification should never be received by a worker");
    }

    @Override
    public void shutdown(Connection closingConnection) {
        WORKER_LOGGER.debug("Entering shutdown method on worker");
        this.dataManager.stop();
        if (closingConnection != null) {
            closingConnection.sendCommand(new CommandShutdownACK());
            closingConnection.finishConnection();
        }
        TM.shutdown(closingConnection);
        if (REMOVE_WD) {
            if (WORKER_LOGGER_DEBUG) {
                WORKER_LOGGER.debug("Erasing Worker Sandbox WorkingDir: " + this.workingDir);
            }
            try {
                this.removeFolder(this.workingDir);
            }
            catch (IOException ioe) {
                WORKER_LOGGER.error("Exception", (Throwable)ioe);
            }
        }
        WORKER_LOGGER.debug("Finish shutdown method on worker");
    }

    private void removeFolder(String sandBox) throws IOException {
        File wdirFile = new File(sandBox);
        this.remove(wdirFile);
    }

    private void remove(File f) throws IOException {
        if (f.exists()) {
            if (f.isDirectory()) {
                for (File child : f.listFiles()) {
                    this.remove(child);
                }
            }
            Files.delete(f.toPath());
        }
    }

    @Override
    public String getObjectAsFile(String s) {
        WORKER_LOGGER.warn("getObjectAsFile has been called in the worker side!");
        return null;
    }

    @Override
    public void receivedNIOTaskDone(Connection c, NIOTaskResult tr, boolean successful, Exception e) {
    }

    @Override
    public void copiedData(int transfergroupID) {
    }

    @Override
    public void shutdownNotification(Connection c) {
    }

    @Override
    public void waitUntilTracingPackageGenerated() {
    }

    @Override
    public void notifyTracingPackageGeneration() {
    }

    @Override
    public void waitUntilWorkersDebugInfoGenerated() {
    }

    @Override
    public void notifyWorkersDebugInfoGeneration() {
    }

    @Override
    public void generateWorkersDebugInfo(Connection c) {
        String outSourcePath = this.workingDir + File.separator + "log" + File.separator + "worker_" + this.hostName + SUFFIX_OUT;
        String outTarget = this.workingDir + File.separator + "log" + File.separator + "static_" + "worker_" + this.hostName + SUFFIX_OUT;
        this.freezeFile(outSourcePath, outTarget);
        String errSourcePath = this.workingDir + File.separator + "log" + File.separator + "worker_" + this.hostName + SUFFIX_ERR;
        String errTarget = this.workingDir + File.separator + "log" + File.separator + "static_" + "worker_" + this.hostName + SUFFIX_ERR;
        this.freezeFile(errSourcePath, errTarget);
        c.sendCommand(new CommandWorkerDebugFilesDone());
        c.finishConnection();
    }

    private void freezeFile(String sourcePath, String targetPath) {
        File source = new File(sourcePath);
        if (source.exists()) {
            try {
                Files.copy(source.toPath(), new File(targetPath).toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                WORKER_LOGGER.error("Exception copying source to target file", (Throwable)e);
            }
        } else {
            try (FileOutputStream fos = new FileOutputStream(targetPath);){
                fos.write("Empty file".getBytes());
            }
            catch (Exception e) {
                WORKER_LOGGER.error("Exception writing empty file", (Throwable)e);
            }
        }
    }

    @Override
    public void receivedBindingObjectAsFile(String filename, String target) {
    }

    @Override
    protected String getPossiblyRenamedFileName(File originalFile, NIOData d) {
        return originalFile.getParentFile().getAbsolutePath() + File.separator + d.getDataMgmtId();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public long getTracingHostID() {
        return Long.parseLong(NIOTracer.getHostID());
    }

    @Override
    public String getAppDir() {
        return this.appDir;
    }

    @Override
    public String getInstallDir() {
        return this.installDir;
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public boolean isPersistentCEnabled() {
        return this.persistentC;
    }

    public long getTimes(Integer jobId) {
        return this.times.get(jobId);
    }

    @Override
    public COMPSsConstants.TaskExecution getExecutionType() {
        return this.executionType;
    }

    @Override
    public LanguageParams getLanguageParams(COMPSsConstants.Lang lang) {
        WORKER_LOGGER.info("GETTING LANGUAGE PARAMS :" + COMPSsConstants.Lang.PYTHON.ordinal() + " -> " + this.langParams[lang.ordinal()]);
        return this.langParams[lang.ordinal()];
    }

    @Override
    public void registerOutputs(String path) {
        ERR.registerThread(path);
        OUT.registerThread(path);
    }

    @Override
    public void unregisterOutputs() {
        ERR.unregisterThread();
        OUT.unregisterThread();
    }

    @Override
    public String getStandardStreamsPath(Invocation invocation) {
        return this.getWorkingDir() + "jobs" + File.separator + "job" + invocation.getJobId() + "_" + (Object)((Object)invocation.getHistory());
    }

    @Override
    public PrintStream getThreadErrStream() {
        return ERR.getStream();
    }

    @Override
    public PrintStream getThreadOutStream() {
        return OUT.getStream();
    }

    @Override
    public String getStorageConf() {
        return this.dataManager.getStorageConf();
    }

    @Override
    public StreamBackend getStreamingBackend() {
        return this.dataManager.getStreamingBackend();
    }

    @Override
    public String getStreamingMasterName() {
        return this.dataManager.getStreamingMasterName();
    }

    @Override
    public int getStreamingMasterPort() {
        return this.dataManager.getStreamingMasterPort();
    }

    @Override
    public void loadParam(InvocationParam param) throws UnloadableValueException {
        this.dataManager.loadParam(param);
    }

    @Override
    public void storeParam(InvocationParam param) {
        this.dataManager.storeParam(param);
    }

    @Override
    public Object getObject(String name) {
        String realName = name.substring(name.lastIndexOf(47) + 1);
        return this.dataManager.getObject(realName);
    }

    @Override
    public void increaseResources(MethodResourceDescription description) {
        int cpuCount = description.getTotalCPUComputingUnits();
        int gpuCount = description.getTotalGPUComputingUnits();
        int fpgaCount = description.getTotalFPGAComputingUnits();
        int otherCount = description.getTotalOTHERComputingUnits();
        this.executionManager.increaseCapabilities(cpuCount, gpuCount, fpgaCount, otherCount);
    }

    @Override
    public void reduceResources(MethodResourceDescription description) {
        int cpuCount = description.getTotalCPUComputingUnits();
        int gpuCount = description.getTotalGPUComputingUnits();
        int fpgaCount = description.getTotalFPGAComputingUnits();
        int otherCount = description.getTotalOTHERComputingUnits();
        this.executionManager.reduceCapabilities(cpuCount, gpuCount, fpgaCount, otherCount);
    }

    @Override
    public void performedResourceUpdate(Connection c) {
    }

    public static void main(String[] args) {
        if (args.length != 34) {
            WORKER_LOGGER.debug("Received parameters: ");
            for (int i = 0; i < args.length; ++i) {
                WORKER_LOGGER.debug("Param " + i + ":  " + args[i]);
            }
            ErrorManager.fatal(ERROR_INCORRECT_NUM_PARAMS);
        }
        boolean debug = Boolean.valueOf(args[0]);
        int maxSnd = Integer.parseInt(args[1]);
        int maxRcv = Integer.parseInt(args[2]);
        String workerIP = args[3];
        int wPort = Integer.parseInt(args[4]);
        String mName = args[5];
        int mPort = Integer.parseInt(args[6]);
        int streamingPort = Integer.parseInt(args[7]);
        int computingUnitsCPU = Integer.parseInt(args[8]);
        int computingUnitsGPU = Integer.parseInt(args[9]);
        int computingUnitsFPGA = Integer.parseInt(args[10]);
        String cpuMap = args[11];
        String gpuMap = args[12];
        String fpgaMap = args[13];
        int limitOfTasks = Integer.parseInt(args[14]);
        String appUuid = args[15];
        String workingDir = args[17];
        String installDir = args[18];
        String appDir = args[19];
        String libPath = args[20];
        String classpath = args[21];
        String pythonpath = args[22];
        String traceFlag = args[23];
        String extraeFile = args[24];
        String traceHost = args[25];
        String storageConf = args[26];
        COMPSsConstants.TaskExecution executionType = COMPSsConstants.TaskExecution.valueOf(args[27].toUpperCase());
        boolean persistentC = Boolean.parseBoolean(args[28]);
        String pythonInterpreter = args[29];
        String pythonVersion = args[30];
        String pythonVirtualEnvironment = args[31];
        String pythonPropagateVirtualEnvironment = args[32];
        String pythonMpiWorker = args[33];
        JavaParams javaParams = new JavaParams(classpath);
        PythonParams pyParams = new PythonParams(pythonInterpreter, pythonVersion, pythonVirtualEnvironment, pythonPropagateVirtualEnvironment, pythonpath, pythonMpiWorker);
        CParams cParams = new CParams(classpath);
        if (WORKER_LOGGER.isDebugEnabled()) {
            WORKER_LOGGER.debug("maxSnd: " + String.valueOf(maxSnd));
            WORKER_LOGGER.debug("maxRcv: " + String.valueOf(maxRcv));
            WORKER_LOGGER.debug("WorkerName: " + workerIP);
            WORKER_LOGGER.debug("WorkerPort: " + String.valueOf(wPort));
            WORKER_LOGGER.debug("MasterName: " + mName);
            WORKER_LOGGER.debug("MasterPort: " + String.valueOf(mPort));
            WORKER_LOGGER.debug("StreamingPort: " + String.valueOf(streamingPort));
            WORKER_LOGGER.debug("Computing Units CPU: " + String.valueOf(computingUnitsCPU));
            WORKER_LOGGER.debug("Computing Units GPU: " + String.valueOf(computingUnitsGPU));
            WORKER_LOGGER.debug("Computing Units FPGA: " + String.valueOf(computingUnitsFPGA));
            WORKER_LOGGER.debug("User defined CPU Map: " + cpuMap);
            WORKER_LOGGER.debug("User defined GPU Map: " + gpuMap);
            WORKER_LOGGER.debug("User defined FPGA Map: " + fpgaMap);
            WORKER_LOGGER.debug("Limit Of Tasks: " + String.valueOf(limitOfTasks));
            WORKER_LOGGER.debug("App uuid: " + appUuid);
            WORKER_LOGGER.debug("WorkingDir:" + workingDir);
            WORKER_LOGGER.debug("Install Dir: " + installDir);
            WORKER_LOGGER.debug("Tracing: " + traceFlag);
            WORKER_LOGGER.debug("Extrae config File: " + extraeFile);
            WORKER_LOGGER.debug("Host: " + traceHost);
            WORKER_LOGGER.debug("LibraryPath: " + libPath);
            WORKER_LOGGER.debug("Classpath: " + classpath);
            WORKER_LOGGER.debug("Pythonpath: " + pythonpath);
            WORKER_LOGGER.debug("StorageConf: " + storageConf);
            WORKER_LOGGER.debug("executionType: " + (Object)((Object)executionType));
            WORKER_LOGGER.debug("Persistent c: " + persistentC);
            WORKER_LOGGER.debug("Python interpreter: " + pythonInterpreter);
            WORKER_LOGGER.debug("Python version: " + pythonVersion);
            WORKER_LOGGER.debug("Python virtual environment: " + pythonVirtualEnvironment);
            WORKER_LOGGER.debug("Python propagate virtual environment: " + pythonPropagateVirtualEnvironment);
            WORKER_LOGGER.debug("Python use MPI worker: " + pythonMpiWorker);
            WORKER_LOGGER.debug("Remove Sanbox WD: " + REMOVE_WD);
        }
        System.setProperty("compss.storage.conf", storageConf);
        System.setProperty("compss.extrae.file", extraeFile);
        NIOWorker nw = new NIOWorker(debug, maxSnd, maxRcv, workerIP, mName, mPort, streamingPort, computingUnitsCPU, computingUnitsGPU, computingUnitsFPGA, cpuMap, gpuMap, fpgaMap, limitOfTasks, appUuid, traceFlag, traceHost, storageConf, executionType, persistentC, workingDir, installDir, appDir, javaParams, pyParams, cParams);
        NIOMessageHandler mh = new NIOMessageHandler(nw);
        WORKER_LOGGER.debug("  Initializing the TransferManager structures...");
        try {
            TM.init(NIO_EVENT_MANAGER_CLASS, null, mh);
        }
        catch (CommException ce) {
            WORKER_LOGGER.error("Error initializing Transfer Manager on worker " + nw.getHostName(), (Throwable)ce);
            nw.shutdown(null);
            return;
        }
        try {
            TM.startServer(new NIONode(null, wPort));
        }
        catch (CommException ce) {
            WORKER_LOGGER.error("Error starting TransferManager Server at Worker" + nw.getHostName(), (Throwable)ce);
            nw.shutdown(null);
            return;
        }
        if (NIOTracer.extraeEnabled()) {
            NIOTracer.emitEvent(0L, TraceEvent.START.getType());
        }
        try {
            TM.join();
        }
        catch (InterruptedException ie) {
            WORKER_LOGGER.warn("TransferManager interrupted", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
    }

    static {
        String removeWDFlag = System.getProperty("compss.worker.removeWD");
        boolean removeWDFlagDefined = removeWDFlag != null && !removeWDFlag.isEmpty();
        REMOVE_WD = removeWDFlagDefined ? Boolean.valueOf(removeWDFlag) : true;
        OUT = new ThreadedPrintStream(SUFFIX_OUT, System.out);
        ERR = new ThreadedPrintStream(SUFFIX_ERR, System.err);
        System.setErr(ERR);
        System.setOut(OUT);
    }
}

