/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.data;

import es.bsc.compss.types.execution.InvocationParamURI;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;

public abstract class Data<T extends InvocationParamURI>
implements Externalizable {
    private String dataMgmtId;
    private LinkedList<T> sources;

    public Data() {
        this.dataMgmtId = "";
        this.sources = new LinkedList();
    }

    public Data(String dataMgmtId) {
        this.dataMgmtId = dataMgmtId;
        this.sources = new LinkedList();
    }

    public Data(String name, T uri) {
        this.dataMgmtId = name;
        this.sources = new LinkedList();
        this.sources.add(uri);
    }

    public String getDataMgmtId() {
        return this.dataMgmtId;
    }

    public void addSource(T uri) {
        this.sources.add(uri);
    }

    public LinkedList<T> getSources() {
        return this.sources;
    }

    public T getFirstURI() {
        if (this.sources != null && !this.sources.isEmpty()) {
            return (T)((InvocationParamURI)this.sources.getFirst());
        }
        return null;
    }

    public boolean compareTo(Data<T> n) {
        return n.dataMgmtId.compareTo(this.dataMgmtId) == 0;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dataMgmtId = in.readUTF();
        this.sources = (LinkedList)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.dataMgmtId);
        out.writeObject(this.sources);
    }

    public String toString() {
        return this.dataMgmtId + "@" + this.sources;
    }
}

