/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.binary;

import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.invokers.util.StdIOStream;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.MPIImplementation;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;

public class MPIInvoker
extends Invoker {
    private static final int NUM_BASE_MPI_ARGS = 6;
    private static final String ERROR_MPI_RUNNER = "ERROR: Invalid mpiRunner";
    private static final String ERROR_MPI_BINARY = "ERROR: Invalid mpiBinary";
    private static final String ERROR_TARGET_PARAM = "ERROR: MPI Execution doesn't support target parameters";
    private final String mpiRunner;
    private final String mpiBinary;

    public MPIInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        MPIImplementation mpiImpl = null;
        try {
            mpiImpl = (MPIImplementation)this.invocation.getMethodImplementation();
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)this.invocation.getMethodImplementation().getMethodType()), e);
        }
        this.mpiRunner = mpiImpl.getMpiRunner();
        this.mpiBinary = mpiImpl.getBinary();
    }

    private void checkArguments() throws JobExecutionException {
        if (this.mpiRunner == null || this.mpiRunner.isEmpty()) {
            throw new JobExecutionException(ERROR_MPI_RUNNER);
        }
        if (this.mpiBinary == null || this.mpiBinary.isEmpty()) {
            throw new JobExecutionException(ERROR_MPI_BINARY);
        }
        if (this.invocation.getTarget() != null && this.invocation.getTarget().getValue() != null) {
            throw new JobExecutionException(ERROR_TARGET_PARAM);
        }
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue;
        this.checkArguments();
        LOGGER.info("Invoked " + this.mpiBinary + " in " + this.context.getHostName());
        try {
            retValue = this.runInvocation();
        }
        catch (InvokeExecutionException iee) {
            throw new JobExecutionException(iee);
        }
        try {
            BinaryRunner.closeStreams(this.invocation.getParams(), this.pythonInterpreter);
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException(se);
        }
        for (InvocationParam invocationParam : this.invocation.getResults()) {
            if (invocationParam.getType() == DataType.FILE_T) {
                this.serializeBinaryExitValue(invocationParam, retValue);
                continue;
            }
            invocationParam.setValue(retValue);
            invocationParam.setValueClass(retValue.getClass());
        }
    }

    private Object runInvocation() throws InvokeExecutionException {
        String numProcs;
        StdIOStream streamValues = new StdIOStream();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, this.pythonInterpreter);
        String hostfile = MPIInvoker.writeHostfile(this.taskSandboxWorkingDir, this.workers);
        String[] cmd = new String[6 + binaryParams.size()];
        cmd[0] = this.mpiRunner;
        cmd[1] = "-hostfile";
        cmd[2] = hostfile;
        cmd[3] = "-n";
        cmd[4] = numProcs = String.valueOf(this.numWorkers * this.computingUnits);
        cmd[5] = this.mpiBinary;
        for (int i = 0; i < binaryParams.size(); ++i) {
            cmd[6 + i] = binaryParams.get(i);
        }
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[MPI INVOKER] Begin MPI call to " + this.mpiBinary);
            outLog.println("[MPI INVOKER] On WorkingDir : " + this.taskSandboxWorkingDir.getAbsolutePath());
            outLog.print("[MPI INVOKER] MPI CMD: ");
            for (int i = 0; i < cmd.length; ++i) {
                outLog.print(cmd[i] + " ");
            }
            outLog.println("");
            outLog.println("[MPI INVOKER] MPI STDIN: " + streamValues.getStdIn());
            outLog.println("[MPI INVOKER] MPI STDOUT: " + streamValues.getStdOut());
            outLog.println("[MPI INVOKER] MPI STDERR: " + streamValues.getStdErr());
        }
        return BinaryRunner.executeCMD(cmd, streamValues, this.taskSandboxWorkingDir, this.context.getThreadOutStream(), this.context.getThreadErrStream());
    }

    @Override
    public void cancelMethod() {
    }
}

