/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external.piped;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.executor.external.piped.ControlPipePair;
import es.bsc.compss.executor.external.piped.PipedMirror;
import es.bsc.compss.invokers.types.CParams;
import es.bsc.compss.types.execution.InvocationContext;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class CMirror
extends PipedMirror {
    private static final String BINDINGS_RELATIVE_PATH = File.separator + "Bindings" + File.separator + "bindings-common" + File.separator + "lib";
    private static final String C_PIPER = "c_piper.sh";
    private static final String LIBRARY_PATH_ENV = "LD_LIBRARY_PATH";
    private static final String C_LIB_RELATIVE_PATH = File.separator + "Bindings" + File.separator + "c" + File.separator + "lib";

    public CMirror(InvocationContext context, int size) {
        super(context, size);
        this.init(context);
    }

    @Override
    public String getPipeBuilderContext() {
        StringBuilder cmd = new StringBuilder();
        return cmd.toString();
    }

    @Override
    public String getLaunchWorkerCommand(InvocationContext context, ControlPipePair pipe) {
        int i;
        StringBuilder cmd = new StringBuilder();
        String installDir = context.getInstallDir();
        cmd.append(installDir).append(PIPER_SCRIPT_RELATIVE_PATH).append(C_PIPER).append(" ");
        String computePipes = this.basePipePath + "compute";
        cmd.append(this.size).append(" ");
        for (i = 0; i < this.size; ++i) {
            cmd.append(computePipes).append(i).append(".outbound").append(" ");
        }
        cmd.append(this.size).append(" ");
        for (i = 0; i < this.size; ++i) {
            cmd.append(computePipes).append(i).append(".inbound").append(" ");
        }
        cmd.append(pipe.getOutboundPipe()).append(" ");
        cmd.append(pipe.getInboundPipe());
        return cmd.toString();
    }

    @Override
    public Map<String, String> getEnvironment(InvocationContext context) {
        String ldLibraryPath = System.getenv(LIBRARY_PATH_ENV);
        CParams cParams = (CParams)context.getLanguageParams(COMPSsConstants.Lang.C);
        ldLibraryPath = ldLibraryPath == null ? cParams.getLibraryPath() : ldLibraryPath.concat(":" + cParams.getLibraryPath());
        ldLibraryPath = ldLibraryPath.concat(":" + context.getInstallDir() + C_LIB_RELATIVE_PATH);
        ldLibraryPath = ldLibraryPath.concat(":" + context.getInstallDir() + BINDINGS_RELATIVE_PATH);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(LIBRARY_PATH_ENV, ldLibraryPath);
        return env;
    }
}

