/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external.piped;

import es.bsc.compss.executor.external.ExternalExecutorException;
import es.bsc.compss.executor.external.piped.PipePair;
import es.bsc.compss.executor.external.piped.commands.CompssExceptionPipeCommand;
import es.bsc.compss.executor.external.piped.commands.EndTaskPipeCommand;
import es.bsc.compss.executor.external.piped.commands.PipeCommand;
import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.external.ExternalInvoker;
import es.bsc.compss.invokers.types.ExternalTaskStatus;
import es.bsc.compss.invokers.types.TypeValuePair;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamCollection;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.worker.COMPSsException;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public abstract class PipedInvoker
extends ExternalInvoker {
    private final PipePair pipes;

    public PipedInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources, PipePair pipes) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        this.pipes = pipes;
    }

    @Override
    public void invokeMethod() throws JobExecutionException, COMPSsException {
        int jobId = this.invocation.getJobId();
        if (!this.pipes.sendCommand((PipeCommand)((Object)this.command))) {
            LOGGER.error("ERROR: Could not execute job " + jobId + " because cannot write in pipe");
            throw new JobExecutionException("Job " + jobId + " has failed. Cannot write in pipe");
        }
        try {
            while (true) {
                PipeCommand rcvdCommand;
                if ((rcvdCommand = this.pipes.readCommand()) == null) {
                    continue;
                }
                switch (rcvdCommand.getType()) {
                    case END_TASK: {
                        ExternalTaskStatus taskStatus = ((EndTaskPipeCommand)rcvdCommand).getTaskStatus();
                        Integer exitValue = taskStatus.getExitValue();
                        if (exitValue != 0) {
                            throw new JobExecutionException("Job " + jobId + " exit with value " + exitValue);
                        }
                        LOGGER.debug("Updating parameters for job " + this.invocation.getJobId());
                        int parIdx = 0;
                        for (InvocationParam invocationParam : this.invocation.getParams()) {
                            this.updateParam(invocationParam, taskStatus, parIdx);
                            ++parIdx;
                        }
                        InvocationParam target = this.invocation.getTarget();
                        if (target != null) {
                            this.updateParam(target, taskStatus, parIdx);
                            ++parIdx;
                        }
                        for (InvocationParam invocationParam : this.invocation.getResults()) {
                            this.updateParam(invocationParam, taskStatus, parIdx);
                            ++parIdx;
                        }
                        return;
                    }
                    case COMPSS_EXCEPTION: {
                        throw new COMPSsException(((CompssExceptionPipeCommand)rcvdCommand).getMessage());
                    }
                }
                LOGGER.warn("Unexpected tag on PipedInvoker: " + rcvdCommand + ". Skipping message");
            }
        }
        catch (ExternalExecutorException e) {
            throw new JobExecutionException("Job " + jobId + "Notification pipe closed", e);
        }
    }

    private void updateParam(InvocationParam param, ExternalTaskStatus taskStatus, int parIdx) {
        DataType paramType = taskStatus.getParameterType(parIdx);
        if (paramType != null && paramType.equals((Object)DataType.EXTERNAL_PSCO_T)) {
            param.setType(paramType);
            String value = taskStatus.getParameterValue(parIdx);
            param.setValue(value);
            if (value != null) {
                param.setValueClass(value.getClass());
            }
        } else if (paramType != null && paramType.equals((Object)DataType.COLLECTION_T)) {
            param.setType(paramType);
            InvocationParamCollection ipc = (InvocationParamCollection)param;
            LinkedList<Object> values = taskStatus.getParameterValues(parIdx);
            if (ipc.getCollectionParameters().size() == values.size()) {
                this.updateParamCollection(ipc, values);
            }
        }
    }

    private void updateParamCollection(InvocationParamCollection ipc, LinkedList<Object> values) {
        List collectionParameters = ipc.getCollectionParameters();
        int position = 0;
        for (Object element : collectionParameters) {
            TypeValuePair pair;
            InvocationParam param = (InvocationParam)element;
            DataType elementType = param.getType();
            if (elementType.equals((Object)DataType.COLLECTION_T)) {
                param.setType(elementType);
                this.updateParamCollection((InvocationParamCollection)param, (LinkedList)values.get(position));
            } else if (elementType.equals((Object)DataType.EXTERNAL_PSCO_T)) {
                param.setType(elementType);
                pair = (TypeValuePair)values.get(position);
                if (pair != null) {
                    Object value = pair.getUpdatedParameterValue();
                    param.setValue(value);
                    if (value != null) {
                        param.setValueClass(value.getClass());
                    }
                } else {
                    param.setValue(null);
                }
            } else if (elementType.equals((Object)DataType.FILE_T) && (pair = (TypeValuePair)values.get(position)) != null && pair.getUpdatedParameterValue() != null) {
                param.setType(pair.getUpdatedParameterType());
                param.setValue(pair.getUpdatedParameterValue());
                param.setValueClass(pair.getUpdatedParameterValue().getClass());
            }
            ++position;
        }
    }

    @Override
    public void cancelMethod() {
        this.pipes.getMirror().cancelJob(this.pipes);
    }
}

