/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOResult;
import es.bsc.compss.nio.NIOResultCollection;
import es.bsc.compss.types.execution.InvocationParamCollection;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;

public class NIOParamCollection
extends NIOParam
implements InvocationParamCollection<NIOParam> {
    private List<NIOParam> collectionParameters;

    public NIOParamCollection() {
    }

    public NIOParamCollection(NIOParam p) {
        super(p);
        this.collectionParameters = new LinkedList<NIOParam>();
    }

    @Override
    public int getSize() {
        return this.collectionParameters.size();
    }

    @Override
    public List<NIOParam> getCollectionParameters() {
        return this.collectionParameters;
    }

    @Override
    public void addParameter(NIOParam p) {
        this.collectionParameters.add(p);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.collectionParameters = new LinkedList<NIOParam>();
        int numParameters = in.readInt();
        for (int i = 0; i < numParameters; ++i) {
            this.collectionParameters.add((NIOParam)in.readObject());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.collectionParameters.size());
        for (NIOParam subParam : this.collectionParameters) {
            out.writeObject(subParam);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[COLL_PARAM");
        this.dumpInternalInfo(sb);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public NIOResult getResult() {
        LinkedList<NIOResult> elements = new LinkedList<NIOResult>();
        for (NIOParam element : this.collectionParameters) {
            elements.add(element.getResult());
        }
        return new NIOResultCollection(this.getType(), this.getTargetPath(), elements);
    }
}

