/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers;

import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.util.ClassUtils;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.MultiNodeImplementation;
import es.bsc.compss.worker.CanceledTask;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import storage.StubItf;

public class JavaInvoker
extends Invoker {
    public static final String ERROR_CLASS_REFLECTION = "Cannot get class by reflection";
    public static final String ERROR_METHOD_REFLECTION = "Cannot get method by reflection";
    protected final String className;
    protected Class<?> methodClass;
    protected final String methodName;
    protected Method method;

    public JavaInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        switch (invocation.getMethodImplementation().getMethodType()) {
            case METHOD: {
                MethodImplementation methodImpl = (MethodImplementation)invocation.getMethodImplementation();
                this.className = methodImpl.getDeclaringClass();
                this.methodName = methodImpl.getAlternativeMethodName();
                break;
            }
            case MULTI_NODE: {
                MultiNodeImplementation multiNodeImpl = (MultiNodeImplementation)invocation.getMethodImplementation();
                this.className = multiNodeImpl.getDeclaringClass();
                this.methodName = multiNodeImpl.getMethodName();
                break;
            }
            default: {
                throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)invocation.getMethodImplementation().getMethodType()));
            }
        }
        this.method = this.findMethod();
    }

    protected Method findMethod() throws JobExecutionException {
        try {
            this.methodClass = Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            throw new JobExecutionException(ERROR_CLASS_REFLECTION, e);
        }
        try {
            return ClassUtils.findMethod(this.methodClass, this.methodName, this.invocation.getParams());
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new JobExecutionException(ERROR_METHOD_REFLECTION, e);
        }
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue = this.runMethod();
        for (InvocationParam invocationParam : this.invocation.getParams()) {
            this.checkSCOPersistence(invocationParam);
        }
        if (this.invocation.getTarget() != null) {
            this.checkSCOPersistence(this.invocation.getTarget());
        }
        for (InvocationParam invocationParam : this.invocation.getResults()) {
            invocationParam.setValue(retValue);
            if (retValue != null) {
                invocationParam.setValueClass(retValue.getClass());
            } else {
                invocationParam.setValueClass(null);
            }
            this.checkSCOPersistence(invocationParam);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object runMethod() throws JobExecutionException {
        Object[] values;
        List<? extends InvocationParam> params = this.invocation.getParams();
        int paramCount = this.method.getParameterCount();
        Object[] paramDest = values = new Object[paramCount];
        int paramIdx = 0;
        for (InvocationParam invocationParam : params) {
            if (paramIdx != paramCount - 1) {
                paramDest[paramIdx++] = invocationParam.getValue();
                continue;
            }
            Parameter reflectionParam = this.method.getParameters()[paramIdx];
            Class<?> paramClass = this.method.getParameters()[paramIdx].getType();
            if (reflectionParam.isVarArgs()) {
                int varArgsCount = params.size() - paramCount + 1;
                paramDest[paramIdx] = Array.newInstance(paramClass.getComponentType(), varArgsCount);
                paramDest = (Object[])paramDest[paramIdx];
                paramIdx = 0;
                paramDest[paramIdx++] = invocationParam.getValue();
                continue;
            }
            paramDest[paramIdx++] = invocationParam.getValue();
        }
        InvocationParam targetParam = this.invocation.getTarget();
        Object var7_8 = null;
        if (targetParam != null) {
            Object object = targetParam.getValue();
        }
        Object retValue = null;
        try {
            void var7_10;
            LOGGER.info("Invoked " + this.method.getName() + (var7_10 == null ? "" : " on object " + var7_10) + " in " + this.context.getHostName());
            retValue = this.method.invoke((Object)var7_10, values);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JobExecutionException("ERROR: Exception executing task (user code)", e);
        }
        return retValue;
    }

    private void checkSCOPersistence(InvocationParam np) {
        boolean potentialPSCO;
        boolean bl = potentialPSCO = np.getType().equals((Object)DataType.OBJECT_T) || np.getType().equals((Object)DataType.PSCO_T);
        if (np.isWriteFinalValue() && potentialPSCO) {
            Object obj = np.getValue();
            String id = null;
            try {
                StubItf psco = (StubItf)obj;
                id = psco.getID();
            }
            catch (Exception e) {
                id = null;
            }
            if (id != null) {
                np.setType(DataType.PSCO_T);
            }
        }
    }

    @Override
    public void cancelMethod() {
        CanceledTask t = new CanceledTask(this.invocation.getTaskId());
        t.cancel();
    }
}

