/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.comm.Connection;
import es.bsc.comm.TransferManager;
import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.nio.NIOEventManager;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.stage.Transfer;
import es.bsc.compss.data.BindingDataManager;
import es.bsc.compss.nio.NIOData;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.NIOUri;
import es.bsc.compss.nio.commands.Command;
import es.bsc.compss.nio.commands.CommandCancelTask;
import es.bsc.compss.nio.commands.CommandDataDemand;
import es.bsc.compss.nio.commands.CommandDataReceived;
import es.bsc.compss.nio.commands.CommandExecutorShutdown;
import es.bsc.compss.nio.commands.CommandExecutorShutdownACK;
import es.bsc.compss.nio.commands.CommandNIOTaskDone;
import es.bsc.compss.nio.commands.CommandNewTask;
import es.bsc.compss.nio.commands.CommandRemoveObsoletes;
import es.bsc.compss.nio.commands.CommandShutdown;
import es.bsc.compss.nio.commands.CommandShutdownACK;
import es.bsc.compss.nio.commands.CommandTracingID;
import es.bsc.compss.nio.commands.tracing.CommandGenerateDone;
import es.bsc.compss.nio.commands.tracing.CommandGeneratePackage;
import es.bsc.compss.nio.commands.workerfiles.CommandGenerateWorkerDebugFiles;
import es.bsc.compss.nio.commands.workerfiles.CommandWorkerDebugFilesDone;
import es.bsc.compss.nio.exceptions.SerializedObjectException;
import es.bsc.compss.nio.requests.DataRequest;
import es.bsc.compss.nio.utils.NIOBindingDataManager;
import es.bsc.compss.nio.utils.NIOBindingObjectStream;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Serializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class NIOAgent {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String DBG_PREFIX = "[NIO Agent] ";
    protected static final String NIO_EVENT_MANAGER_CLASS = NIOEventManager.class.getCanonicalName();
    public static final String ID = NIOAgent.class.getCanonicalName();
    protected static final TransferManager TM = new TransferManager();
    public static final int NUM_PARAMS_PER_WORKER_SH = 6;
    public static final int NUM_PARAMS_NIO_WORKER = 36;
    public static final String BINDER_DISABLED = "disabled";
    public static final String BINDER_AUTOMATIC = "automatic";
    private static final String COMPRESSED_DIR_EXTENSION = ".zip";
    private int sendTransfers = 0;
    private final int maxSendTransfers;
    private final Connection[] trasmittingConnections;
    private int receiveTransfers;
    private final int maxReceiveTransfers;
    private boolean finish;
    private Connection closingConnection = null;
    protected final Map<String, List<DataRequest>> dataToRequests;
    private final LinkedList<DataRequest> pendingRequests;
    private final Map<Connection, String> ongoingTransfers;
    private static final Map<Connection, Command> ONGOING_COMMANDS = new ConcurrentHashMap<Connection, Command>();
    protected int masterPort;
    protected NIONode masterNode;
    protected boolean tracing;
    protected int tracingLevel;
    protected int tracingId = 0;
    protected HashMap<Connection, Integer> connection2partner;

    public NIOAgent(int snd, int rcv, int port) {
        this.maxSendTransfers = snd;
        this.trasmittingConnections = new Connection[this.maxSendTransfers];
        this.receiveTransfers = 0;
        this.maxReceiveTransfers = rcv;
        this.masterPort = port;
        this.ongoingTransfers = new HashMap<Connection, String>();
        this.pendingRequests = new LinkedList();
        this.dataToRequests = new HashMap<String, List<DataRequest>>();
        this.connection2partner = new HashMap();
        this.finish = false;
        LOGGER.debug("[NIO Agent] Debug: " + DEBUG);
    }

    public NIONode getMaster() {
        return this.masterNode;
    }

    public static TransferManager getTransferManager() {
        return TM;
    }

    public void addConnectionAndPartner(Connection c, int partner, int tag) {
        this.connection2partner.put(c, partner);
    }

    protected List<DataRequest> getDataRequests(String dataId) {
        return this.dataToRequests.get(dataId);
    }

    public boolean hasPendingTransfers() {
        LOGGER.debug("pending: " + !this.pendingRequests.isEmpty() + " sendTransfers: " + (this.sendTransfers != 0) + " receiveTrasnfers: " + (this.receiveTransfers != 0) + "\n");
        return !this.pendingRequests.isEmpty() || this.sendTransfers != 0 || this.receiveTransfers != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTransfers() {
        DataRequest dr = null;
        LinkedList<DataRequest> linkedList = this.pendingRequests;
        synchronized (linkedList) {
            if (!this.pendingRequests.isEmpty() && this.tryAcquireReceiveSlot()) {
                dr = this.pendingRequests.remove();
            }
        }
        while (dr != null) {
            block20: {
                NIONode nn;
                NIOData source = dr.getSource();
                NIOUri uri = (NIOUri)source.getFirstURI();
                if (NIOTracer.extraeEnabled()) {
                    NIOTracer.emitDataTransferEvent(source.getDataMgmtId());
                }
                if ((nn = uri.getHost()).getIp() == null) {
                    nn = this.masterNode;
                }
                Connection c = null;
                try {
                    c = TM.startConnection(nn);
                    if (DEBUG) {
                        LOGGER.debug("[NIO Agent] Connection " + c.hashCode() + " will be used to acquire data " + dr.getTarget() + " stored in " + nn + " with name " + dr.getSource().getDataMgmtId());
                    }
                    NIOData remoteData = new NIOData(source.getDataMgmtId(), uri);
                    CommandDataDemand cdd = new CommandDataDemand(remoteData, this.tracingId);
                    NIOAgent.registerOngoingCommand(c, cdd);
                    this.ongoingTransfers.put(c, dr.getSource().getDataMgmtId());
                    c.sendCommand(cdd);
                    if (NIOTracer.extraeEnabled()) {
                        c.receive();
                    }
                    switch (dr.getType()) {
                        case DIRECTORY_T: {
                            c.receiveDataFile(dr.getTarget().concat(COMPRESSED_DIR_EXTENSION));
                            c.finishConnection();
                            break;
                        }
                        case FILE_T: 
                        case EXTERNAL_STREAM_T: {
                            c.receiveDataFile(dr.getTarget());
                            c.finishConnection();
                            break;
                        }
                        case BINDING_OBJECT_T: {
                            if (this.isPersistentCEnabled()) {
                                this.receiveBindingObject(c, dr);
                                break;
                            }
                            this.receiveBindingObjectAsFile(c, dr);
                            break;
                        }
                        default: {
                            c.receiveDataObject();
                            c.finishConnection();
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (c == null) break block20;
                    c.finishConnection();
                }
            }
            LinkedList<DataRequest> linkedList2 = this.pendingRequests;
            synchronized (linkedList2) {
                dr = !this.pendingRequests.isEmpty() && this.tryAcquireReceiveSlot() ? this.pendingRequests.remove() : null;
            }
            if (!NIOTracer.extraeEnabled()) continue;
            NIOTracer.emitDataTransferEvent("0");
        }
    }

    private void receiveBindingObject(Connection c, DataRequest dr) {
        String targetId;
        BindingObject bo;
        if (DEBUG) {
            LOGGER.debug("[NIO Agent] Receiving binding data " + dr.getTarget() + " from " + ((NIOUri)dr.getSource().getFirstURI()).getPath());
        }
        if ((bo = BindingObject.generate(targetId = dr.getTarget())).getElements() > 0) {
            c.receiveDataByteBuffer();
            c.finishConnection();
        } else {
            NIOBindingDataManager.receiveBindingObject(this, (NIOConnection)c, bo.getName(), bo.getType());
        }
    }

    private void receiveBindingObjectAsFile(Connection c, DataRequest dr) {
        if (DEBUG) {
            LOGGER.debug("[NIO Agent] Receiving binding data " + dr.getTarget() + " as file from " + ((NIOUri)dr.getSource().getFirstURI()).getPath());
        }
        String targetId = dr.getTarget();
        BindingObject bo = BindingObject.generate(targetId);
        c.receiveDataFile(bo.getId());
        c.finishConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransferRequest(DataRequest dr) {
        List<DataRequest> list = this.dataToRequests.get(dr.getSource().getDataMgmtId());
        if (list == null) {
            list = new LinkedList<DataRequest>();
            this.dataToRequests.put(dr.getSource().getDataMgmtId(), list);
            LinkedList<DataRequest> linkedList = this.pendingRequests;
            synchronized (linkedList) {
                this.pendingRequests.add(dr);
            }
        }
        list.add(dr);
    }

    public void sendData(Connection c, NIOData d, int receiverID) {
        if (NIOTracer.extraeEnabled()) {
            int tag = Math.abs(d.getDataMgmtId().hashCode());
            CommandTracingID cmd = new CommandTracingID(this.tracingId, tag);
            c.sendCommand(cmd);
            NIOTracer.emitDataTransferEvent(d.getDataMgmtId());
            NIOTracer.emitCommEvent(true, receiverID, tag);
        }
        String path = ((NIOUri)d.getFirstURI()).getPath();
        ProtocolType scheme = ((NIOUri)d.getFirstURI()).getProtocol();
        switch (scheme) {
            case DIR_URI: {
                this.compressAndSendDir(c, path, d);
                break;
            }
            case FILE_URI: 
            case SHARED_URI: 
            case EXTERNAL_STREAM_URI: {
                this.sendFile(c, path, d);
                break;
            }
            case BINDING_URI: {
                if (this.isPersistentCEnabled()) {
                    this.sendBindingObject(c, path, d);
                    break;
                }
                this.sendBindingObjectAsFile(c, path, d);
                break;
            }
            case OBJECT_URI: 
            case STREAM_URI: 
            case PERSISTENT_URI: {
                this.sendObject(c, path, d);
                break;
            }
            case ANY_URI: {
                if (path.startsWith(File.separator)) {
                    this.sendFile(c, path, d);
                    break;
                }
                this.sendObject(c, path, d);
            }
        }
        if (NIOTracer.extraeEnabled()) {
            NIOTracer.emitDataTransferEvent("0");
        }
        c.finishConnection();
    }

    private void sendObject(Connection c, String path, NIOData d) {
        try {
            Object o = this.getObject(path);
            if (DEBUG) {
                LOGGER.debug("[NIO Agent] Connection " + c.hashCode() + " will transfer an object as data " + d.getDataMgmtId());
            }
            c.sendDataObject(o);
        }
        catch (SerializedObjectException soe) {
            String newLocation = this.getObjectAsFile(path);
            if (DEBUG) {
                LOGGER.debug("[NIO Agent] Connection " + c.hashCode() + " will transfer an object-file " + newLocation + " as data " + d.getDataMgmtId());
            }
            this.sendFile(c, newLocation, d);
        }
    }

    private void sendFile(Connection c, String path, NIOData d) {
        if (path.startsWith(File.separator)) {
            File f = new File(path);
            if (f.exists()) {
                if (DEBUG) {
                    LOGGER.debug("[NIO Agent] Connection " + c.hashCode() + " will transfer file " + path + " as data " + d.getDataMgmtId());
                }
                c.sendDataFile(path);
            } else if (!f.getName().equals(d.getDataMgmtId())) {
                File renamed = new File(this.getPossiblyRenamedFileName(f, d));
                if (renamed.exists()) {
                    if (DEBUG) {
                        LOGGER.debug("[NIO Agent] Connection " + c.hashCode() + " will transfer file " + renamed.getAbsolutePath() + " as data " + d.getDataMgmtId());
                    }
                    c.sendDataFile(renamed.getAbsolutePath());
                } else {
                    ErrorManager.warn("Can't send niether file '" + path + "' nor file '" + renamed.getAbsolutePath() + "' via connection " + c.hashCode() + " because files don't exist.");
                    this.releaseSendSlot(c);
                    this.handleDataToSendNotAvailable(c, d);
                }
            } else {
                ErrorManager.warn("Can't send file '" + path + "' via connection " + c.hashCode() + " because file doesn't exist.");
                this.releaseSendSlot(c);
                this.handleDataToSendNotAvailable(c, d);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("[NIO Agent] Connection " + c.hashCode() + " will transfer object of data " + d.getDataMgmtId());
            }
            this.sendObject(c, path, d);
        }
    }

    private void compressAndSendDir(Connection c, String path, NIOData d) {
        File f = new File(path);
        if (f.exists()) {
            String zipFile;
            boolean zipCreated;
            if (DEBUG) {
                LOGGER.debug("[NIO Agent] Connection " + c.hashCode() + " will compress and transfer directory " + path + " as data " + d.getDataMgmtId());
            }
            if (!(zipCreated = this.createZip(path, zipFile = path.concat(COMPRESSED_DIR_EXTENSION)))) {
                ErrorManager.warn("Can't send directory '" + path + "'" + "' via connection " + c.hashCode() + " because '" + COMPRESSED_DIR_EXTENSION + "' file couldn't be created.");
                this.releaseSendSlot(c);
                this.handleDataToSendNotAvailable(c, d);
            }
            c.sendDataFile(zipFile);
        } else {
            ErrorManager.warn("Can't send directory '" + path + "' via connection " + c.hashCode() + " because it doesn't exist.");
            this.releaseSendSlot(c);
            this.handleDataToSendNotAvailable(c, d);
        }
    }

    private boolean createZip(String sourceDirPath, String zipFilePath) {
        Path p;
        try {
            p = Files.createFile(Paths.get(zipFilePath, new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fae) {
            File oldZipFile = new File(zipFilePath);
            try {
                Files.delete(oldZipFile.toPath());
            }
            catch (IOException e) {
                LOGGER.error("Error removing old zip file " + zipFilePath, (Throwable)e);
                return false;
            }
            try {
                p = Files.createFile(Paths.get(zipFilePath, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Error creating zip file " + zipFilePath, (Throwable)e);
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error creating zip file " + zipFilePath, (Throwable)e);
            return false;
        }
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            Path pp = Paths.get(sourceDirPath, new String[0]);
            Files.walk(pp, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    LOGGER.error("Error adding zip entry", (Throwable)e);
                }
            });
            LOGGER.debug("zip file of the directory '" + sourceDirPath + "' has been created");
        }
        catch (IOException e) {
            LOGGER.error(e);
            return false;
        }
        return true;
    }

    private void sendBindingObject(Connection c, String path, NIOData d) {
        if (path.contains("#")) {
            BindingObject bo = BindingObject.generate(path);
            if (bo.getElements() > 0) {
                ByteBuffer bb = BindingDataManager.getByteArray(bo.getName());
                if (bb != null) {
                    c.sendDataByteBuffer(bb);
                } else {
                    ErrorManager.warn("Can't send binding data '" + path + "' via connection " + c.hashCode() + " because bytebuffer is null.");
                    this.releaseSendSlot(c);
                    this.handleDataToSendNotAvailable(c, d);
                }
            } else {
                if (DEBUG) {
                    LOGGER.debug("[NIO Agent] Sending native object " + bo.getName());
                }
                NIOBindingObjectStream ncs = new NIOBindingObjectStream((NIOConnection)c, null);
                int res = NIOBindingDataManager.sendNativeObject(bo.getName(), ncs);
                if (res != 0) {
                    ErrorManager.warn("Can't send binding data '" + path + "' via connection " + c.hashCode() + " because sending native object call returned " + res);
                    this.releaseSendSlot(c);
                    this.handleDataToSendNotAvailable(c, d);
                }
            }
        } else {
            ErrorManager.warn("Can't send binding data '" + path + "' via connection " + c.hashCode() + " because incorrect path (doesn't contain #).");
            this.releaseSendSlot(c);
            this.handleDataToSendNotAvailable(c, d);
        }
    }

    private void sendBindingObjectAsFile(Connection c, String path, NIOData d) {
        if (path.contains("#")) {
            BindingObject bo = BindingObject.generate(path);
            File f = new File(bo.getId());
            if (BindingDataManager.isInBinding(bo.getName())) {
                int res = BindingDataManager.storeInFile(bo.getName(), bo.getId());
                if (res == 0) {
                    this.sendFile(c, f.getAbsolutePath(), d);
                } else {
                    ErrorManager.warn("Can't send binding data '" + path + "' via connection " + c.hashCode() + " because error serializing binding object.");
                    this.releaseSendSlot(c);
                    this.handleDataToSendNotAvailable(c, d);
                }
            } else if (f.exists()) {
                this.sendFile(c, f.getAbsolutePath(), d);
            } else {
                ErrorManager.warn("Can't send binding data '" + bo.getId() + "' via connection " + c.hashCode() + " because file doesn't exists.");
                this.releaseSendSlot(c);
                this.handleDataToSendNotAvailable(c, d);
            }
        } else {
            File f = new File(path);
            if (f.exists()) {
                this.sendFile(c, f.getAbsolutePath(), d);
            } else {
                ErrorManager.warn("Can't send binding data '" + path + "' via connection " + c.hashCode() + " because incorrect path (doesn't contain #).");
                this.releaseSendSlot(c);
                this.handleDataToSendNotAvailable(c, d);
            }
        }
    }

    public void receivedData(Connection c, Transfer t) {
        List<DataRequest> requests;
        String dataId = this.ongoingTransfers.remove(c);
        if (dataId == null) {
            return;
        }
        if (DEBUG) {
            LOGGER.debug("[NIO Agent] Receiving data " + dataId);
        }
        this.releaseReceiveSlot();
        if (NIOTracer.extraeEnabled()) {
            int tag = Math.abs(dataId.hashCode());
            NIOTracer.emitDataTransferEvent(dataId);
            NIOTracer.emitCommEvent(false, this.connection2partner.get(c), tag, t.getSize());
            this.connection2partner.remove(c);
        }
        if ((requests = this.dataToRequests.remove(dataId)) == null || requests.isEmpty()) {
            LOGGER.warn("WARN: No data removed for received data " + dataId);
            return;
        }
        HashMap<String, LinkedList<DataRequest>> byTarget = new HashMap<String, LinkedList<DataRequest>>();
        for (DataRequest req : requests) {
            LOGGER.debug("[NIO Agent] Group by target:" + req.getTarget() + "(" + dataId + ")");
            LinkedList<DataRequest> sameTarget = (LinkedList<DataRequest>)byTarget.get(req.getTarget());
            if (sameTarget == null) {
                sameTarget = new LinkedList<DataRequest>();
                byTarget.put(req.getTarget(), sameTarget);
            }
            sameTarget.add(req);
        }
        DataType drType = requests.get(0).getType();
        boolean isBindingType = drType.equals((Object)DataType.BINDING_OBJECT_T);
        boolean isDirectory = drType.equals((Object)DataType.DIRECTORY_T);
        if (byTarget.size() == 1) {
            String targetName = requests.get(0).getTarget();
            if (DEBUG) {
                LOGGER.debug("[NIO Agent] Data " + dataId + " will be saved as name " + targetName);
            }
            if (t.isFile()) {
                if (!this.isPersistentCEnabled() && isBindingType) {
                    this.receivedBindingObjectAsFile(t.getFileName(), targetName);
                }
                if (isDirectory) {
                    String zipFile = targetName.concat(COMPRESSED_DIR_EXTENSION);
                    LOGGER.debug("[NIO Agent] Compressed data " + zipFile + " will be decompressed  and saved as " + targetName);
                    this.extractFolder(zipFile, targetName);
                    this.receivedValue(t.getDestination(), targetName, t.getObject(), requests);
                } else {
                    this.receivedValue(t.getDestination(), targetName, t.getObject(), requests);
                }
            } else if (t.isObject()) {
                this.receivedValue(t.getDestination(), this.getName(targetName), t.getObject(), requests);
            } else if (t.isByteBuffer()) {
                String boPath = ((NIOUri)requests.get(0).getSource().getFirstURI()).getPath();
                BindingObject bo = this.getTargetBindingObject(targetName, boPath);
                NIOBindingDataManager.setByteArray(bo.getName(), t.getByteBuffer(), bo.getType(), bo.getElements());
                this.receivedValue(t.getDestination(), targetName, bo.toString(), requests);
            } else {
                BindingObject bo = this.getTargetBindingObject(targetName, ((NIOUri)requests.get(0).getSource().getFirstURI()).getPath());
                this.receivedValue(t.getDestination(), targetName, bo.toString(), requests);
            }
        } else {
            Map.Entry[] targetEntries;
            BindingObject bo;
            String workingDir = this.getWorkingDir();
            if (!workingDir.endsWith(File.separator)) {
                workingDir = workingDir + File.separator;
            }
            if (DEBUG) {
                LOGGER.debug("[NIO Agent] Data " + dataId + " will be saved as name " + dataId);
            }
            if (t.isFile()) {
                List reqs;
                if (DEBUG) {
                    LOGGER.debug("[NIO Agent] Data " + dataId + " will be saved as name " + t.getFileName());
                }
                if (!this.isPersistentCEnabled() && isBindingType) {
                    BindingObject bo2 = this.getTargetBindingObject(t.getFileName(), requests.get(0).getTarget());
                    reqs = (List)byTarget.remove(bo2.toString());
                    this.receivedBindingObjectAsFile(t.getFileName(), ((DataRequest)reqs.get(0)).getTarget());
                } else {
                    reqs = (List)byTarget.remove(t.getFileName());
                }
                if (isDirectory) {
                    String zipFile = new File(t.getFileName()).getName();
                    String targetName = t.getFileName().replace(COMPRESSED_DIR_EXTENSION, "");
                    LOGGER.debug("[NIO Agent] Compressed data " + zipFile + " will be decompressed  and saved as " + targetName);
                    this.extractFolder(zipFile, targetName);
                    this.receivedValue(t.getDestination(), targetName, t.getObject(), reqs);
                } else {
                    this.receivedValue(t.getDestination(), t.getFileName(), t.getObject(), reqs);
                }
            } else if (t.isObject()) {
                if (DEBUG) {
                    LOGGER.debug("[NIO Agent] Data " + dataId + " will be saved as name " + dataId);
                }
                this.receivedValue(t.getDestination(), this.getName(dataId), t.getObject(), (List)byTarget.remove(dataId));
            } else if (t.isByteBuffer()) {
                bo = this.getTargetBindingObject(workingDir + dataId, requests.get(0).getTarget());
                if (DEBUG) {
                    LOGGER.debug("[NIO Agent] Data " + dataId + " with target " + bo.toString() + " will be saved as name " + dataId);
                }
                NIOBindingDataManager.setByteArray(bo.getName(), t.getByteBuffer(), bo.getType(), bo.getElements());
                this.receivedValue(t.getDestination(), dataId, bo.toString(), (List)byTarget.remove(bo.toString()));
            } else {
                bo = this.getTargetBindingObject(workingDir + dataId, requests.get(0).getTarget());
                if (DEBUG) {
                    LOGGER.debug("[NIO Agent] Data " + dataId + " with target " + bo.toString() + "will be saved as name " + dataId);
                }
                this.receivedValue(t.getDestination(), dataId, bo.toString(), (List)byTarget.remove(bo.toString()));
            }
            for (Map.Entry entry : targetEntries = byTarget.entrySet().toArray(new Map.Entry[byTarget.size()])) {
                String targetName = (String)entry.getKey();
                List reqs = (List)entry.getValue();
                try {
                    BindingObject bo3;
                    if (DEBUG) {
                        LOGGER.debug("[NIO Agent] Data " + dataId + " will be saved as name " + targetName);
                    }
                    if (t.isFile()) {
                        if (!this.isPersistentCEnabled() && isBindingType) {
                            bo3 = this.getTargetBindingObject(targetName, requests.get(0).getTarget());
                            this.receivedBindingObjectAsFile(t.getFileName(), targetName);
                            this.receivedValue(t.getDestination(), bo3.getName(), bo3.toString(), (List)byTarget.remove(targetName));
                            continue;
                        }
                        Files.copy(new File(t.getFileName()).toPath(), new File(targetName).toPath(), new CopyOption[0]);
                        this.receivedValue(t.getDestination(), targetName, t.getObject(), (List)byTarget.remove(targetName));
                        continue;
                    }
                    if (t.isObject()) {
                        Object o = Serializer.deserialize(t.getArray());
                        this.receivedValue(t.getDestination(), this.getName(targetName), o, reqs);
                        continue;
                    }
                    bo3 = this.getTargetBindingObject(targetName, requests.get(0).getTarget());
                    NIOBindingDataManager.copyCachedData(dataId, bo3.getName());
                    this.receivedValue(t.getDestination(), bo3.getName(), bo3.toString(), (List)byTarget.remove(targetName));
                }
                catch (IOException | ClassNotFoundException e) {
                    LOGGER.warn("Can not replicate received Data", (Throwable)e);
                }
            }
        }
        this.requestTransfers();
        if (this.finish && !this.hasPendingTransfers()) {
            this.shutdown(this.closingConnection);
        }
    }

    private boolean extractFolder(String zipFilePath, String destination) {
        File destDir = new File(destination);
        if (destDir.exists()) {
            LOGGER.warn("Removing existing file: " + destination);
            if (destDir.isDirectory()) {
                try {
                    FileUtils.deleteDirectory(destDir);
                }
                catch (IOException ioe) {
                    LOGGER.error("Cannot remove existing folder: " + destination, (Throwable)ioe);
                    LOGGER.error("Cannot extract: " + zipFilePath);
                    return false;
                }
            } else if (!destDir.delete()) {
                LOGGER.error("Cannot remove existing file: " + destination);
                LOGGER.error("Cannot extract: " + zipFilePath);
                return false;
            }
        }
        destDir.mkdirs();
        int bufferSize = 2048;
        File zipAsFile = new File(zipFilePath);
        try (ZipFile zip = new ZipFile(zipAsFile);){
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(destination, currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                Throwable throwable = null;
                try {
                    BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(destFile), 2048);
                    Throwable throwable2 = null;
                    try {
                        int currentByte;
                        byte[] data = new byte[2048];
                        while ((currentByte = is.read(data, 0, 2048)) != -1) {
                            dest.write(data, 0, currentByte);
                        }
                        dest.flush();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (dest == null) continue;
                        if (throwable2 != null) {
                            try {
                                dest.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        dest.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error("ERROR extracting ZIP file " + zipFilePath, (Throwable)ioe);
            return false;
        }
        if (!zipAsFile.delete()) {
            LOGGER.warn(" Cannot remove zip file after decompression: " + zipAsFile.getName());
        }
        return true;
    }

    private String getName(String path) {
        int index = path.lastIndexOf(File.separator);
        if (index > 0) {
            return path.substring(index + 1);
        }
        return path;
    }

    private BindingObject getTargetBindingObject(String target, String originPath) {
        BindingObject bo;
        if (target.contains("#")) {
            bo = BindingObject.generate(target);
        } else {
            BindingObject boOr = BindingObject.generate(originPath);
            bo = new BindingObject(target, boOr.getType(), boOr.getElements());
        }
        return bo;
    }

    public void receivedShutdown(Connection requester, List<NIOData> filesToSend) {
        if (DEBUG) {
            LOGGER.debug("[NIO Agent] Command for shutdown received. Preparing for shutdown...");
        }
        this.closingConnection = requester;
        this.finish = true;
        if (!this.hasPendingTransfers()) {
            this.shutdown(this.closingConnection);
        } else {
            LOGGER.error("[ERROR] Pending transfers...");
            for (DataRequest dr : this.pendingRequests) {
                LOGGER.debug("[DEBUG] Pending: " + dr.getTarget() + " " + dr.getSource().getDataMgmtId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAcquireReceiveSlot() {
        boolean b = false;
        NIOAgent nIOAgent = this;
        synchronized (nIOAgent) {
            if (this.receiveTransfers < this.maxReceiveTransfers) {
                ++this.receiveTransfers;
                b = true;
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReceiveSlot() {
        NIOAgent nIOAgent = this;
        synchronized (nIOAgent) {
            --this.receiveTransfers;
        }
    }

    public boolean tryAcquireSendSlot(Connection c) {
        boolean b = false;
        if (this.sendTransfers < this.maxSendTransfers) {
            ++this.sendTransfers;
            b = true;
            for (int i = 0; i < this.maxSendTransfers; ++i) {
                if (this.trasmittingConnections[i] != null) continue;
                this.trasmittingConnections[i] = c;
                break;
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSendSlot(Connection c) {
        NIOAgent nIOAgent = this;
        synchronized (nIOAgent) {
            for (int i = 0; i < this.maxSendTransfers; ++i) {
                if (this.trasmittingConnections[i] != c) continue;
                this.trasmittingConnections[i] = null;
                --this.sendTransfers;
                if (!this.finish || this.hasPendingTransfers()) break;
                this.shutdown(this.closingConnection);
                break;
            }
        }
    }

    public boolean checkAndHandleRequestedDataNotAvailableError(Connection c) {
        String dataId = this.ongoingTransfers.remove(c);
        if (dataId == null) {
            LOGGER.error("Failed data connection not a tranfer");
            return false;
        }
        this.unregisterConnectionInOngoingCommands(c);
        this.releaseReceiveSlot();
        List<DataRequest> requests = this.dataToRequests.remove(dataId);
        this.handleRequestedDataNotAvailableError(requests, dataId);
        this.requestTransfers();
        if (this.finish && !this.hasPendingTransfers()) {
            this.shutdown(this.closingConnection);
        }
        return true;
    }

    public abstract boolean isPersistentCEnabled();

    public void generatePackage(Connection c) {
        NIOTracer.generatePackage();
        c.sendCommand(new CommandGenerateDone());
        c.finishConnection();
    }

    public abstract void setMaster(NIONode var1);

    protected abstract String getPossiblyRenamedFileName(File var1, NIOData var2);

    public abstract boolean isMyUuid(String var1, String var2);

    public abstract void setWorkerIsReady(String var1);

    public abstract String getWorkingDir();

    public abstract void receivedNewTask(NIONode var1, NIOTask var2, List<String> var3);

    public abstract void receivedNewDataFetchOrder(NIOParam var1, int var2);

    public abstract Object getObject(String var1) throws SerializedObjectException;

    public abstract String getObjectAsFile(String var1);

    protected abstract void handleDataToSendNotAvailable(Connection var1, NIOData var2);

    public abstract void handleRequestedDataNotAvailableError(List<DataRequest> var1, String var2);

    public abstract void receivedBindingObjectAsFile(String var1, String var2);

    public abstract void receivedValue(Transfer.Destination var1, String var2, Object var3, List<DataRequest> var4);

    public abstract void copiedData(int var1);

    public abstract void receivedNIOTaskDone(Connection var1, NIOTaskResult var2, boolean var3, Exception var4);

    public abstract void shutdown(Connection var1);

    public abstract void shutdownNotification(Connection var1);

    public abstract void shutdownExecutionManager(Connection var1);

    public abstract void shutdownExecutionManagerNotification(Connection var1);

    public abstract void waitUntilTracingPackageGenerated();

    public abstract void notifyTracingPackageGeneration();

    public abstract void generateWorkersDebugInfo(Connection var1);

    public abstract void waitUntilWorkersDebugInfoGenerated();

    public abstract void notifyWorkersDebugInfoGeneration();

    public void receivedPartialBindingObjects(Connection c, Transfer t) {
        NIOBindingDataManager.receivedPartialBindingObject((NIOConnection)c, t);
    }

    public abstract void increaseResources(MethodResourceDescription var1);

    public abstract void reduceResources(MethodResourceDescription var1);

    public abstract void performedResourceUpdate(Connection var1);

    public abstract void cancelRunningTask(NIONode var1, int var2);

    public abstract void unhandeledError(Connection var1);

    public abstract void handleCancellingTaskCommandError(Connection var1, CommandCancelTask var2);

    public abstract void handleDataReceivedCommandError(Connection var1, CommandDataReceived var2);

    public abstract void handleExecutorShutdownCommandError(Connection var1, CommandExecutorShutdown var2);

    public abstract void handleExecutorShutdownCommandACKError(Connection var1, CommandExecutorShutdownACK var2);

    public abstract void handleTaskDoneCommandError(Connection var1, CommandNIOTaskDone var2);

    public abstract void handleNewTaskCommandError(Connection var1, CommandNewTask var2);

    public abstract void handleShutdownCommandError(Connection var1, CommandShutdown var2);

    public abstract void handleShutdownACKCommandError(Connection var1, CommandShutdownACK var2);

    public abstract void handleTracingGenerateDoneCommandError(Connection var1, CommandGenerateDone var2);

    public abstract void handleTracingGenerateCommandError(Connection var1, CommandGeneratePackage var2);

    public abstract void handleGenerateWorkerDebugCommandError(Connection var1, CommandGenerateWorkerDebugFiles var2);

    public abstract void handleGenerateWorkerDebugDoneCommandError(Connection var1, CommandWorkerDebugFilesDone var2);

    protected void resendCommand(NIONode node, Command cmd) {
        Connection c = TM.startConnection(node);
        NIOAgent.registerOngoingCommand(c, cmd);
        c.sendCommand(cmd);
        c.finishConnection();
    }

    public static void registerOngoingCommand(Connection connection, Command command) {
        ONGOING_COMMANDS.put(connection, command);
    }

    protected void unregisterConnectionInOngoingCommands(Connection connection) {
        ONGOING_COMMANDS.remove(connection);
    }

    public boolean checkAndHandleCommandError(Connection c) {
        Command command = ONGOING_COMMANDS.remove(c);
        if (command == null) {
            LOGGER.error("Failed connection not a command");
            return false;
        }
        command.error(this, c);
        return true;
    }

    public abstract void receivedRemoveObsoletes(NIONode var1, List<String> var2);

    public abstract void handleRemoveObsoletesCommandError(Connection var1, CommandRemoveObsoletes var2);
}

