/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class Implementation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected Integer coreId;
    protected Integer implementationId;
    protected String signature;
    protected boolean io;
    protected WorkerResourceDescription requirements;

    public Implementation() {
    }

    public Implementation(Integer coreId, Integer implementationId, String signature, WorkerResourceDescription requirements) {
        this.coreId = coreId;
        this.implementationId = implementationId;
        this.signature = signature;
        this.requirements = requirements;
        this.io = requirements != null ? !requirements.usesCPUs() : false;
    }

    public Integer getCoreId() {
        return this.coreId;
    }

    public Integer getImplementationId() {
        return this.implementationId;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isIO() {
        return this.io;
    }

    public WorkerResourceDescription getRequirements() {
        return this.requirements;
    }

    public abstract TaskType getTaskType();

    public abstract ImplementationDefinition<?> getDefinition();

    public String toString() {
        StringBuilder sb = new StringBuilder("Implementation ").append(this.implementationId);
        sb.append(" for core ").append(this.coreId);
        sb.append(":");
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.coreId = (Integer)in.readObject();
        this.implementationId = (Integer)in.readObject();
        this.signature = in.readUTF();
        this.io = (Boolean)in.readObject();
        this.requirements = (WorkerResourceDescription)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.coreId);
        out.writeObject(this.implementationId);
        out.writeUTF(this.signature);
        out.writeObject(this.io);
        out.writeObject(this.requirements);
    }
}

