/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.CollectionLayout;
import es.bsc.compss.types.implementations.ContainerImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.BinaryDefinition;
import es.bsc.compss.types.implementations.definition.COMPSsDefinition;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.implementations.definition.DecafDefinition;
import es.bsc.compss.types.implementations.definition.MPIDefinition;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.implementations.definition.MultiNodeDefinition;
import es.bsc.compss.types.implementations.definition.OmpSsDefinition;
import es.bsc.compss.types.implementations.definition.OpenCLDefinition;
import es.bsc.compss.types.implementations.definition.PythonMPIDefinition;
import es.bsc.compss.types.implementations.definition.ServiceDefinition;
import es.bsc.compss.types.resources.ContainerDescription;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.util.EnvironmentLoader;

public abstract class ImplementationDefinition<T extends ResourceDescription> {
    private final String signature;
    private final T constraints;

    public static final <T extends ResourceDescription> ImplementationDefinition<T> defineImplementation(String implType, String implSignature, T implConstraints, String ... implTypeArgs) throws IllegalArgumentException {
        ImplementationDefinition id = null;
        if (implType.toUpperCase().compareTo(TaskType.SERVICE.toString()) == 0) {
            if (implTypeArgs.length != 4) {
                throw new IllegalArgumentException("Incorrect parameters for type SERVICE on " + implSignature);
            }
            String namespace = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
            String serviceName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
            String operation = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
            String port = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
            id = new ServiceDefinition(implSignature, namespace, serviceName, operation, port);
        } else {
            MethodType mt;
            try {
                mt = MethodType.valueOf(implType);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unrecognised method type " + implType);
            }
            switch (mt) {
                case METHOD: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type METHOD on " + implSignature);
                    }
                    String declaringClass = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String methodName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (declaringClass == null || declaringClass.isEmpty()) {
                        throw new IllegalArgumentException("Empty declaringClass annotation for method " + implSignature);
                    }
                    if (methodName == null || methodName.isEmpty()) {
                        throw new IllegalArgumentException("Empty methodName annotation for method " + implSignature);
                    }
                    id = new MethodDefinition(implSignature, declaringClass, methodName, (MethodResourceDescription)implConstraints);
                    break;
                }
                case PYTHON_MPI: {
                    if (implTypeArgs.length < 8) {
                        throw new IllegalArgumentException("Incorrect parameters for type MPI on " + implSignature);
                    }
                    String pythonMPIdeclaringClass = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String pythonMPImethodName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (pythonMPIdeclaringClass == null || pythonMPIdeclaringClass.isEmpty()) {
                        throw new IllegalArgumentException("Empty declaringClass annotation for method " + implSignature);
                    }
                    if (pythonMPImethodName == null || pythonMPImethodName.isEmpty()) {
                        throw new IllegalArgumentException("Empty methodName annotation for method " + implSignature);
                    }
                    String pythonMPIWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
                    String pythonMPIRunner = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
                    String pythonMPIFlags = EnvironmentLoader.loadFromEnvironment(implTypeArgs[4]);
                    boolean pythonMPIscaleByCU = Boolean.parseBoolean(implTypeArgs[5]);
                    boolean pythonMPIfailByEV = Boolean.parseBoolean(implTypeArgs[6]);
                    int numLayouts = Integer.parseInt(implTypeArgs[7]);
                    CollectionLayout[] cls = new CollectionLayout[numLayouts];
                    for (int i = 0; i < numLayouts; ++i) {
                        int offset = 8 + i * 4;
                        String pythonMPILayoutParam = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
                        int pythonMPIBlockSize = Integer.parseInt(EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]));
                        int pythonMPIBlockLen = Integer.parseInt(EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]));
                        int pythonMPIBlockStride = Integer.parseInt(EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 3]));
                        cls[i] = new CollectionLayout(pythonMPILayoutParam, pythonMPIBlockSize, pythonMPIBlockLen, pythonMPIBlockStride);
                    }
                    id = new PythonMPIDefinition(implSignature, pythonMPIdeclaringClass, pythonMPImethodName, pythonMPIWorkingDir, pythonMPIRunner, pythonMPIFlags, pythonMPIscaleByCU, pythonMPIfailByEV, cls, (MethodResourceDescription)implConstraints);
                    break;
                }
                case CONTAINER: {
                    if (implTypeArgs.length != 7) {
                        throw new IllegalArgumentException("Incorrect parameters for type CONTAINER on " + implSignature);
                    }
                    String engineStr = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    engineStr = engineStr.toUpperCase();
                    ContainerDescription.ContainerEngine engine = ContainerDescription.ContainerEngine.valueOf(engineStr);
                    String image = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    ContainerDescription container = new ContainerDescription(engine, image);
                    String internalTypeContainerStr = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
                    internalTypeContainerStr = internalTypeContainerStr.toUpperCase();
                    ContainerImplementation.ContainerExecutionType internalTypeContainer = ContainerImplementation.ContainerExecutionType.valueOf(internalTypeContainerStr);
                    String internalBinaryContainer = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
                    String internalFuncContainer = EnvironmentLoader.loadFromEnvironment(implTypeArgs[4]);
                    String binaryWorkingDirContainer = EnvironmentLoader.loadFromEnvironment(implTypeArgs[5]);
                    boolean binaryfailByEVContainer = Boolean.parseBoolean(implTypeArgs[6]);
                    switch (internalTypeContainer) {
                        case CET_BINARY: {
                            if (internalBinaryContainer != null && !internalBinaryContainer.isEmpty() && internalBinaryContainer != "[unassigned]") break;
                            throw new IllegalArgumentException("Empty binary annotation for CONTAINER method " + implSignature);
                        }
                        case CET_PYTHON: {
                            if (internalFuncContainer != null && !internalFuncContainer.isEmpty() && internalFuncContainer != "[unassigned]") break;
                            throw new IllegalArgumentException("Empty python function annotation for CONTAINER method " + implSignature);
                        }
                    }
                    id = new ContainerDefinition(implSignature, internalTypeContainer, internalFuncContainer, internalBinaryContainer, binaryWorkingDirContainer, binaryfailByEVContainer, container, (MethodResourceDescription)implConstraints);
                    break;
                }
                case BINARY: {
                    if (implTypeArgs.length != 3) {
                        throw new IllegalArgumentException("Incorrect parameters for type BINARY on " + implSignature);
                    }
                    String binary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String binaryWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    boolean binaryfailByEV = Boolean.parseBoolean(implTypeArgs[2]);
                    if (binary == null || binary.isEmpty() || binary == "[unassigned]") {
                        throw new IllegalArgumentException("Empty binary annotation for BINARY method " + implSignature);
                    }
                    id = new BinaryDefinition(implSignature, binary, binaryWorkingDir, binaryfailByEV, (MethodResourceDescription)implConstraints);
                    break;
                }
                case MPI: {
                    if (implTypeArgs.length != 6) {
                        throw new IllegalArgumentException("Incorrect parameters for type MPI on " + implSignature);
                    }
                    String mpiBinary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String mpiWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    String mpiRunner = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
                    String mpiFlags = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
                    boolean mpiScaleByCU = Boolean.parseBoolean(implTypeArgs[4]);
                    boolean mpiFailByEV = Boolean.parseBoolean(implTypeArgs[5]);
                    if (mpiRunner == null || mpiRunner.isEmpty()) {
                        throw new IllegalArgumentException("Empty mpiRunner annotation for MPI method " + implSignature);
                    }
                    if (mpiBinary == null || mpiBinary.isEmpty()) {
                        throw new IllegalArgumentException("Empty binary annotation for MPI method " + implSignature);
                    }
                    id = new MPIDefinition(implSignature, mpiBinary, mpiWorkingDir, mpiRunner, mpiFlags, mpiScaleByCU, mpiFailByEV, (MethodResourceDescription)implConstraints);
                    break;
                }
                case COMPSs: {
                    if (implTypeArgs.length != 6) {
                        throw new IllegalArgumentException("Incorrect parameters for type MPI on " + implSignature);
                    }
                    String runcompss = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String flags = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    String appName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
                    String workerInMaster = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
                    String compssWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[4]);
                    boolean compssFailByEV = Boolean.parseBoolean(implTypeArgs[5]);
                    if (appName == null || appName.isEmpty()) {
                        throw new IllegalArgumentException("Empty appName annotation for COMPSs method " + implSignature);
                    }
                    id = new COMPSsDefinition(implSignature, runcompss, flags, appName, workerInMaster, compssWorkingDir, compssFailByEV, (MethodResourceDescription)implConstraints);
                    break;
                }
                case DECAF: {
                    if (implTypeArgs.length != 6) {
                        throw new IllegalArgumentException("Incorrect parameters for type DECAF on " + implSignature);
                    }
                    String dfScript = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String dfExecutor = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    String dfLib = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
                    String decafWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
                    String decafRunner = EnvironmentLoader.loadFromEnvironment(implTypeArgs[4]);
                    boolean decafFailByEV = Boolean.parseBoolean(implTypeArgs[5]);
                    if (decafRunner == null || decafRunner.isEmpty()) {
                        throw new IllegalArgumentException("Empty mpiRunner annotation for DECAF method " + implSignature);
                    }
                    if (dfScript == null || dfScript.isEmpty()) {
                        throw new IllegalArgumentException("Empty dfScript annotation for DECAF method " + implSignature);
                    }
                    id = new DecafDefinition(implSignature, dfScript, dfExecutor, dfLib, decafWorkingDir, decafRunner, decafFailByEV, (MethodResourceDescription)implConstraints);
                    break;
                }
                case OMPSS: {
                    if (implTypeArgs.length != 3) {
                        throw new IllegalArgumentException("Incorrect parameters for type OMPSS on " + implSignature);
                    }
                    String ompssBinary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String ompssWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    boolean ompssFailByEV = Boolean.parseBoolean(implTypeArgs[2]);
                    if (ompssBinary == null || ompssBinary.isEmpty()) {
                        throw new IllegalArgumentException("Empty binary annotation for OmpSs method " + implSignature);
                    }
                    id = new OmpSsDefinition(implSignature, ompssBinary, ompssWorkingDir, ompssFailByEV, (MethodResourceDescription)implConstraints);
                    break;
                }
                case OPENCL: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type OPENCL on " + implSignature);
                    }
                    String openclKernel = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String openclWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (openclKernel == null || openclKernel.isEmpty()) {
                        throw new IllegalArgumentException("Empty kernel annotation for OpenCL method " + implSignature);
                    }
                    id = new OpenCLDefinition(implSignature, openclKernel, openclWorkingDir, (MethodResourceDescription)implConstraints);
                    break;
                }
                case MULTI_NODE: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type MultiNode on " + implSignature);
                    }
                    String multiNodeClass = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String multiNodeName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (multiNodeClass == null || multiNodeClass.isEmpty()) {
                        throw new IllegalArgumentException("Empty declaringClass annotation for method " + implSignature);
                    }
                    if (multiNodeName == null || multiNodeName.isEmpty()) {
                        throw new IllegalArgumentException("Empty methodName annotation for method " + implSignature);
                    }
                    id = new MultiNodeDefinition(implSignature, multiNodeClass, multiNodeName, (MethodResourceDescription)implConstraints);
                }
            }
        }
        return id;
    }

    protected ImplementationDefinition(String signature, T constraints) {
        this.signature = signature;
        this.constraints = constraints;
    }

    public String getSignature() {
        return this.signature;
    }

    public T getConstraints() {
        return this.constraints;
    }

    public abstract Implementation getImpl(int var1, int var2);
}

