/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.execution.types.ExecutorContext;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.executor.InvocationRunner;
import es.bsc.compss.executor.external.ExecutionPlatformMirror;
import es.bsc.compss.executor.external.persistent.PersistentMirror;
import es.bsc.compss.executor.external.piped.PipePair;
import es.bsc.compss.executor.external.piped.PipedMirror;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.JavaInvoker;
import es.bsc.compss.invokers.JavaNestedInvoker;
import es.bsc.compss.invokers.OpenCLInvoker;
import es.bsc.compss.invokers.StorageInvoker;
import es.bsc.compss.invokers.binary.BinaryInvoker;
import es.bsc.compss.invokers.binary.COMPSsInvoker;
import es.bsc.compss.invokers.binary.ContainerInvoker;
import es.bsc.compss.invokers.binary.DecafInvoker;
import es.bsc.compss.invokers.binary.MPIInvoker;
import es.bsc.compss.invokers.binary.OmpSsInvoker;
import es.bsc.compss.invokers.external.ExternalInvoker;
import es.bsc.compss.invokers.external.PythonMPIInvoker;
import es.bsc.compss.invokers.external.persistent.CPersistentInvoker;
import es.bsc.compss.invokers.external.piped.CInvoker;
import es.bsc.compss.invokers.external.piped.PythonInvoker;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.execution.Execution;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamCollection;
import es.bsc.compss.types.execution.InvocationParamDictCollection;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.execution.exceptions.UnsufficientAvailableResourcesException;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.definition.BinaryDefinition;
import es.bsc.compss.types.implementations.definition.COMPSsDefinition;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.implementations.definition.DecafDefinition;
import es.bsc.compss.types.implementations.definition.MPIDefinition;
import es.bsc.compss.types.implementations.definition.OmpSsDefinition;
import es.bsc.compss.types.implementations.definition.OpenCLDefinition;
import es.bsc.compss.types.implementations.definition.PythonMPIDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.worker.COMPSsException;
import es.bsc.compss.worker.TimeOutTask;
import es.bsc.wdc.affinity.ThreadAffinity;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Executor
implements Runnable,
InvocationRunner {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    private static final boolean WORKER_DEBUG = LOGGER.isDebugEnabled();
    private static final Logger TIMER_LOGGER = LogManager.getLogger("es.bsc.compss.Timers");
    private static final String ERROR_OUT_FILES = "ERROR: One or more OUT files have not been created by task with Method Definition [";
    private static final String WARN_ATOMIC_MOVE = "WARN: AtomicMoveNotSupportedException. File cannot be atomically moved. Trying to move without atomic";
    public static final boolean IS_TIMER_COMPSS_ENABLED;
    private static final int NANO_TO_MS = 1000000;
    private final InvocationContext context;
    protected final ExecutorContext platform;
    protected final String id;
    protected boolean isRegistered;
    protected PipePair cPipes;
    protected PipePair pyPipes;
    protected Invocation invocation;
    protected Invoker invoker;
    protected InvocationResources resources;

    public Executor(InvocationContext context, ExecutorContext platform, String executorId) {
        LOGGER.info("Executor " + executorId + " init");
        this.context = context;
        this.platform = platform;
        this.id = executorId;
        this.isRegistered = false;
    }

    public void start() {
        LOGGER.info("Executor started");
    }

    @Override
    public void run() {
        this.start();
        this.processRequests();
        this.finish();
    }

    public void finish() {
        if (Tracer.extraeEnabled()) {
            this.emitAffinityEndEvents();
        }
        LOGGER.info("Executor " + this.id + " finished");
        Collection<ExecutionPlatformMirror<?>> mirrors = this.platform.getMirrors();
        for (ExecutionPlatformMirror<?> mirror : mirrors) {
            mirror.unregisterExecutor(this.id);
        }
    }

    public String getId() {
        return this.id;
    }

    private void processRequests() {
        while (true) {
            Execution execution;
            if ((execution = this.platform.getJob()) == null) {
                LOGGER.error("ERROR: Execution is null!!!!!");
                continue;
            }
            if (execution.getInvocation() == null) break;
            this.processExecution(execution);
        }
        LOGGER.debug("Dequeued job is null.");
    }

    private void processExecution(Execution execution) {
        Throwable rootCause;
        Exception e;
        boolean success;
        this.invocation = execution.getInvocation();
        if (this.invocation == null) {
            LOGGER.error("Dequeued job is null");
            return;
        }
        if (WORKER_DEBUG) {
            LOGGER.debug("Dequeuing job " + this.invocation.getJobId());
        }
        boolean bl = success = (e = this.execute()) == null;
        if (WORKER_DEBUG) {
            LOGGER.debug("Job " + this.invocation.getJobId() + " finished (success: " + success + ")");
        }
        if ((rootCause = ExceptionUtils.getRootCause(e)) instanceof COMPSsException) {
            e = (COMPSsException)rootCause;
        }
        if (e instanceof COMPSsException) {
            execution.notifyEnd((COMPSsException)e, success);
        } else {
            execution.notifyEnd(null, success);
        }
        this.invocation = null;
    }

    private Exception execute() {
        if (this.invocation.getMethodImplementation().getMethodType() == MethodType.METHOD && this.invocation.getLang() != COMPSsConstants.Lang.JAVA && this.invocation.getLang() != COMPSsConstants.Lang.PYTHON && this.invocation.getLang() != COMPSsConstants.Lang.C) {
            LOGGER.error("Incorrect language " + (Object)((Object)this.invocation.getLang()) + " in job " + this.invocation.getJobId());
            System.err.println("Incorrect language " + (Object)((Object)this.invocation.getLang()) + " in job " + this.invocation.getJobId());
            return null;
        }
        return this.executeTaskWrapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Exception executeTaskWrapper() {
        if (Tracer.extraeEnabled()) {
            this.emitingTaskStartEvents();
        }
        long timeTotalStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeTotalStart = System.nanoTime();
        }
        int jobId = this.invocation.getJobId();
        TaskWorkingDir twd = null;
        boolean failureUnbindingFiles = false;
        boolean areResourcesAcquired = false;
        long timeUnbindOriginalFilesStart = 0L;
        try {
            LOGGER.debug("Assigning resources for Job " + jobId);
            this.obtainExecutionResources(jobId, this.invocation.getRequirements());
            areResourcesAcquired = true;
            LOGGER.debug("Creating task sandbox for Job " + jobId);
            twd = this.createTaskSandbox();
            LOGGER.debug("Binding renamed files to sandboxed original names for Job " + jobId);
            this.bindOriginalFilenamesToRenames(twd.getWorkingDir());
            LOGGER.debug("Executing task invocation for Job " + jobId);
            long timeExecTaskStart = 0L;
            if (IS_TIMER_COMPSS_ENABLED) {
                timeExecTaskStart = System.nanoTime();
            }
            this.executeTask(twd.getWorkingDir());
            if (IS_TIMER_COMPSS_ENABLED) {
                long timeExecTaskEnd = System.nanoTime();
                float timeExecTaskElapsed = (float)(timeExecTaskEnd - timeExecTaskStart) / 1000000.0f;
                TIMER_LOGGER.info("[TIMER] Execute job " + jobId + ": " + timeExecTaskElapsed + " ms");
            }
            failureUnbindingFiles = true;
            LOGGER.debug("Removing renamed files to sandboxed original names for Job " + jobId);
            if (IS_TIMER_COMPSS_ENABLED) {
                timeUnbindOriginalFilesStart = System.nanoTime();
            }
            this.unbindOriginalFileNamesToRenames(false);
            return null;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.context.getThreadOutStream().println("Exception executing task " + e.getMessage());
            e.printStackTrace(this.context.getThreadErrStream());
            if (!failureUnbindingFiles) {
                LOGGER.debug("Removing renamed files to sandboxed original names for Job " + jobId);
                if (IS_TIMER_COMPSS_ENABLED) {
                    timeUnbindOriginalFilesStart = System.nanoTime();
                }
                try {
                    this.unbindOriginalFileNamesToRenames(true);
                }
                catch (JobExecutionException | IOException ex) {
                    LOGGER.warn("Another exception after unbinding files: " + ex.getMessage(), (Throwable)ex);
                    this.context.getThreadOutStream().println("Another exception unbinding files: " + ex.getMessage());
                    ex.printStackTrace(this.context.getThreadErrStream());
                }
            }
            Exception exception = e;
            return exception;
        }
        finally {
            if (IS_TIMER_COMPSS_ENABLED) {
                long timeUnbindOriginalFilesEnd = System.nanoTime();
                float timeUnbindOriginalFilesElapsed = (float)(timeUnbindOriginalFilesEnd - timeUnbindOriginalFilesStart) / 1000000.0f;
                TIMER_LOGGER.debug("[TIMER] Unbind original files for job " + jobId + ": " + timeUnbindOriginalFilesElapsed + " ms");
            }
            LOGGER.debug("Checking generated files for Job " + jobId);
            long timeCheckOutputFilesStart = 0L;
            if (IS_TIMER_COMPSS_ENABLED) {
                timeCheckOutputFilesStart = System.nanoTime();
            }
            try {
                this.checkJobFiles(this.invocation);
            }
            catch (JobExecutionException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.context.getThreadOutStream().println("Exception executing task " + e.getMessage());
                e.printStackTrace(this.context.getThreadErrStream());
                JobExecutionException jobExecutionException = e;
                return jobExecutionException;
            }
            finally {
                if (IS_TIMER_COMPSS_ENABLED) {
                    long timeCheckOutputFilesEnd = System.nanoTime();
                    float timeCheckOutputFilesElapsed = (float)(timeCheckOutputFilesEnd - timeCheckOutputFilesStart) / 1000000.0f;
                    TIMER_LOGGER.debug("[TIMER] Check output files for job " + jobId + ": " + timeCheckOutputFilesElapsed + " ms");
                }
                if (areResourcesAcquired) {
                    this.releaseResources(jobId);
                }
                LOGGER.debug("Cleaning task sandbox for Job " + jobId);
                this.cleanTaskSandbox(twd, jobId);
                if (Tracer.extraeEnabled()) {
                    this.emitTaskEndEvents();
                }
                if (IS_TIMER_COMPSS_ENABLED) {
                    long timeTotalEnd = System.nanoTime();
                    float timeTotalElapsed = (float)(timeTotalEnd - timeTotalStart) / 1000000.0f;
                    TIMER_LOGGER.info("[TIMER] Total time for job " + jobId + ": " + timeTotalElapsed + " ms");
                }
            }
        }
    }

    private void executeTask(File taskSandboxWorkingDir) throws Exception {
        block21: {
            String streamsPath = this.context.getStandardStreamsPath(this.invocation);
            this.context.registerOutputs(streamsPath);
            PrintStream out = this.context.getThreadOutStream();
            if (this.invocation.isDebugEnabled()) {
                out.println("[EXECUTOR] executeTask - Begin task execution");
            }
            TimerTask timerTask = null;
            try {
                switch (this.invocation.getMethodImplementation().getMethodType()) {
                    case METHOD: 
                    case MULTI_NODE: {
                        this.invoker = this.selectNativeMethodInvoker(taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case CONTAINER: {
                        this.invoker = new ContainerInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case BINARY: {
                        this.invoker = new BinaryInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case PYTHON_MPI: {
                        this.invoker = new PythonMPIInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case MPI: {
                        this.invoker = new MPIInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case COMPSs: {
                        this.invoker = new COMPSsInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case DECAF: {
                        this.invoker = new DecafInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case OMPSS: {
                        this.invoker = new OmpSsInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case OPENCL: {
                        this.invoker = new OpenCLInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                    }
                }
                timerTask = new TimeOutTask(this.invocation.getTaskId());
                this.platform.registerRunningJob(this.invocation, this.invoker, timerTask);
                if (this.invoker != null) {
                    this.invoker.runInvocation(this);
                    break block21;
                }
                throw new JobExecutionException("Undefined invoker. It could be cause by an incoherent task type");
            }
            catch (Exception jee) {
                out.println("[EXECUTOR] executeTask - Error in task execution");
                PrintStream err = this.context.getThreadErrStream();
                err.println("[EXECUTOR] executeTask - Error in task execution");
                if (this.invocation.getOnFailure() != OnFailure.RETRY) {
                    this.createEmptyFile();
                }
                jee.printStackTrace(err);
                throw jee;
            }
            finally {
                if (timerTask != null) {
                    timerTask.cancel();
                }
                if (this.invocation.isDebugEnabled()) {
                    out.println("[EXECUTOR] executeTask - End task execution");
                }
                this.platform.unregisterRunningJob(this.invocation.getJobId());
                this.invoker = null;
                this.context.unregisterOutputs();
            }
        }
    }

    private void checkJobFiles(Invocation invocation) throws JobExecutionException {
        boolean allOutFilesCreated = true;
        for (InvocationParam invocationParam : invocation.getParams()) {
            allOutFilesCreated &= this.checkOutParam(invocationParam);
        }
        for (InvocationParam invocationParam : invocation.getResults()) {
            allOutFilesCreated &= this.checkOutParam(invocationParam);
        }
        if (!allOutFilesCreated) {
            throw new JobExecutionException(ERROR_OUT_FILES + invocation.getMethodImplementation().getMethodDefinition());
        }
    }

    private boolean checkOutParam(InvocationParam param) {
        if (param.getType().equals((Object)DataType.FILE_T)) {
            String filepath;
            File f;
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(TraceEvent.CHECK_OUT_PARAM.getId(), TraceEvent.CHECK_OUT_PARAM.getType());
            }
            if (!(f = new File(filepath = (String)param.getValue())).exists()) {
                StringBuilder errMsg = new StringBuilder();
                errMsg.append("ERROR: File with path '").append(filepath);
                errMsg.append("' not generated by task with Method Definition ").append(this.invocation.getMethodImplementation().getMethodDefinition());
                System.out.println(errMsg.toString());
                System.err.println(errMsg.toString());
                return false;
            }
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, TraceEvent.CHECK_OUT_PARAM.getType());
            }
        }
        return true;
    }

    private void createEmptyFile() {
        PrintStream out = this.context.getThreadOutStream();
        out.println("[EXECUTOR] executeTask - Checking if a blank file needs to be created");
        for (InvocationParam invocationParam : this.invocation.getParams()) {
            String filepath;
            File f;
            if (!invocationParam.getType().equals((Object)DataType.FILE_T) || (f = new File(filepath = (String)invocationParam.getValue())).exists()) continue;
            out.println("[EXECUTOR] executeTask - Creating a new blank file");
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                System.err.println("[EXECUTOR] checkJobFiles - Error in creating a new blank file");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Invoker selectNativeMethodInvoker(File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        switch (this.invocation.getLang()) {
            case JAVA: {
                JavaInvoker javaInvoker = null;
                switch (this.context.getExecutionType()) {
                    case COMPSS: {
                        if (this.context.getRuntimeAPI() != null && this.context.getLoaderAPI() != null) {
                            System.out.println("Nested Support enabled on the Invocation Context!");
                            javaInvoker = new JavaNestedInvoker(this.context, this.invocation, taskSandboxWorkingDir, assignedResources);
                            break;
                        }
                        javaInvoker = new JavaInvoker(this.context, this.invocation, taskSandboxWorkingDir, assignedResources);
                        break;
                    }
                    case STORAGE: {
                        javaInvoker = new StorageInvoker(this.context, this.invocation, taskSandboxWorkingDir, assignedResources);
                    }
                }
                return javaInvoker;
            }
            case PYTHON: {
                if (this.pyPipes == null) {
                    PipedMirror mirror;
                    ExecutorContext executorContext = this.platform;
                    synchronized (executorContext) {
                        mirror = (PipedMirror)this.platform.getMirror(PythonInvoker.class);
                        if (mirror == null) {
                            mirror = PythonInvoker.getMirror(this.context, this.platform);
                            this.platform.registerMirror(PythonInvoker.class, mirror);
                        }
                    }
                    this.pyPipes = mirror.registerExecutor(this.id);
                }
                return new PythonInvoker(this.context, this.invocation, taskSandboxWorkingDir, assignedResources, this.pyPipes);
            }
            case C: {
                ExternalInvoker cInvoker = null;
                if (this.context.isPersistentCEnabled()) {
                    cInvoker = new CPersistentInvoker(this.context, this.invocation, taskSandboxWorkingDir, assignedResources);
                    if (!this.isRegistered) {
                        PersistentMirror mirror;
                        ExecutorContext executorContext = this.platform;
                        synchronized (executorContext) {
                            mirror = (PersistentMirror)this.platform.getMirror(CPersistentInvoker.class);
                            if (mirror == null) {
                                mirror = CPersistentInvoker.getMirror(this.context, this.platform);
                                this.platform.registerMirror(CPersistentInvoker.class, mirror);
                            }
                        }
                        mirror.registerExecutor(this.id);
                        this.isRegistered = true;
                    }
                } else {
                    if (this.cPipes == null) {
                        PipedMirror mirror;
                        ExecutorContext executorContext = this.platform;
                        synchronized (executorContext) {
                            mirror = (PipedMirror)this.platform.getMirror(CInvoker.class);
                            if (mirror == null) {
                                mirror = (PipedMirror)CInvoker.getMirror(this.context, this.platform);
                                this.platform.registerMirror(CInvoker.class, mirror);
                            }
                        }
                        this.cPipes = mirror.registerExecutor(this.id);
                    }
                    cInvoker = new CInvoker(this.context, this.invocation, taskSandboxWorkingDir, assignedResources, this.cPipes);
                }
                return cInvoker;
            }
        }
        throw new JobExecutionException("Unrecognised lang for a method type invocation");
    }

    private void obtainExecutionResources(int jobId, ResourceDescription requirements) throws UnsufficientAvailableResourcesException {
        long timeAssignResourcesStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeAssignResourcesStart = System.nanoTime();
        }
        this.resources = this.platform.acquireResources(jobId, requirements, this.resources);
        this.assignExecutionResources();
        if (IS_TIMER_COMPSS_ENABLED) {
            long timeAssignResourcesEnd = System.nanoTime();
            float timeAssignResourcesElapsed = (float)(timeAssignResourcesEnd - timeAssignResourcesStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Assign resources for job " + jobId + ": " + timeAssignResourcesElapsed + " ms");
        }
    }

    private void assignExecutionResources() {
        if (Tracer.extraeEnabled()) {
            this.emitAffinityChangeEvents();
        }
        if (this.resources.getAssignedCPUs() != null && this.resources.getAssignedCPUs().length > 0) {
            try {
                ThreadAffinity.setCurrentThreadAffinity(this.resources.getAssignedCPUs());
            }
            catch (Exception e) {
                LOGGER.warn("Error setting affinity for Job " + this.invocation.getJobId(), (Throwable)e);
            }
        }
    }

    @Override
    public void stalledCodeExecution() {
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Release binded resources for Job " + jobId);
        long timeUnassignResourcesStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeUnassignResourcesStart = System.nanoTime();
        }
        this.platform.blockedRunner(this.invocation, this, this.resources);
        if (IS_TIMER_COMPSS_ENABLED) {
            long timeUnassignResourcesEnd = System.nanoTime();
            float timeUnassignResourcesElapsed = (float)(timeUnassignResourcesEnd - timeUnassignResourcesStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Unassign resources for job " + jobId + ": " + timeUnassignResourcesElapsed + " ms");
        }
    }

    @Override
    public void readyToContinueExecution(Semaphore sem) {
        long timeAssignResourcesStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeAssignResourcesStart = System.nanoTime();
        }
        this.platform.unblockedRunner(this.invocation, this, this.resources, sem);
        this.assignExecutionResources();
        if (IS_TIMER_COMPSS_ENABLED) {
            long timeAssignResourcesEnd = System.nanoTime();
            float timeAssignResourcesElapsed = (float)(timeAssignResourcesEnd - timeAssignResourcesStart) / 1000000.0f;
            int jobId = this.invocation.getJobId();
            TIMER_LOGGER.debug("[TIMER] Re-assign resources for job " + jobId + ": " + timeAssignResourcesElapsed + " ms");
        }
    }

    private void releaseResources(int jobId) {
        LOGGER.debug("Release binded resources for Job " + jobId);
        long timeUnassignResourcesStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeUnassignResourcesStart = System.nanoTime();
        }
        this.platform.releaseResources(jobId);
        if (IS_TIMER_COMPSS_ENABLED) {
            long timeUnassignResourcesEnd = System.nanoTime();
            float timeUnassignResourcesElapsed = (float)(timeUnassignResourcesEnd - timeUnassignResourcesStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Unassign resources for job " + jobId + ": " + timeUnassignResourcesElapsed + " ms");
        }
    }

    private TaskWorkingDir createTaskSandbox() throws IOException {
        TaskWorkingDir taskWD;
        long timeSandboxStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeSandboxStart = System.nanoTime();
        }
        String specificWD = null;
        switch (this.invocation.getMethodImplementation().getMethodType()) {
            case CONTAINER: {
                ContainerDefinition contImpl = (ContainerDefinition)this.invocation.getMethodImplementation().getDefinition();
                specificWD = contImpl.getWorkingDir();
                break;
            }
            case BINARY: {
                BinaryDefinition binaryImpl = (BinaryDefinition)this.invocation.getMethodImplementation().getDefinition();
                specificWD = binaryImpl.getWorkingDir();
                break;
            }
            case MPI: {
                MPIDefinition mpiImpl = (MPIDefinition)this.invocation.getMethodImplementation().getDefinition();
                specificWD = mpiImpl.getWorkingDir();
                break;
            }
            case PYTHON_MPI: {
                PythonMPIDefinition nativeMPIImpl = (PythonMPIDefinition)this.invocation.getMethodImplementation().getDefinition();
                specificWD = nativeMPIImpl.getWorkingDir();
                break;
            }
            case COMPSs: {
                COMPSsDefinition compssImpl = (COMPSsDefinition)this.invocation.getMethodImplementation().getDefinition();
                specificWD = compssImpl.getWorkingDir() + File.separator + compssImpl.getParentAppId() + File.separator + "compss_job_" + this.invocation.getJobId() + "_" + this.invocation.getHistory().name();
                break;
            }
            case DECAF: {
                DecafDefinition decafImpl = (DecafDefinition)this.invocation.getMethodImplementation().getDefinition();
                specificWD = decafImpl.getWorkingDir();
                break;
            }
            case OMPSS: {
                OmpSsDefinition ompssImpl = (OmpSsDefinition)this.invocation.getMethodImplementation().getDefinition();
                specificWD = ompssImpl.getWorkingDir();
                break;
            }
            case OPENCL: {
                OpenCLDefinition openclImpl = (OpenCLDefinition)this.invocation.getMethodImplementation().getDefinition();
                specificWD = openclImpl.getWorkingDir();
                break;
            }
            case METHOD: 
            case MULTI_NODE: {
                specificWD = null;
            }
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.CREATING_TASK_SANDBOX.getId(), TraceEvent.CREATING_TASK_SANDBOX.getType());
        }
        if (specificWD != null && !specificWD.isEmpty() && !specificWD.equals("[unassigned]")) {
            File workingDir = new File(specificWD);
            taskWD = new TaskWorkingDir(workingDir, true);
            Files.createDirectories(workingDir.toPath(), new FileAttribute[0]);
        } else {
            String completePath = this.context.getWorkingDir() + "sandBox" + File.separator + "job_" + this.invocation.getJobId();
            File workingDir = new File(completePath);
            taskWD = new TaskWorkingDir(workingDir, false);
            if (workingDir.exists()) {
                LOGGER.debug("Deleting folder " + workingDir.toString());
                if (!workingDir.delete()) {
                    LOGGER.warn("Cannot delete working dir folder: " + workingDir.toString());
                }
            }
            Files.createDirectories(workingDir.toPath(), new FileAttribute[0]);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.CREATING_TASK_SANDBOX.getType());
        }
        if (IS_TIMER_COMPSS_ENABLED) {
            long timeSandboxEnd = System.nanoTime();
            float timeSandboxElapsed = (float)(timeSandboxEnd - timeSandboxStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Create sandbox for job " + this.invocation.getJobId() + ": " + timeSandboxElapsed + " ms");
        }
        return taskWD;
    }

    private void cleanTaskSandbox(TaskWorkingDir twd, int jobId) {
        File workingDir;
        long timeCleanSandboxStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeCleanSandboxStart = System.nanoTime();
        }
        if (twd != null && !twd.isSpecific() && (workingDir = twd.getWorkingDir()) != null && workingDir.exists() && workingDir.isDirectory()) {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(TraceEvent.REMOVING_TASK_SANDBOX.getId(), TraceEvent.REMOVING_TASK_SANDBOX.getType());
            }
            try {
                LOGGER.debug("Deleting sandbox " + workingDir.toPath());
                Executor.deleteDirectory(workingDir);
            }
            catch (IOException e) {
                LOGGER.warn("Error deleting sandbox " + e.getMessage(), (Throwable)e);
            }
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, TraceEvent.REMOVING_TASK_SANDBOX.getType());
            }
        }
        if (IS_TIMER_COMPSS_ENABLED) {
            long timeCleanSandboxEnd = System.nanoTime();
            float timeCleanSandboxElapsed = (float)(timeCleanSandboxEnd - timeCleanSandboxStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Clean sandbox for job " + jobId + ": " + timeCleanSandboxElapsed + " ms");
        }
    }

    private boolean isMajorVersion(String file1, String file2) {
        String[] version1array = file1.split("_")[0].split("v");
        String[] version2array = file2.split("_")[0].split("v");
        if (version1array.length < 2 || version2array.length < 2) {
            return false;
        }
        Integer version1int = null;
        Integer version2int = null;
        try {
            version1int = Integer.parseInt(version1array[1]);
            version2int = Integer.parseInt(version2array[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return version1int > version2int;
    }

    private void bindOriginalFilenamesToRenames(File sandbox) throws IOException {
        String renamedFilePath;
        long timeBindOriginalFilesStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeBindOriginalFilesStart = System.nanoTime();
        }
        for (InvocationParam invocationParam : this.invocation.getParams()) {
            if (!invocationParam.isKeepRename()) {
                this.bindOriginalFilenameToRenames(invocationParam, sandbox);
                continue;
            }
            renamedFilePath = (String)invocationParam.getValue();
            LOGGER.debug("Parameter keeps rename: " + renamedFilePath);
            invocationParam.setRenamedName(renamedFilePath);
            invocationParam.setOriginalName(renamedFilePath);
        }
        if (this.invocation.getTarget() != null) {
            LOGGER.debug("Invocation has non-null target");
            InvocationParam param = this.invocation.getTarget();
            if (!param.isKeepRename()) {
                this.bindOriginalFilenameToRenames(param, sandbox);
            } else {
                String string = (String)param.getValue();
                LOGGER.debug("Parameter keeps rename: " + string);
                param.setRenamedName(string);
                param.setOriginalName(string);
            }
        }
        for (InvocationParam invocationParam : this.invocation.getResults()) {
            if (!invocationParam.isKeepRename()) {
                this.bindOriginalFilenameToRenames(invocationParam, sandbox);
                continue;
            }
            renamedFilePath = (String)invocationParam.getValue();
            LOGGER.debug("Parameter keeps rename: " + renamedFilePath);
            invocationParam.setRenamedName(renamedFilePath);
            invocationParam.setOriginalName(renamedFilePath);
        }
        if (IS_TIMER_COMPSS_ENABLED) {
            long timeBindOriginalFilesEnd = System.nanoTime();
            float timeBindOriginalFilesElapsed = (float)(timeBindOriginalFilesEnd - timeBindOriginalFilesStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Bind original files for job " + this.invocation.getJobId() + ": " + timeBindOriginalFilesElapsed + " ms");
        }
    }

    private void bindOriginalFilenameToRenames(InvocationParam param, File sandbox) throws IOException {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.BIND_ORIG_NAME.getId(), TraceEvent.BIND_ORIG_NAME.getType());
        }
        if (param.getType().equals((Object)DataType.COLLECTION_T)) {
            InvocationParamCollection cp = (InvocationParamCollection)param;
            for (InvocationParam p : cp.getCollectionParameters()) {
                this.bindOriginalFilenameToRenames(p, sandbox);
            }
        } else if (param.getType().equals((Object)DataType.DICT_COLLECTION_T)) {
            InvocationParamDictCollection dcp = (InvocationParamDictCollection)param;
            for (Map.Entry entry : dcp.getDictCollectionParameters().entrySet()) {
                this.bindOriginalFilenameToRenames((InvocationParam)entry.getKey(), sandbox);
                this.bindOriginalFilenameToRenames((InvocationParam)entry.getValue(), sandbox);
            }
        } else if (param.getType().equals((Object)DataType.FILE_T)) {
            String renamedFilePath = (String)param.getValue();
            File renamedFile = new File(renamedFilePath);
            param.setRenamedName(renamedFilePath);
            if (renamedFile.getName().equals(param.getOriginalName())) {
                param.setOriginalName(renamedFilePath);
            } else {
                String inSandboxPath = sandbox.getAbsolutePath() + File.separator + param.getOriginalName();
                LOGGER.debug("Setting Original Name to " + inSandboxPath);
                LOGGER.debug("Renamed File Path is " + renamedFilePath);
                param.setOriginalName(inSandboxPath);
                param.setValue(inSandboxPath);
                File inSandboxFile = new File(inSandboxPath);
                if (renamedFile.exists()) {
                    LOGGER.debug("File exists");
                    if (!inSandboxFile.exists()) {
                        LOGGER.debug("Creating symlink " + inSandboxFile.toPath() + " pointing to " + renamedFile.toPath());
                        Files.createSymbolicLink(inSandboxFile.toPath(), renamedFile.toPath(), new FileAttribute[0]);
                    } else if (Files.isSymbolicLink(inSandboxFile.toPath())) {
                        Path oldRenamed = Files.readSymbolicLink(inSandboxFile.toPath());
                        LOGGER.debug("Checking if " + renamedFile.getName() + " is equal to " + oldRenamed.getFileName().toString());
                        if (this.isMajorVersion(renamedFile.getName(), oldRenamed.getFileName().toString())) {
                            Files.delete(inSandboxFile.toPath());
                            Files.createSymbolicLink(inSandboxFile.toPath(), renamedFile.toPath(), new FileAttribute[0]);
                        }
                    }
                }
            }
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.BIND_ORIG_NAME.getType());
        }
    }

    private void unbindOriginalFileNamesToRenames(boolean alreadyFailed) throws IOException, JobExecutionException {
        String message = null;
        boolean failure = false;
        for (InvocationParam invocationParam : this.invocation.getParams()) {
            try {
                this.unbindOriginalFilenameToRename(invocationParam);
            }
            catch (JobExecutionException e) {
                message = !failure ? e.getMessage() : message.concat("\n" + e.getMessage());
                failure = true;
            }
        }
        if (this.invocation.getTarget() != null) {
            try {
                this.unbindOriginalFilenameToRename(this.invocation.getTarget());
            }
            catch (JobExecutionException e) {
                message = !failure ? e.getMessage() : message.concat("\n" + e.getMessage());
                failure = true;
            }
        }
        for (InvocationParam invocationParam : this.invocation.getResults()) {
            try {
                this.unbindOriginalFilenameToRename(invocationParam);
            }
            catch (JobExecutionException e) {
                message = !failure ? e.getMessage() : message.concat("\n" + e.getMessage());
                failure = true;
            }
        }
        if (failure && !alreadyFailed) {
            throw new JobExecutionException(message);
        }
    }

    private void unbindOriginalFilenameToRename(InvocationParam param) throws IOException, JobExecutionException {
        if (param.isKeepRename()) {
            return;
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.UNBIND_ORIG_NAME.getId(), TraceEvent.UNBIND_ORIG_NAME.getType());
        }
        if (param.getType().equals((Object)DataType.COLLECTION_T)) {
            InvocationParamCollection cp = (InvocationParamCollection)param;
            for (InvocationParam p : cp.getCollectionParameters()) {
                this.unbindOriginalFilenameToRename(p);
            }
        } else if (param.getType().equals((Object)DataType.DICT_COLLECTION_T)) {
            InvocationParamDictCollection dcp = (InvocationParamDictCollection)param;
            for (Map.Entry entry : dcp.getDictCollectionParameters().entrySet()) {
                this.unbindOriginalFilenameToRename((InvocationParam)entry.getKey());
                this.unbindOriginalFilenameToRename((InvocationParam)entry.getValue());
            }
        } else if (param.getType().equals((Object)DataType.FILE_T)) {
            String inSandboxPath = param.getOriginalName();
            String renamedFilePath = param.getRenamedName();
            LOGGER.debug("Treating file " + inSandboxPath);
            File inSandboxFile = new File(inSandboxPath);
            String originalFileName = inSandboxFile.getName();
            if (!inSandboxPath.equals(renamedFilePath)) {
                File renamedFile = new File(renamedFilePath);
                if (renamedFile.exists()) {
                    if (inSandboxFile.exists()) {
                        if (Files.isSymbolicLink(inSandboxFile.toPath())) {
                            LOGGER.debug("Deleting symlink " + inSandboxFile.toPath());
                            Files.delete(inSandboxFile.toPath());
                        } else {
                            LOGGER.debug("Moving from " + inSandboxFile.toPath() + " to " + renamedFile.toPath());
                            Files.delete(renamedFile.toPath());
                            this.move(inSandboxFile.toPath(), renamedFile.toPath());
                        }
                    } else {
                        LOGGER.debug("Repeated data for " + inSandboxPath + ". Nothing to do");
                    }
                } else if (inSandboxFile.exists()) {
                    if (Files.isSymbolicLink(inSandboxFile.toPath())) {
                        String msg = "ERROR: Unexpected case. A Problem occurred with File " + inSandboxPath + ". Either this file or the original name " + renamedFilePath + " do not exist.";
                        LOGGER.error(msg);
                        System.err.println(msg);
                        param.setValue(renamedFilePath);
                        param.setOriginalName(originalFileName);
                        throw new JobExecutionException(msg);
                    }
                    this.move(inSandboxFile.toPath(), renamedFile.toPath());
                } else {
                    if (this.invocation.getOnFailure() != OnFailure.RETRY) {
                        LOGGER.debug("Generating empty renamed file (" + renamedFilePath + ") for on_failure management");
                        if (!renamedFile.createNewFile()) {
                            // empty if block
                        }
                    }
                    param.setValue(renamedFilePath);
                    param.setOriginalName(originalFileName);
                    String msg = "WARN: Output file " + inSandboxFile.toPath() + " does not exist";
                    throw new JobExecutionException(msg);
                }
            }
            param.setValue(renamedFilePath);
            param.setOriginalName(originalFileName);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.UNBIND_ORIG_NAME.getType());
        }
    }

    private void move(Path origFilePath, Path renamedFilePath) throws IOException {
        LOGGER.debug("Moving " + origFilePath.toString() + " to " + renamedFilePath.toString());
        try {
            Files.move(origFilePath, renamedFilePath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException amnse) {
            LOGGER.warn(WARN_ATOMIC_MOVE);
            Files.move(origFilePath, renamedFilePath, new CopyOption[0]);
        }
    }

    private static void deleteDirectory(File directory) throws IOException {
        Path dPath = directory.toPath();
        Files.walkFileTree(dPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void emitingTaskStartEvents() {
        int numNodes = 1;
        if (this.invocation.getSlaveNodesNames() != null) {
            numNodes = this.invocation.getSlaveNodesNames().size() + 1;
        }
        int nCPUs = ((MethodResourceDescription)this.invocation.getRequirements()).getTotalCPUComputingUnits() * numNodes;
        Tracer.emitEvent(nCPUs, Tracer.getCPUCountEventsType());
        int nGPUs = ((MethodResourceDescription)this.invocation.getRequirements()).getTotalGPUComputingUnits() * numNodes;
        Tracer.emitEvent(nGPUs, Tracer.getGPUCountEventsType());
        int memory = (int)((MethodResourceDescription)this.invocation.getRequirements()).getMemorySize() * numNodes;
        if (memory < 0) {
            memory = 0;
        }
        Tracer.emitEvent(memory, Tracer.getMemoryEventsType());
        int diskBW = ((MethodResourceDescription)this.invocation.getRequirements()).getStorageBW() * numNodes;
        if (diskBW < 0) {
            diskBW = 0;
        }
        Tracer.emitEvent(diskBW, Tracer.getDiskBWEventsType());
        int taskType = this.invocation.getMethodImplementation().getMethodType().ordinal() + 1;
        Tracer.emitEvent(taskType, Tracer.getTaskTypeEventsType());
        Tracer.emitEvent(TraceEvent.TASK_RUNNING.getId(), TraceEvent.TASK_RUNNING.getType());
    }

    private void emitTaskEndEvents() {
        Tracer.emitEvent(0L, Tracer.getCPUCountEventsType());
        Tracer.emitEvent(0L, Tracer.getGPUCountEventsType());
        Tracer.emitEvent(0L, Tracer.getMemoryEventsType());
        Tracer.emitEvent(0L, Tracer.getDiskBWEventsType());
        Tracer.emitEvent(0L, Tracer.getTaskTypeEventsType());
        Tracer.emitEvent(0L, TraceEvent.TASK_RUNNING.getType());
    }

    private void emitAffinityChangeEvents() {
        if (this.resources != null) {
            int[] gpus;
            int[] cpus = this.resources.getAssignedCPUs();
            if (cpus != null && cpus.length > 0) {
                Tracer.emitEvent(0L, Tracer.getTasksCPUAffinityEventsType());
                Tracer.emitEvent((long)cpus[0] + 1L, Tracer.getTasksCPUAffinityEventsType());
            }
            if ((gpus = this.resources.getAssignedGPUs()) != null && gpus.length > 0) {
                Tracer.emitEvent(0L, Tracer.getTasksGPUAffinityEventsType());
                Tracer.emitEvent((long)gpus[0] + 1L, Tracer.getTasksGPUAffinityEventsType());
            }
        }
    }

    private void emitAffinityEndEvents() {
        Tracer.emitEvent(0L, Tracer.getTasksCPUAffinityEventsType());
        Tracer.emitEvent(0L, Tracer.getTasksGPUAffinityEventsType());
    }

    static {
        String isTimerCOMPSsEnabledProperty = System.getProperty("compss.timers");
        IS_TIMER_COMPSS_ENABLED = isTimerCOMPSsEnabledProperty == null || isTimerCOMPSsEnabledProperty.isEmpty() || isTimerCOMPSsEnabledProperty.equals("null") ? false : Boolean.valueOf(isTimerCOMPSsEnabledProperty);
    }

    private class TaskWorkingDir {
        private final File workingDir;
        private final boolean isSpecific;

        public TaskWorkingDir(File workingDir, boolean isSpecific) {
            this.workingDir = workingDir;
            this.isSpecific = isSpecific;
        }

        public File getWorkingDir() {
            return this.workingDir;
        }

        public boolean isSpecific() {
            return this.isSpecific;
        }
    }
}

