/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.cepbatools.extrae.Wrapper;
import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.PythonTraceMerger;
import es.bsc.compss.util.StreamGobbler;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.util.types.PrvHeader;
import es.bsc.compss.util.types.PrvLine;
import es.bsc.compss.util.types.RowFile;
import es.bsc.compss.util.types.ThreadTranslator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Tracer {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.Tracing");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String ERROR_TRACE_DIR = "ERROR: Cannot create trace directory";
    private static final String ERROR_MASTER_PACKAGE_FILEPATH = "Cannot locate master tracing package on working directory";
    private static final String MASTER_TRACE_FILE = "master_compss_trace.tar.gz";
    private static final String RUNTIME = "Runtime";
    protected static final String TRACE_PATH = File.separator + "trace" + File.separator;
    protected static final String TRACE_SCRIPT_PATH = File.separator + "Runtime" + File.separator + "scripts" + File.separator + "system" + TRACE_PATH + "trace.sh";
    protected static final String TRACE_OUT_RELATIVE_PATH = TRACE_PATH + "tracer.out";
    protected static final String TRACE_ERR_RELATIVE_PATH = TRACE_PATH + "tracer.err";
    public static final String TRACE_SUBDIR = "trace";
    public static final String TO_MERGE_SUBDIR = "to_merge";
    public static final String MASTER_TRACE_SUFFIX = "_compss";
    public static final String TRACE_ROW_FILE_EXTENTION = ".row";
    public static final String TRACE_PRV_FILE_EXTENTION = ".prv";
    public static final String TRACE_PCF_FILE_EXTENTION = ".pcf";
    private static final boolean IS_CUSTOM_EXTRAE_FILE = System.getProperty("compss.extrae.file") != null && !System.getProperty("compss.extrae.file").isEmpty() && !System.getProperty("compss.extrae.file").equals("null");
    private static final String EXTRAE_FILE = IS_CUSTOM_EXTRAE_FILE ? System.getProperty("compss.extrae.file") : "null";
    public static final String LD_PRELOAD = "LD_PRELOAD";
    public static final String EXTRAE_CONFIG_FILE = "EXTRAE_CONFIG_FILE";
    public static final String EXTRAE_USE_POSIX_CLOCK = "EXTRAE_USE_POSIX_CLOCK";
    private static final String TASK_DESC = "Task";
    private static final String API_DESC = "API";
    private static final String RUNTIME_DESC = "Runtime";
    private static final String TASKID_DESC = "Task IDs";
    private static final String DATA_TRANSFERS_DESC = "Data Transfers";
    private static final String TASK_TRANSFERS_DESC = "Task Transfers Request";
    private static final String STORAGE_DESC = "Storage API";
    private static final String INSIDE_TASK_DESC = "Events inside tasks";
    private static final String INSIDE_TASK_CPU_AFFINITY_DESC = "Tasks CPU affinity";
    private static final String INSIDE_TASK_GPU_AFFINITY_DESC = "Tasks GPU affinity";
    private static final String AGENT_EVENTS_TYPE_DESC = "Agents events";
    private static final String INSIDE_WORKER_DESC = "Events inside worker";
    private static final String BINDING_MASTER_DESC = "Binding events";
    private static final String BINDING_SERIALIZATION_SIZE_DESC = "Binding serialization size events";
    private static final String BINDING_DESERIALIZATION_SIZE_DESC = "Binding deserialization size events";
    private static final String BINDING_SERIALIZATION_CACHE_SIZE_DESC = "Binding serialization cache size events";
    private static final String BINDING_DESERIALIZATION_CACHE_SIZE_DESC = "Binding deserialization cache size events";
    private static final String BINDING_SERIALIZATION_OBJECT_NUM = "Binding serialization object number";
    private static final String BINDING_DESERIALIZATION_OBJECT_NUM = "Binding deserialization object number";
    private static final String TASKTYPE_DESC = "Type of task";
    private static final String READY_COUNT_DESC = "Ready queue count";
    private static final String CPU_COUNT_DESC = "Number of requested CPUs";
    private static final String GPU_COUNT_DESC = "Number of requested GPUs";
    private static final String MEMORY_DESC = "Requested Memory";
    private static final String DISK_BW_DESC = "Requested disk bandwidth";
    private static final String RUNTIME_THREAD_EVENTS_DESC = "Thread type identifier";
    private static final String EXECUTOR_COUNTS_DESC = "Executor threads count";
    protected static final int TASKS_FUNC_TYPE = 8000000;
    protected static final int API_EVENTS = 8001001;
    protected static final int RUNTIME_EVENTS = 8001002;
    protected static final int THREAD_IDENTIFICATION_EVENTS = 8001003;
    protected static final int EXECUTOR_COUNTS = 8001004;
    protected static final int TASKS_ID_TYPE = 8000002;
    protected static final int TASK_TRANSFERS = 8000003;
    protected static final int DATA_TRANSFERS = 8000004;
    protected static final int STORAGE_TYPE = 8000005;
    protected static final int READY_COUNTS = 8000006;
    protected static final int TASKTYPE_EVENTS = 8000007;
    protected static final int CPU_COUNTS = 8000008;
    protected static final int GPU_COUNTS = 8000009;
    protected static final int MEMORY = 8000010;
    protected static final int DISK_BW = 8000011;
    protected static final int SYNC_TYPE = 8000666;
    protected static final int TASKS_CPU_AFFINITY_TYPE = 8000150;
    protected static final int TASKS_GPU_AFFINITY_TYPE = 8000160;
    protected static final int AGENT_EVENTS_TYPE = 8006000;
    protected static final int INSIDE_TASKS_TYPE = 60000100;
    protected static final int INSIDE_TASKS_CPU_AFFINITY_TYPE = 60000150;
    protected static final int INSIDE_TASKS_GPU_AFFINITY_TYPE = 60000160;
    protected static final int INSIDE_WORKER_TYPE = 60000200;
    protected static final int BINDING_MASTER_TYPE = 60000300;
    protected static final int BINDING_SERIALIZATION_SIZE_TYPE = 60000600;
    protected static final int BINDING_DESERIALIZATION_SIZE_TYPE = 60000601;
    protected static final int BINDING_SERIALIZATION_CACHE_SIZE_TYPE = 60000602;
    protected static final int BINDING_DESERIALIZATION_CACHE_SIZE_TYPE = 60000603;
    protected static final int BINDING_SERIALIZATION_OBJECT_NUM_TYPE = 60000700;
    protected static final int BINDING_DESERIALIZATION_OBJECT_NUM_TYPE = 60000701;
    public static final int EVENT_END = 0;
    public static final int BASIC_MODE = 1;
    public static final int SCOREP_MODE = -1;
    public static final int MAP_MODE = -2;
    protected static int tracingLevel = 0;
    private static String traceDirPath;
    private static Map<String, TraceHost> hostToSlots;
    private static AtomicInteger hostId;
    public static final int AP_ID = 2;
    public static final int TD_ID = 3;
    public static final int FS_ID = 4;
    public static final int TIMER_ID = 5;
    public static final int WALLCLOCK_ID = 6;
    public static final int EXECUTOR_ID = 7;
    public static final String appThread = "1:1:1";
    public static final String APThread = "1:1:2";
    public static final String TDThread = "1:1:3";
    public static final String workerMainEnding = "1:1";
    public static final String LastNumberFSThread = "2";
    public static final String LastNumberTimerId = "4";
    public static final String RUNTIME_ID = "1";
    public static final String NON_RUNTIME_ID = "2";
    public static final Pattern INSIDE_PARENTHESIS_PATTERN;
    public static boolean tracerAlreadyLoaded;
    private static int numPthreadsEnabled;
    private static HashMap<Integer, ArrayList<Integer>> predecessorsMap;

    public static void init(String logDirPath, int level) {
        if (tracerAlreadyLoaded) {
            if (DEBUG) {
                LOGGER.debug("Tracing already initialized " + level + "no need for a second initialization");
            }
            return;
        }
        tracerAlreadyLoaded = true;
        if (DEBUG) {
            LOGGER.debug("Initializing tracing with level " + level);
        }
        hostId = new AtomicInteger(1);
        hostToSlots = new HashMap<String, TraceHost>();
        predecessorsMap = new HashMap();
        if (!logDirPath.endsWith(File.separator)) {
            logDirPath = logDirPath + logDirPath;
        }
        if (!new File(traceDirPath = logDirPath + TRACE_SUBDIR + File.separator).mkdir()) {
            ErrorManager.error(ERROR_TRACE_DIR);
        }
        tracingLevel = level;
        if (Tracer.extraeEnabled()) {
            Tracer.setUpWrapper(0, 1);
        } else if (DEBUG) {
            if (Tracer.scorepEnabled()) {
                LOGGER.debug("Initializing scorep.");
            } else if (Tracer.mapEnabled()) {
                LOGGER.debug("Initializing arm-map.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setUpWrapper(int taskId, int numTasks) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if (DEBUG) {
                LOGGER.debug("Initializing extrae Wrapper.");
            }
            Wrapper.SetTaskID(taskId);
            Wrapper.SetNumTasks(numTasks);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static boolean extraeEnabled() {
        return tracingLevel > 0;
    }

    public static boolean scorepEnabled() {
        return tracingLevel == -1;
    }

    public static boolean mapEnabled() {
        return tracingLevel == -2;
    }

    public static boolean isActivated() {
        return tracingLevel != 0;
    }

    public static boolean basicModeEnabled() {
        return tracingLevel == 1;
    }

    public static int getLevel() {
        return tracingLevel;
    }

    public static String getExtraeFile() {
        return EXTRAE_FILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enablePThreads(int n) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if ((numPthreadsEnabled += n) > 0) {
                Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disablePThreads(int n) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if ((numPthreadsEnabled -= n) < 1) {
                numPthreadsEnabled = 0;
                Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS & ~Wrapper.EXTRAE_PTHREAD_OPTION);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registerHost(String name, int slots) {
        int id;
        if (DEBUG) {
            LOGGER.debug("Tracing: Registering host " + name + " in the tracing system");
        }
        Map<String, TraceHost> map = hostToSlots;
        synchronized (map) {
            if (hostToSlots.containsKey(name)) {
                if (DEBUG) {
                    LOGGER.debug("Host " + name + " already in tracing system, skipping");
                }
                return -1;
            }
            id = hostId.getAndIncrement();
            hostToSlots.put(name, new TraceHost(slots));
        }
        return id;
    }

    public static int getNextSlot(String host) {
        int slot = Tracer.hostToSlots.get(host).getNextSlot();
        if (DEBUG) {
            LOGGER.debug("Tracing: Getting slot " + slot + " of host " + host);
        }
        return slot;
    }

    public static void freeSlot(String host, int slot) {
        if (DEBUG) {
            LOGGER.debug("Tracing: Freeing slot " + slot + " of host " + host);
        }
        Tracer.hostToSlots.get(host).freeSlot(slot);
    }

    public static int getRuntimeEventsType() {
        return 8001002;
    }

    public static int getSyncType() {
        return 8000666;
    }

    public static int getTaskTransfersType() {
        return 8000003;
    }

    public static int getDataTransfersType() {
        return 8000004;
    }

    public static int getTaskEventsType() {
        return 8000000;
    }

    public static int getTaskSchedulingType() {
        return 8000002;
    }

    public static int getInsideTasksEventsType() {
        return 60000100;
    }

    public static int getTasksCPUAffinityEventsType() {
        return 8000150;
    }

    public static int getTasksGPUAffinityEventsType() {
        return 8000160;
    }

    public static int getInsideTasksCPUAffinityEventsType() {
        return 60000150;
    }

    public static int getInsideTasksGPUAffinityEventsType() {
        return 60000160;
    }

    public static int getInsideWorkerEventsType() {
        return 60000200;
    }

    public static int getBindingMasterEventsType() {
        return 60000300;
    }

    public static int getTaskTypeEventsType() {
        return 8000007;
    }

    public static int getCPUCountEventsType() {
        return 8000008;
    }

    public static int getGPUCountEventsType() {
        return 8000009;
    }

    public static int getReadyCountEventsType() {
        return 8000006;
    }

    public static int getMemoryEventsType() {
        return 8000010;
    }

    public static int getDiskBWEventsType() {
        return 8000011;
    }

    public static TraceEvent getAcessProcessorRequestEvent(String eventType) {
        return TraceEvent.valueOf(eventType);
    }

    public static ArrayList<Integer> getPredecessors(int taskId) {
        return predecessorsMap.get(taskId);
    }

    public static void removePredecessor(int taskId) {
        predecessorsMap.remove(taskId);
    }

    public static void addPredecessors(int taskId, int predecessorTaskId) {
        ArrayList<Integer> predecessors = predecessorsMap.get(taskId);
        if (predecessors == null) {
            predecessors = new ArrayList();
        }
        predecessors.add(predecessorTaskId);
        predecessorsMap.put(taskId, predecessors);
    }

    public static TraceEvent getTaskDispatcherRequestEvent(String eventType) {
        TraceEvent event = null;
        try {
            event = TraceEvent.valueOf(eventType);
        }
        catch (Exception e) {
            LOGGER.error("Task Dispatcher event " + eventType + " is not present in Tracer's list ");
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitEvent(long eventID, int eventType) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Event(eventType, eventID);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Emitting synchronized event [type, id] = [" + eventType + " , " + eventID + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitEventAndCounters(int taskId, int eventType) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Eventandcounters(eventType, taskId);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Emitting synchronized event with HW counters [type, taskId] = [" + eventType + " , " + taskId + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitCommEvent(boolean send, int ownID, int partnerID, int tag, long size) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Comm(send, tag, (int)size, partnerID, ownID);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Emitting communication event [" + (send ? "SEND" : "REC") + "] " + tag + ", " + size + ", " + partnerID + ", " + ownID + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fini(Map<String, Integer> runtimeEvents) {
        if (DEBUG) {
            LOGGER.debug("Tracing: finalizing");
        }
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if (Tracer.extraeEnabled()) {
                Tracer.defineEvents(runtimeEvents);
                Tracer.stopWrapper();
                Tracer.generateMasterPackage("package");
                Tracer.transferMasterPackage();
                Tracer.generateTrace("gentrace");
                if (Tracer.basicModeEnabled()) {
                    Tracer.updateThreads();
                }
                Tracer.cleanMasterPackage();
            } else if (Tracer.scorepEnabled()) {
                Tracer.generateTrace("gentrace-scorep");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void updateThreads() {
        File[] prvFileArray;
        File[] rowFileArray;
        String disable = System.getProperty("compss.tracing.disableCustomThreads");
        if (disable != null) {
            LOGGER.debug("Custom thread translation disabled");
            return;
        }
        LOGGER.debug("Tracing: Updating thread labels");
        try {
            String appLogDir = System.getProperty("compss.appLogDir");
            File dir = new File(appLogDir + TRACE_SUBDIR);
            String traceNamePrefix = Tracer.getTraceNamePrefix();
            rowFileArray = dir.listFiles((d, name) -> name.endsWith(TRACE_ROW_FILE_EXTENTION));
            prvFileArray = dir.listFiles((d, name) -> name.endsWith(TRACE_PRV_FILE_EXTENTION));
        }
        catch (Exception e) {
            ErrorManager.error(ERROR_MASTER_PACKAGE_FILEPATH, e);
            return;
        }
        try {
            if (rowFileArray != null && rowFileArray.length > 0) {
                File rowFile = rowFileArray[0];
                File prvFile = prvFileArray[0];
                ThreadTranslator thTranslator = Tracer.createThreadTranslations(prvFile);
                Tracer.writeTranslatedPrvThreads(prvFile, thTranslator);
                Tracer.updateRowLabels(rowFile, thTranslator.getRowLabels());
            }
        }
        catch (Exception e) {
            LOGGER.debug(e);
            LOGGER.debug(e.toString());
            ErrorManager.error("Could not update thread labels " + traceDirPath, e);
            e.printStackTrace();
        }
    }

    public static ThreadTranslator createThreadTranslations(File prvFile) throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(prvFile));
        String threadIdEvent = Integer.toString(8001003);
        ThreadTranslator thTranslator = new ThreadTranslator();
        br.readLine();
        while ((line = br.readLine()) != null && !line.isEmpty()) {
            PrvLine prvLine = new PrvLine(line);
            String oldThreadId = prvLine.getStateLineThreadIdentifier();
            Map<String, String> events = prvLine.getEvents();
            String identifierEventValue = events.get(threadIdEvent);
            thTranslator.addThread(oldThreadId, identifierEventValue);
        }
        br.close();
        return thTranslator;
    }

    public static void writeTranslatedPrvThreads(File prvFile, ThreadTranslator thThranslator) throws Exception {
        String line;
        Map<String, String> translations = thThranslator.createThreadTranslationMap();
        LOGGER.debug("Tracing: Updating thread identifiers in .prv file");
        String oldFilePath = prvFile.getAbsolutePath();
        String newFilePath = oldFilePath + "_tmp_updatedThreadsId";
        File updatedPrvFile = new File(newFilePath);
        if (!updatedPrvFile.exists()) {
            updatedPrvFile.createNewFile();
        }
        BufferedReader br = new BufferedReader(new FileReader(prvFile));
        PrintWriter prvWriter = new PrintWriter(new FileWriter(updatedPrvFile.getAbsolutePath(), true));
        PrvHeader header = new PrvHeader(br.readLine());
        header.transformNodesToAplications();
        header.splitRuntimeExecutors(thThranslator.createRuntimeThreadNumberPerApp());
        prvWriter.println(header.toString());
        while ((line = br.readLine()) != null && !line.isEmpty()) {
            PrvLine prvLine = new PrvLine(line);
            prvLine.translateLineThreads(translations);
            prvWriter.println(prvLine.toString());
        }
        br.close();
        prvWriter.close();
        updatedPrvFile.renameTo(new File(oldFilePath));
    }

    public static void updateRowLabels(File rf, List<String> labels) throws IOException {
        RowFile rowFile = new RowFile(rf);
        rowFile.updateRowLabels(labels);
        rowFile.printInfo(rf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void stopWrapper() {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            LOGGER.debug("[Tracer] Disabling pthreads");
            Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS & ~Wrapper.EXTRAE_PTHREAD_OPTION);
            Wrapper.Fini();
            if (DEBUG) {
                LOGGER.debug("[Tracer] Finishing extrae");
            }
            Wrapper.SetOptions(Wrapper.EXTRAE_DISABLE_ALL_OPTIONS);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static List<TraceEvent> getEventsByType(int eventsType) {
        LinkedList<TraceEvent> eventsList = new LinkedList<TraceEvent>();
        for (TraceEvent traceEvent : TraceEvent.values()) {
            if (traceEvent.getType() != eventsType) continue;
            eventsList.add(traceEvent);
        }
        return eventsList;
    }

    private static void defineEvents(Map<String, Integer> runtimeEvents) {
        if (DEBUG) {
            LOGGER.debug("SignatureToId size: " + runtimeEvents.size());
        }
        Tracer.defineEventsForType(8001001, API_DESC);
        Tracer.defineEventsForType(8001002, "Runtime");
        Tracer.defineEventsForFunctions(8000000, TASK_DESC, runtimeEvents);
        Tracer.defineEventsForType(8000003, TASK_TRANSFERS_DESC);
        Tracer.defineEventsForType(8000005, STORAGE_DESC);
        Tracer.defineEventsForType(60000100, INSIDE_TASK_DESC);
        Tracer.defineEventsForType(8006000, AGENT_EVENTS_TYPE_DESC);
        Tracer.defineEventsForType(60000150, INSIDE_TASK_CPU_AFFINITY_DESC);
        Tracer.defineEventsForType(60000160, INSIDE_TASK_GPU_AFFINITY_DESC);
        Tracer.defineEventsForType(60000200, INSIDE_WORKER_DESC);
        Tracer.defineEventsForType(60000300, BINDING_MASTER_DESC);
        Tracer.defineEventsForType(8001003, RUNTIME_THREAD_EVENTS_DESC);
        Tracer.defineEventsForType(8001004, EXECUTOR_COUNTS_DESC);
        Tracer.defineEventsForType(60000600, BINDING_SERIALIZATION_SIZE_DESC);
        Tracer.defineEventsForType(60000601, BINDING_DESERIALIZATION_SIZE_DESC);
        Tracer.defineEventsForType(60000602, BINDING_SERIALIZATION_CACHE_SIZE_DESC);
        Tracer.defineEventsForType(60000603, BINDING_DESERIALIZATION_CACHE_SIZE_DESC);
        Tracer.defineEventsForType(60000700, BINDING_SERIALIZATION_OBJECT_NUM);
        Tracer.defineEventsForType(60000701, BINDING_DESERIALIZATION_OBJECT_NUM);
        Tracer.defineEventsForTaskType(8000007, TASKTYPE_DESC, MethodType.values());
        Wrapper.defineEventType(8000002, TASKID_DESC, new long[0], new String[0]);
        Wrapper.defineEventType(8000004, DATA_TRANSFERS_DESC, new long[0], new String[0]);
        Tracer.defineEventsForType(8000006, READY_COUNT_DESC);
        Wrapper.defineEventType(8000008, CPU_COUNT_DESC, new long[0], new String[0]);
        Wrapper.defineEventType(8000009, GPU_COUNT_DESC, new long[0], new String[0]);
        Wrapper.defineEventType(8000010, MEMORY_DESC, new long[0], new String[0]);
        Wrapper.defineEventType(8000011, DISK_BW_DESC, new long[0], new String[0]);
    }

    private static void defineEventsForTaskType(int tasktypeEvents, String tasktypeDesc, MethodType[] types) {
        int size = types.length + 1;
        long[] values = new long[size];
        String[] descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        int i = 1;
        for (MethodType tp : types) {
            values[i] = (long)tp.ordinal() + 1L;
            descriptionValues[i] = tp.name();
            ++i;
        }
        Wrapper.defineEventType(tasktypeEvents, tasktypeDesc, values, descriptionValues);
    }

    private static void defineEventsForFunctions(int tasksFuncType, String taskDesc, Map<String, Integer> runtimeEvents) {
        int size = runtimeEvents.entrySet().size() + 1;
        long[] values = new long[size];
        String[] descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        int i = 1;
        for (Map.Entry<String, Integer> entry : runtimeEvents.entrySet()) {
            String signature = entry.getKey();
            Integer methodId = entry.getValue();
            values[i] = (long)methodId.intValue() + 1L;
            LOGGER.debug("Tracing debug: " + signature);
            String methodName = signature.substring(signature.indexOf(46) + 1, signature.length());
            String mN = methodName.replace("(", "([").replace(")", "])");
            if (mN.contains(".")) {
                int start = mN.lastIndexOf(".");
                mN = "[" + mN.substring(0, start) + ".]" + mN.substring(start + 1);
            }
            descriptionValues[i] = mN;
            if (DEBUG) {
                LOGGER.debug("Tracing Funtion Event [i,methodId]: [" + i + "," + methodId + "] => value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(tasksFuncType, taskDesc, values, descriptionValues);
    }

    private static void defineEventsForType(int eventsType, String eventsDesc) {
        List<TraceEvent> events = Tracer.getEventsByType(eventsType);
        int size = events.size() + 1;
        long[] values = new long[size];
        String[] descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        int i = 1;
        for (TraceEvent event : events) {
            values[i] = event.getId();
            descriptionValues[i] = event.getSignature();
            if (DEBUG) {
                LOGGER.debug("Tracing[API]: Type " + eventsType + " Event " + i + "=> value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(eventsType, eventsDesc, values, descriptionValues);
    }

    private static void generateMasterPackage(String mode) {
        Process p;
        if (DEBUG) {
            LOGGER.debug("Tracing: generating master package: " + mode);
        }
        String script = System.getenv("COMPSS_HOME") + TRACE_SCRIPT_PATH;
        ProcessBuilder pb = new ProcessBuilder(script, mode, ".", "master");
        pb.environment().remove(LD_PRELOAD);
        try {
            p = pb.start();
        }
        catch (IOException e) {
            ErrorManager.warn("Error generating master package", e);
            return;
        }
        if (DEBUG) {
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out, LOGGER);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err, LOGGER);
            outputGobbler.start();
            errorGobbler.start();
        }
        try {
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                ErrorManager.warn("Error generating master package, exit code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            ErrorManager.warn("Error generating master package (interruptedException)", e);
            Thread.currentThread().interrupt();
        }
    }

    private static void transferMasterPackage() {
        if (DEBUG) {
            LOGGER.debug("Tracing: Transferring master package");
        }
        String filename = ProtocolType.FILE_URI.getSchema() + MASTER_TRACE_FILE;
        String filePath = "";
        try {
            SimpleURI uri = new SimpleURI(filename);
            filePath = new File(uri.getPath()).getCanonicalPath();
        }
        catch (Exception e) {
            ErrorManager.error(ERROR_MASTER_PACKAGE_FILEPATH, e);
            return;
        }
        try {
            Path source = Paths.get(filePath, new String[0]);
            Path target = Paths.get(traceDirPath + MASTER_TRACE_FILE, new String[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ioe) {
            ErrorManager.error("Could not copy the master trace package into " + traceDirPath, ioe);
        }
    }

    private static void generateTrace(String mode) {
        Process p;
        if (DEBUG) {
            LOGGER.debug("Tracing: Generating trace with mode " + mode);
        }
        String script = System.getenv("COMPSS_HOME") + TRACE_SCRIPT_PATH;
        String traceName = "";
        String appName = System.getProperty("compss.appName");
        String label = System.getProperty("compss.trace.label");
        if (appName != null && !appName.isEmpty() && !appName.equals("None")) {
            traceName = label != null && !label.isEmpty() && !label.equals("None") ? appName.concat("_" + label) : appName;
        } else if (label != null && !label.isEmpty() && !label.equals("None")) {
            traceName = label;
        }
        ProcessBuilder pb = new ProcessBuilder(script, mode, System.getProperty("compss.appLogDir"), traceName, String.valueOf(hostToSlots.size() + 1));
        pb.environment().remove(LD_PRELOAD);
        try {
            p = pb.start();
        }
        catch (IOException e) {
            ErrorManager.warn("Error generating trace", e);
            return;
        }
        StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out, LOGGER);
        StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err, LOGGER);
        outputGobbler.start();
        errorGobbler.start();
        int exitCode = 0;
        try {
            exitCode = p.waitFor();
            if (exitCode != 0) {
                ErrorManager.warn("Error generating trace, exit code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            ErrorManager.warn("Error generating trace (interruptedException)", e);
            Thread.currentThread().interrupt();
        }
        String lang = System.getProperty("compss.lang");
        if (exitCode == 0 && lang.equalsIgnoreCase(COMPSsConstants.Lang.PYTHON.name()) && Tracer.extraeEnabled()) {
            try {
                String appLogDir = System.getProperty("compss.appLogDir");
                PythonTraceMerger t = new PythonTraceMerger(appLogDir);
                t.merge();
            }
            catch (Exception e) {
                ErrorManager.warn("Error while trying to merge files", e);
            }
        }
    }

    public static String getTraceNamePrefix() {
        String traceName = System.getProperty("compss.appName");
        String label = System.getProperty("compss.trace.label");
        if (label != null && !label.isEmpty() && !label.equals("None")) {
            traceName = traceName.concat("_" + label);
        }
        return traceName + MASTER_TRACE_SUFFIX;
    }

    private static void cleanMasterPackage() {
        String filename = ProtocolType.FILE_URI.getSchema() + MASTER_TRACE_FILE;
        String filePath = "";
        try {
            SimpleURI uri = new SimpleURI(filename);
            filePath = new File(uri.getPath()).getCanonicalPath();
        }
        catch (Exception e) {
            ErrorManager.error(ERROR_MASTER_PACKAGE_FILEPATH, e);
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Tracing: Removing tracing master package: " + filePath);
        }
        try {
            File f = new File(filePath);
            boolean deleted = f.delete();
            if (!deleted) {
                ErrorManager.warn("Unable to remove tracing temporary files of master node.");
            } else if (DEBUG) {
                LOGGER.debug("Deleted master tracing package.");
            }
        }
        catch (Exception e) {
            ErrorManager.warn("Exception while trying to remove tracing temporary files of master node.", e);
        }
    }

    static {
        INSIDE_PARENTHESIS_PATTERN = Pattern.compile("\\(.+\\)");
        tracerAlreadyLoaded = false;
        numPthreadsEnabled = 0;
    }

    private static class TraceHost {
        private boolean[] slots;
        private int numFreeSlots;
        private int nextSlot;

        private TraceHost(int nslots) {
            this.slots = new boolean[nslots];
            this.numFreeSlots = nslots;
            this.nextSlot = 0;
        }

        private int getNextSlot() {
            if (this.numFreeSlots-- > 0) {
                while (this.slots[this.nextSlot]) {
                    this.nextSlot = (this.nextSlot + 1) % this.slots.length;
                }
                this.slots[this.nextSlot] = true;
                return this.nextSlot;
            }
            return -1;
        }

        private void freeSlot(int slot) {
            this.slots[slot] = false;
            this.nextSlot = slot;
            ++this.numFreeSlots;
        }
    }
}

