/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class MPIDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 6;
    public static final String SIGNATURE = "mpi.MPI";
    private String mpiRunner;
    private String mpiFlags;
    private String binary;
    private String workingDir;
    private boolean scaleByCU;
    private boolean failByEV;

    public MPIDefinition() {
    }

    public MPIDefinition(String binary, String workingDir, String mpiRunner, String mpiFlags, boolean scaleByCU, boolean failByEV) {
        this.mpiRunner = mpiRunner;
        this.mpiFlags = mpiFlags;
        this.workingDir = workingDir;
        this.binary = binary;
        this.scaleByCU = scaleByCU;
        this.failByEV = failByEV;
    }

    public MPIDefinition(String[] implTypeArgs, int offset) {
        this.binary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.workingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        this.mpiRunner = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]);
        this.mpiFlags = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 3]);
        this.scaleByCU = Boolean.parseBoolean(implTypeArgs[offset + 4]);
        this.failByEV = Boolean.parseBoolean(implTypeArgs[offset + 5]);
        if (this.mpiRunner == null || this.mpiRunner.isEmpty()) {
            throw new IllegalArgumentException("Empty mpiRunner annotation for MPI method ");
        }
        if (this.binary == null || this.binary.isEmpty()) {
            throw new IllegalArgumentException("Empty binary annotation for MPI method ");
        }
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        lArgs.add(this.binary);
        lArgs.add(this.workingDir);
        lArgs.add(this.mpiRunner);
        lArgs.add(this.mpiFlags);
        lArgs.add(Boolean.toString(this.scaleByCU));
        lArgs.add(Boolean.toString(this.failByEV));
    }

    public String getBinary() {
        return this.binary;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getMpiRunner() {
        return this.mpiRunner;
    }

    public String getMpiFlags() {
        return this.mpiFlags;
    }

    public boolean getScaleByCU() {
        return this.scaleByCU;
    }

    public boolean isFailByEV() {
        return this.failByEV;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.MPI;
    }

    @Override
    public String toMethodDefinitionFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("[MPI RUNNER=").append(this.mpiRunner);
        sb.append(", MPI_FLAGS=").append(this.mpiFlags);
        sb.append(", BINARY=").append(this.binary);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return "MPI Method with binary " + this.binary + " and MPIrunner " + this.mpiRunner;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mpiRunner = (String)in.readObject();
        this.mpiFlags = (String)in.readObject();
        this.binary = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.scaleByCU = in.readBoolean();
        this.failByEV = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.mpiRunner);
        out.writeObject(this.mpiFlags);
        out.writeObject(this.binary);
        out.writeObject(this.workingDir);
        out.writeBoolean(this.scaleByCU);
        out.writeBoolean(this.failByEV);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MPI Implementation \n");
        sb.append("\t Binary: ").append(this.binary).append("\n");
        sb.append("\t MPI runner: ").append(this.mpiRunner).append("\n");
        sb.append("\t MPI flags: ").append(this.mpiFlags).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        sb.append("\t Scale by Computing Units: ").append(this.scaleByCU).append("\n");
        sb.append("\t Fail by EV: ").append(this.failByEV).append("\n");
        return sb.toString();
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }
}

