/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.listeners;

import es.bsc.compss.data.MultiOperationFetchListener;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.worker.NIOWorker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskFetchOperationsListener
extends MultiOperationFetchListener {
    private static final Logger TIMER_LOGGER = LogManager.getLogger("es.bsc.compss.Timers");
    private final NIOTask task;
    private final NIOWorker nw;

    public TaskFetchOperationsListener(NIOTask task, NIOWorker nw) {
        this.task = task;
        this.nw = nw;
    }

    public NIOTask getTask() {
        return this.task;
    }

    @Override
    public void doCompleted() {
        if (NIOWorker.IS_TIMER_COMPSS_ENABLED) {
            long transferStartTime = this.nw.getTransferStartTime(this.task.getJobId());
            long transferEndTime = System.nanoTime();
            float transferElapsedTime = (float)(transferEndTime - transferStartTime) / 1000000.0f;
            TIMER_LOGGER.info("[TIMER] Transfers for task " + this.task.getJobId() + ": " + transferElapsedTime + " ms");
        }
        this.nw.executeTask(this.task);
    }

    @Override
    public void doFailure(String failedDataId, Exception cause) {
        String baseJobPath = this.nw.getStandardStreamsPath(this.task);
        String errorMessage = "Job failed because the data " + failedDataId + " couldn't be retrieved. Check worker logs for more information about the error.";
        String taskFileOutName = baseJobPath + ".out";
        this.nw.checkStreamFileExistence(taskFileOutName, "out", errorMessage, cause);
        String taskFileErrName = baseJobPath + ".err";
        this.nw.checkStreamFileExistence(taskFileErrName, "err", errorMessage, cause);
        this.nw.sendTaskDone(this.task, false, cause);
    }
}

