/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.components;

import es.bsc.compss.data.BindingDataManager;
import es.bsc.compss.data.DataManager;
import es.bsc.compss.data.DataProvider;
import es.bsc.compss.data.FetchDataListener;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOParamCollection;
import es.bsc.compss.nio.NIOParamDictCollection;
import es.bsc.compss.nio.exceptions.NoSourcesException;
import es.bsc.compss.nio.listeners.CollectionFetchOperationsListener;
import es.bsc.compss.nio.listeners.DictCollectionFetchOperationsListener;
import es.bsc.compss.nio.worker.components.DataRegister;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamURI;
import es.bsc.compss.types.execution.exceptions.InitializationException;
import es.bsc.compss.types.execution.exceptions.UnloadableValueException;
import es.bsc.compss.util.FileOpsManager;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.exceptions.DistroStreamClientInitException;
import es.bsc.distrostreamlib.requests.StopRequest;
import es.bsc.distrostreamlib.server.types.StreamBackend;
import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;

public class DataManagerImpl
implements DataManager {
    private static final Logger WORKER_LOGGER = LogManager.getLogger("es.bsc.compss.Worker");
    private static final boolean WORKER_LOGGER_DEBUG = WORKER_LOGGER.isDebugEnabled();
    private static final StreamBackend STREAMING_BACKEND;
    private static final String STORAGE_CONF;
    private final String hostName;
    private final String masterName;
    private final int streamingPort;
    private final DataProvider provider;
    private final String baseFolder;
    private final HashMap<String, DataRegister> registry;

    public DataManagerImpl(String hostName, String masterName, int streamingPort, String baseFolder, DataProvider provider) {
        this.hostName = hostName;
        this.masterName = masterName;
        this.streamingPort = streamingPort;
        this.baseFolder = baseFolder;
        this.provider = provider;
        this.registry = new HashMap();
    }

    @Override
    public void init() throws InitializationException {
        if (STREAMING_BACKEND.equals((Object)StreamBackend.NONE)) {
            WORKER_LOGGER.warn("No streaming backend passed");
        } else {
            if (WORKER_LOGGER_DEBUG) {
                WORKER_LOGGER.debug("Initializing Streaming Client for " + this.masterName + ":" + this.streamingPort);
            }
            try {
                DistroStreamClient.initAndStart(this.masterName, this.streamingPort);
            }
            catch (DistroStreamClientInitException dscie) {
                throw new InitializationException("Error initializing DS Client", dscie);
            }
        }
        if (STORAGE_CONF == null) {
            WORKER_LOGGER.warn("No storage configuration file passed");
        } else {
            WORKER_LOGGER.debug("Initializing Storage with: " + STORAGE_CONF);
            try {
                StorageItf.init(STORAGE_CONF);
            }
            catch (StorageException se) {
                throw new InitializationException("Error loading storage configuration file: " + STORAGE_CONF, se);
            }
        }
    }

    @Override
    public String getStorageConf() {
        return STORAGE_CONF;
    }

    @Override
    public StreamBackend getStreamingBackend() {
        return STREAMING_BACKEND;
    }

    @Override
    public String getStreamingMasterName() {
        return this.masterName;
    }

    @Override
    public int getStreamingMasterPort() {
        return this.streamingPort;
    }

    @Override
    public void stop() {
        if (!STREAMING_BACKEND.equals((Object)StreamBackend.NONE)) {
            WORKER_LOGGER.debug("Stopping Streaming Client...");
            StopRequest stopRequest = new StopRequest();
            DistroStreamClient.request(stopRequest);
            stopRequest.waitProcessed();
            int errorCode = stopRequest.getErrorCode();
            if (errorCode != 0) {
                WORKER_LOGGER.error("Error stopping Streaming Client");
                WORKER_LOGGER.error("Error Code: " + errorCode);
                WORKER_LOGGER.error("Error Message: " + stopRequest.getErrorMessage());
            }
        }
        if (STORAGE_CONF != null) {
            WORKER_LOGGER.debug("Stopping Storage...");
            try {
                StorageItf.finish();
            }
            catch (StorageException e) {
                WORKER_LOGGER.error("Error releasing storage library: " + e.getMessage(), (Throwable)e);
            }
        }
        FileOpsManager.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObsoletes(List<String> obsoletes) {
        try {
            for (String name : obsoletes) {
                if (WORKER_LOGGER_DEBUG) {
                    WORKER_LOGGER.debug("Removing obsolete " + name);
                }
                File f = new File(name);
                String dataName = f.getName();
                DataRegister register = null;
                Object object = this.registry;
                synchronized (object) {
                    register = this.registry.remove(dataName);
                }
                if (register != null) {
                    object = register;
                    synchronized (object) {
                        register.clear();
                    }
                }
                if (!WORKER_LOGGER_DEBUG) continue;
                WORKER_LOGGER.debug(name + " removed from cache.");
            }
        }
        catch (Exception e) {
            WORKER_LOGGER.error("Exception", (Throwable)e);
        }
        WORKER_LOGGER.debug("Remove obsoletes finished");
    }

    @Override
    public void fetchParam(InvocationParam param, int paramIdx, FetchDataListener tt) {
        switch (param.getType()) {
            case COLLECTION_T: {
                this.fetchCollection(param, paramIdx, tt);
                break;
            }
            case DICT_COLLECTION_T: {
                this.fetchDictCollection(param, paramIdx, tt);
                break;
            }
            case OBJECT_T: 
            case STREAM_T: {
                this.fetchObject(param, paramIdx, tt);
                break;
            }
            case PSCO_T: {
                this.fetchPSCO(param, paramIdx, tt);
                break;
            }
            case BINDING_OBJECT_T: {
                this.fetchBindingObject(param, paramIdx, tt);
                break;
            }
            case DIRECTORY_T: 
            case FILE_T: 
            case EXTERNAL_STREAM_T: {
                this.fetchFile(param, paramIdx, tt);
                break;
            }
            case EXTERNAL_PSCO_T: {
                tt.fetchedValue(param.getDataMgmtId());
                break;
            }
            default: {
                tt.fetchedValue(param.getDataMgmtId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataRegister getOriginalDataRegister(InvocationParam param) {
        DataRegister originalRegister;
        String originalRename = param.getSourceDataId();
        HashMap<String, DataRegister> hashMap = this.registry;
        synchronized (hashMap) {
            originalRegister = this.registry.get(originalRename);
            if (originalRegister == null) {
                originalRegister = new DataRegister();
                this.registry.put(originalRename, originalRegister);
            }
        }
        WORKER_LOGGER.debug("Checking locations for " + originalRename);
        for (InvocationParamURI invocationParamURI : param.getSources()) {
            switch (invocationParamURI.getProtocol()) {
                case DIR_URI: 
                case FILE_URI: {
                    if (!invocationParamURI.isHost(this.hostName)) break;
                    DataRegister dataRegister = originalRegister;
                    synchronized (dataRegister) {
                        originalRegister.addFileLocation(invocationParamURI.getPath());
                        break;
                    }
                }
                case PERSISTENT_URI: {
                    String pscoId = invocationParamURI.getPath();
                    DataRegister dataRegister = originalRegister;
                    synchronized (dataRegister) {
                        originalRegister.setStorageId(pscoId);
                        break;
                    }
                }
                case OBJECT_URI: 
                case BINDING_URI: {
                    if (!invocationParamURI.isHost(this.hostName)) break;
                    WORKER_LOGGER.error("WORKER IS NOT AWARE OF THE PRESENCE OF A" + (invocationParamURI.getProtocol() == ProtocolType.OBJECT_URI ? "N OBJECT " : " BINDING OBJECT "));
                    break;
                }
                case SHARED_URI: {
                    break;
                }
            }
        }
        return originalRegister;
    }

    private void fetchCollection(InvocationParam param, int index, FetchDataListener listener) {
        try {
            NIOParamCollection npc = (NIOParamCollection)param;
            List<NIOParam> elements = npc.getCollectionParameters();
            WORKER_LOGGER.info("Checking NIOParamCollection (received " + elements.size() + " params)");
            int subIndex = 0;
            CollectionFetchOperationsListener cfol = new CollectionFetchOperationsListener(param.getDataMgmtId(), listener);
            for (NIOParam subNioParam : npc.getCollectionParameters()) {
                cfol.addOperation();
                this.fetchParam(subNioParam, subIndex, cfol);
                ++subIndex;
            }
            cfol.enable();
        }
        catch (Exception e) {
            listener.errorFetchingValue(param.getDataMgmtId(), e);
        }
    }

    private void fetchDictCollection(InvocationParam param, int index, FetchDataListener listener) {
        try {
            NIOParamDictCollection npdc = (NIOParamDictCollection)param;
            Map<NIOParam, NIOParam> elements = npdc.getDictCollectionParameters();
            WORKER_LOGGER.info("Checking NIOParamDictCollection (received " + elements.size() + " entries)");
            int subIndex = 0;
            DictCollectionFetchOperationsListener dcfol = new DictCollectionFetchOperationsListener(param.getDataMgmtId(), listener);
            for (Map.Entry<NIOParam, NIOParam> subNioEntry : npdc.getDictCollectionParameters().entrySet()) {
                dcfol.addOperation();
                WORKER_LOGGER.info("Fetching key: " + subNioEntry.getKey());
                this.fetchParam(subNioEntry.getKey(), subIndex, dcfol);
                dcfol.addOperation();
                WORKER_LOGGER.info("Fetching value: " + subNioEntry.getValue());
                this.fetchParam(subNioEntry.getValue(), subIndex, dcfol);
                ++subIndex;
            }
            dcfol.enable();
        }
        catch (Exception e) {
            listener.errorFetchingValue(param.getDataMgmtId(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchObject(InvocationParam param, int index, FetchDataListener listener) {
        String finalRename = param.getDataMgmtId();
        String originalRename = param.getSourceDataId();
        WORKER_LOGGER.debug("   - " + finalRename + " registered as object.");
        DataRegister originalRegister = this.getOriginalDataRegister(param);
        WORKER_LOGGER.debug("   - Checking if " + finalRename + " is in cache.");
        if (originalRegister.isLocal()) {
            if (finalRename.equals(originalRename)) {
                try {
                    DataRegister dataRegister = originalRegister;
                    synchronized (dataRegister) {
                        originalRegister.loadValue();
                    }
                }
                catch (Exception e) {
                    WORKER_LOGGER.error(e);
                    listener.errorFetchingValue(param.getDataMgmtId(), e);
                }
            } else {
                try {
                    Object o;
                    DataRegister dataRegister;
                    if (param.isPreserveSourceData()) {
                        dataRegister = originalRegister;
                        synchronized (dataRegister) {
                            o = originalRegister.cloneValue();
                        }
                    }
                    dataRegister = originalRegister;
                    synchronized (dataRegister) {
                        o = originalRegister.loadValue();
                        originalRegister.removeValue();
                    }
                    DataRegister dr = new DataRegister();
                    dr.setValue(o);
                    HashMap<String, DataRegister> hashMap = this.registry;
                    synchronized (hashMap) {
                        this.registry.put(finalRename, dr);
                    }
                }
                catch (Exception e) {
                    WORKER_LOGGER.error(e);
                    listener.errorFetchingValue(param.getDataMgmtId(), e);
                }
            }
            this.fetchedLocalParameter(param, index, listener);
        } else {
            this.transferParameter(param, index, listener);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void fetchBindingObject(InvocationParam param, int index, FetchDataListener tt) {
        block24: {
            block25: {
                if (DataManagerImpl.WORKER_LOGGER_DEBUG) {
                    DataManagerImpl.WORKER_LOGGER.debug("   - " + param.getValue() + " registered as binding object.");
                }
                name = (String)param.getValue();
                DataManagerImpl.WORKER_LOGGER.debug("   - " + name + " registered as binding object.");
                destBo = BindingObject.generate(name);
                value = destBo.getName();
                type = destBo.getType();
                elements = destBo.getElements();
                askTransfer = false;
                cached = false;
                locationsInCache = false;
                if (!this.provider.isPersistentCEnabled()) break block25;
                if (DataManagerImpl.WORKER_LOGGER_DEBUG) {
                    DataManagerImpl.WORKER_LOGGER.debug("   - fetching Binding object for persistent worker.");
                    DataManagerImpl.WORKER_LOGGER.debug("   - Checking if " + value + " is in binding cache.");
                }
                if (cached = BindingDataManager.isInBinding(value)) break block24;
                if (DataManagerImpl.WORKER_LOGGER_DEBUG) {
                    DataManagerImpl.WORKER_LOGGER.debug("   - Checking if " + value + " locations are cached.");
                }
                for (InvocationParamURI loc : param.getSources()) {
                    block26: {
                        bo = BindingObject.generate(loc.getPath());
                        if (!loc.isHost(this.hostName) || !BindingDataManager.isInBinding(bo.getName())) continue;
                        if (DataManagerImpl.WORKER_LOGGER_DEBUG) {
                            DataManagerImpl.WORKER_LOGGER.debug("   - Parameter " + index + "(" + value + ") sources location found in cache.");
                        }
                        if (!param.isPreserveSourceData()) break block26;
                        if (DataManagerImpl.WORKER_LOGGER_DEBUG) {
                            DataManagerImpl.WORKER_LOGGER.debug("   - Parameter " + index + "(" + value + ") preserves sources. CACHE-COPYING");
                            DataManagerImpl.WORKER_LOGGER.debug("   - Parameters to issue the copy are: " + bo.getName() + " and " + value);
                        }
                        if ((res = BindingDataManager.copyCachedData(bo.getName(), value)) != 0) {
                            DataManagerImpl.WORKER_LOGGER.error("CACHE-COPY from " + bo.getName() + " to " + value + " has failed. ");
                            break block24;
                        }
                        ** GOTO lbl-1000
                    }
                    if (DataManagerImpl.WORKER_LOGGER_DEBUG) {
                        DataManagerImpl.WORKER_LOGGER.debug("   - Parameter " + index + "(" + value + ") overwrites sources. CACHE-MOVING");
                    }
                    if ((res = BindingDataManager.moveCachedData(bo.getName(), value)) != 0) {
                        DataManagerImpl.WORKER_LOGGER.error("CACHE-MOVE from " + bo.getName() + " to " + value + " has failed. ");
                    } else lbl-1000:
                    // 2 sources

                    {
                        locationsInCache = true;
                    }
                    break block24;
                }
                break block24;
            }
            if (DataManagerImpl.WORKER_LOGGER_DEBUG) {
                DataManagerImpl.WORKER_LOGGER.debug("   - fetching Binding object for NOT persistent worker.");
            }
        }
        existInHost = false;
        if (!locationsInCache) {
            if (DataManagerImpl.WORKER_LOGGER_DEBUG) {
                DataManagerImpl.WORKER_LOGGER.debug("   - Checking if " + value + " is in host as file.");
            }
            for (InvocationParamURI loc : param.getSources()) {
                if (!loc.isHost(this.hostName)) continue;
                bo = BindingObject.generate(loc.getPath());
                if (DataManagerImpl.WORKER_LOGGER_DEBUG) {
                    DataManagerImpl.WORKER_LOGGER.debug("   - Parameter " + index + "(" + param.getValue() + ") found at host with location " + loc.getPath() + " Checking if id " + bo.getName() + " is in host...");
                }
                if (!(inFile = new File(bo.getId())).isAbsolute()) {
                    inFile = new File(this.baseFolder + File.separator + bo.getId());
                }
                path = inFile.getAbsolutePath();
                if (!inFile.exists()) continue;
                existInHost = true;
                if (this.provider.isPersistentCEnabled()) {
                    res = BindingDataManager.loadFromFile(value, path, type, elements);
                    if (res == 0) break;
                    existInHost = false;
                    DataManagerImpl.WORKER_LOGGER.error("   - Error loading " + value + " from file " + path);
                    continue;
                }
                outFile = new File(value);
                try {
                    if (param.isPreserveSourceData()) {
                        Files.copy(inFile.toPath(), outFile.toPath(), new CopyOption[0]);
                        break;
                    }
                    try {
                        Files.move(inFile.toPath(), outFile.toPath(), new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
                    }
                    catch (AtomicMoveNotSupportedException amnse) {
                        DataManagerImpl.WORKER_LOGGER.warn("   - AtomicMoveNotSupportedException.File cannot be atomically moved. Trying to move without atomic");
                        Files.move(inFile.toPath(), outFile.toPath(), new CopyOption[0]);
                    }
                    break;
                }
                catch (IOException e) {
                    DataManagerImpl.WORKER_LOGGER.error("   - Error copying or moving " + bo.getName() + " to " + value);
                    DataManagerImpl.WORKER_LOGGER.error(e);
                    existInHost = false;
                }
            }
        }
        if (!(cached || locationsInCache || existInHost)) {
            if (DataManagerImpl.WORKER_LOGGER_DEBUG) {
                DataManagerImpl.WORKER_LOGGER.debug("   - The state of " + value + " in the worker is : \n\t Cached: " + cached + "\n\t Renamed in cache:     " + locationsInCache + "\n\t In host as a file:    " + existInHost);
                DataManagerImpl.WORKER_LOGGER.debug("   - Not possible to fetch     " + value + " in the current node, requesting for transfer.");
            }
            askTransfer = true;
        }
        this.askForTransfer(askTransfer, param, index, tt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchPSCO(InvocationParam param, int paramIdx, FetchDataListener tt) {
        String finalRename = param.getDataMgmtId();
        String pscoId = (String)param.getValue();
        WORKER_LOGGER.debug("   - " + pscoId + " registered as PSCO.");
        DataRegister dr = new DataRegister();
        dr.setStorageId(pscoId);
        HashMap<String, DataRegister> hashMap = this.registry;
        synchronized (hashMap) {
            this.registry.put(finalRename, dr);
        }
        tt.fetchedValue(param.getDataMgmtId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFile(final InvocationParam param, final int index, final FetchDataListener tt) {
        WORKER_LOGGER.debug("   - " + (String)param.getValue() + " registered as file.");
        final String originalName = param.getSourceDataId();
        final String finalName = param.getDataMgmtId();
        final String expectedFileLocation = param.getValue().toString();
        WORKER_LOGGER.debug("   - Checking if file " + (String)param.getValue() + " is being transferred.");
        if (this.provider.isTransferingData(param)) {
            WORKER_LOGGER.debug("- Parameter " + index + "(" + expectedFileLocation + ") is being trasferred.");
            this.provider.askForTransfer(param, index, tt);
            return;
        }
        WORKER_LOGGER.debug("   - Checking if " + expectedFileLocation + " exists in worker");
        final DataRegister originalRegister = this.getOriginalDataRegister(param);
        if (originalRegister.isLocal()) {
            String[] filesArray;
            Set<String> files;
            WORKER_LOGGER.debug("   - Parameter " + index + "(" + expectedFileLocation + ") found at host.");
            final Path tgtPath = Paths.get(expectedFileLocation, new String[0]);
            DataRegister dataRegister = originalRegister;
            synchronized (dataRegister) {
                files = originalRegister.getFileLocations();
                if (files.contains(expectedFileLocation)) {
                    this.fetchedLocalParameter(param, index, tt);
                    return;
                }
                filesArray = files.toArray(new String[files.size()]);
            }
            FileOpsManager.composedOperationAsync(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (String path : filesArray) {
                        if (!expectedFileLocation.equals(path)) {
                            Path srcPath = Paths.get(path, new String[0]);
                            try {
                                if (WORKER_LOGGER_DEBUG) {
                                    WORKER_LOGGER.debug("   - Parameter " + index + "(" + expectedFileLocation + ") " + (param.isPreserveSourceData() ? "preserves sources. COPYING" : "erases sources. MOVING"));
                                    WORKER_LOGGER.debug("         Source: " + srcPath);
                                    WORKER_LOGGER.debug("         Target: " + tgtPath);
                                }
                                if (param.isPreserveSourceData()) {
                                    if (param.getType() == DataType.DIRECTORY_T) {
                                        FileOpsManager.copyDirSync(new File(path), new File(expectedFileLocation));
                                    } else {
                                        FileOpsManager.copySync(new File(path), new File(expectedFileLocation));
                                    }
                                } else {
                                    if (param.getType() == DataType.DIRECTORY_T) {
                                        FileOpsManager.moveDirSync(new File(path), new File(expectedFileLocation));
                                    } else {
                                        FileOpsManager.moveSync(new File(path), new File(expectedFileLocation));
                                    }
                                    originalRegister.removeFileLocation(path);
                                }
                                DataRegister dr = new DataRegister();
                                dr.addFileLocation(tgtPath.toString());
                                HashMap hashMap = DataManagerImpl.this.registry;
                                synchronized (hashMap) {
                                    DataManagerImpl.this.registry.put(finalName, dr);
                                }
                                DataManagerImpl.this.fetchedLocalParameter(param, index, tt);
                                return;
                            }
                            catch (FileAlreadyExistsException e) {
                                WORKER_LOGGER.warn("WARN: File " + expectedFileLocation + " already exists avoiding copy");
                                WORKER_LOGGER.warn(" Registered locations for " + originalName + " :");
                                for (String file : files) {
                                    WORKER_LOGGER.warn(" * " + file);
                                }
                                DataManagerImpl.this.fetchedLocalParameter(param, index, tt);
                                return;
                            }
                            catch (IOException ioe) {
                                WORKER_LOGGER.error("IOException", (Throwable)ioe);
                                tt.errorFetchingValue(param.getDataMgmtId(), ioe);
                                continue;
                            }
                        }
                        DataManagerImpl.this.fetchedLocalParameter(param, index, tt);
                        return;
                    }
                }
            });
        } else {
            WORKER_LOGGER.info("- Parameter " + index + "(" + expectedFileLocation + ") does not exist, requesting data transfer");
            this.transferParameter(param, index, tt);
        }
    }

    @Override
    public void loadParam(InvocationParam param) throws UnloadableValueException {
        if (WORKER_LOGGER_DEBUG) {
            WORKER_LOGGER.debug("[Thread " + Thread.currentThread().getName() + " ] Loading parameter: " + param);
        }
        switch (param.getType()) {
            case OBJECT_T: 
            case STREAM_T: 
            case PSCO_T: {
                this.loadObject(param);
                break;
            }
            case COLLECTION_T: 
            case DICT_COLLECTION_T: 
            case BINDING_OBJECT_T: 
            case FILE_T: 
            case EXTERNAL_STREAM_T: 
            case EXTERNAL_PSCO_T: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadObject(InvocationParam param) throws UnloadableValueException {
        DataRegister register;
        String rename = param.getDataMgmtId();
        Object o = null;
        Object object = this.registry;
        synchronized (object) {
            register = this.registry.get(rename);
        }
        if (WORKER_LOGGER_DEBUG) {
            WORKER_LOGGER.debug("[Thread " + Thread.currentThread().getName() + " ] Loading value: " + rename);
        }
        object = register;
        synchronized (object) {
            try {
                o = register.loadValue();
            }
            catch (NoSourcesException | IOException | ClassNotFoundException | StorageException e) {
                throw new UnloadableValueException(e);
            }
        }
        param.setValue(o);
    }

    @Override
    public void storeParam(InvocationParam param) {
        switch (param.getType()) {
            case OBJECT_T: 
            case STREAM_T: {
                this.storeObject(param.getDataMgmtId(), param.getValue());
                break;
            }
            case PSCO_T: 
            case EXTERNAL_PSCO_T: {
                break;
            }
            case BINDING_OBJECT_T: {
                break;
            }
            case FILE_T: 
            case EXTERNAL_STREAM_T: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeObject(String rename, Object value) {
        DataRegister register;
        Object object = this.registry;
        synchronized (object) {
            register = this.registry.get(rename);
            if (register == null) {
                register = new DataRegister();
                this.registry.put(rename, register);
            }
        }
        object = register;
        synchronized (object) {
            register.setValue(value);
        }
    }

    @Override
    public void storeValue(String name, Object value) {
        this.storeObject(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeFile(String rename, String path) {
        DataRegister register;
        Object object = this.registry;
        synchronized (object) {
            register = this.registry.get(rename);
            if (register == null) {
                register = new DataRegister();
                this.registry.put(rename, register);
            }
        }
        object = register;
        synchronized (object) {
            register.addFileLocation(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(String dataMgmtId) {
        DataRegister register;
        Object o = null;
        Object object = this.registry;
        synchronized (object) {
            register = this.registry.get(dataMgmtId);
        }
        try {
            object = register;
            synchronized (object) {
                o = register.loadValue();
            }
        }
        catch (IOException ioe) {
            WORKER_LOGGER.error("Error loading value", (Throwable)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            WORKER_LOGGER.error("Error loading value", (Throwable)cnfe);
        }
        catch (NoSourcesException nse) {
            WORKER_LOGGER.error("Error loading value", (Throwable)nse);
        }
        catch (StorageException se) {
            WORKER_LOGGER.error("Error loading value", (Throwable)se);
        }
        return o;
    }

    private void askForTransfer(boolean askTransfer, InvocationParam param, int index, FetchDataListener tt) {
        if (askTransfer) {
            this.transferParameter(param, index, tt);
        } else {
            this.fetchedLocalParameter(param, index, tt);
        }
    }

    private void fetchedLocalParameter(InvocationParam param, int index, FetchDataListener tt) {
        WORKER_LOGGER.info("- Parameter " + index + "(" + (String)param.getValue() + ") already exists.");
        tt.fetchedValue(param.getDataMgmtId());
    }

    private void transferParameter(InvocationParam param, int index, FetchDataListener tt) {
        WORKER_LOGGER.info("- Parameter " + index + "(" + (String)param.getValue() + ") does not exist, requesting data transfer");
        this.provider.askForTransfer(param, index, tt);
    }

    static {
        String streamBackendProperty = System.getProperty("compss.streaming");
        String streamBackendPropertyFixed = streamBackendProperty == null || streamBackendProperty.isEmpty() || streamBackendProperty.equals("null") ? "NONE" : streamBackendProperty.toUpperCase();
        STREAMING_BACKEND = StreamBackend.valueOf(streamBackendPropertyFixed);
        String storageCfgProperty = System.getProperty("compss.storage.conf");
        STORAGE_CONF = storageCfgProperty == null || storageCfgProperty.isEmpty() || storageCfgProperty.equals("null") ? null : storageCfgProperty;
    }
}

