/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.job;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class JobProfile
implements Externalizable {
    private long submissionTS = 0L;
    private long arrivalTS;
    private long fetchedDataTS = 0L;
    private long executionStartTS = 0L;
    private long executionEndTS = 0L;
    private long endNotificationTS = 0L;
    private long endTS;

    public void submitted() {
        this.submissionTS = System.currentTimeMillis();
    }

    public void arrived() {
        this.arrivalTS = System.currentTimeMillis();
    }

    public void fetchedAllInputData() {
        this.fetchedDataTS = System.currentTimeMillis();
    }

    public void startingExecution() {
        this.executionStartTS = System.currentTimeMillis();
    }

    public void endedExecution() {
        this.executionEndTS = System.currentTimeMillis();
    }

    public void endNotified() {
        this.endNotificationTS = System.currentTimeMillis();
    }

    public void completed() {
        this.endTS = System.currentTimeMillis();
    }

    public long getExecutionLength() {
        return this.executionEndTS - this.executionStartTS;
    }

    public long getTotalTime() {
        return this.endTS - this.submissionTS;
    }

    public void mergeRemoteData(JobProfile jp) {
        this.fetchedDataTS = jp.fetchedDataTS;
        this.executionStartTS = jp.executionStartTS;
        this.executionEndTS = jp.executionEndTS;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.fetchedDataTS);
        out.writeLong(this.executionStartTS);
        out.writeLong(this.executionEndTS);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fetchedDataTS = in.readLong();
        this.executionStartTS = in.readLong();
        this.executionEndTS = in.readLong();
    }
}

