/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio.event;

import es.bsc.comm.EventManager;
import es.bsc.comm.exceptions.CommException;
import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.nio.event.NIOEvent;

public class ErrorEvent
extends NIOEvent {
    private final CommException exception;

    public ErrorEvent(NIOConnection nc, CommException e) {
        super(nc);
        this.exception = e;
    }

    public ErrorEvent(CommException e) {
        super(null);
        this.exception = e;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public NIOEvent.EventType getEventType() {
        return NIOEvent.EventType.ERROR;
    }

    @Override
    public void processEventOnConnection(EventManager nem) {
        if (this.getConnection() != null) {
            this.getConnection().error(this.exception);
        } else {
            nem.notifyError(null, null, this.exception);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append("Error event");
        if (this.getConnection() != null) {
            sb.append(" on connection@").append(this.getConnection().hashCode());
        }
        sb.append(" caused by ").append(this.exception);
        return sb.toString();
    }
}

