/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.components;

import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.exceptions.NoSourcesException;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.util.FileOpsManager;
import es.bsc.compss.util.serializers.Serializer;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;
import storage.StorageObject;

public class DataRegister {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker");
    private boolean inMemory;
    private Object value;
    private String storageId;
    private final Set<String> files = new HashSet<String>();

    public boolean isInMemory() {
        return this.inMemory;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStorageId() {
        return this.storageId;
    }

    public boolean isLocal() {
        return this.inMemory || !this.files.isEmpty() || this.storageId != null;
    }

    public Set<String> getFileLocations() {
        return this.files;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public void addFileLocation(String file) {
        this.files.add(file);
    }

    public void removeFileLocation(String path) {
        this.files.remove(path);
    }

    public void setValue(Object value) {
        if (value instanceof StorageObject) {
            this.storageId = ((StorageObject)value).getID();
        }
        this.value = value;
        this.inMemory = true;
    }

    public void removeValue() {
        this.inMemory = false;
        this.value = null;
    }

    public Object loadValue() throws IOException, ClassNotFoundException, NoSourcesException, StorageException {
        if (this.storageId != null) {
            LOGGER.debug("   - Retrieving psco " + this.storageId + " from Storage");
            if (NIOTracer.isActivated()) {
                NIOTracer.emitEvent(TraceEvent.STORAGE_GETBYID);
            }
            try {
                Object obj;
                Object object = obj = StorageItf.getByID(this.storageId);
                return object;
            }
            catch (StorageException e) {
                LOGGER.error("Cannot getByID PSCO " + this.storageId, (Throwable)e);
                throw e;
            }
            finally {
                if (NIOTracer.isActivated()) {
                    NIOTracer.emitEventEnd(TraceEvent.STORAGE_GETBYID);
                }
            }
        }
        IOException io = null;
        ClassNotFoundException cnf = null;
        if (!this.inMemory) {
            for (String path : this.files) {
                try {
                    this.setValue(Serializer.deserialize(path));
                    return this.value;
                }
                catch (IOException ioe) {
                    io = ioe;
                }
                catch (ClassNotFoundException cnfe) {
                    cnf = cnfe;
                }
            }
            if (cnf != null) {
                throw cnf;
            }
            if (io != null) {
                throw io;
            }
        } else {
            return this.value;
        }
        throw new NoSourcesException();
    }

    public Object cloneValue() throws StorageException, ClassNotFoundException, IOException, NoSourcesException {
        if (this.storageId != null) {
            return StorageItf.getByID(this.storageId);
        }
        if (!this.inMemory) {
            IOException io = null;
            ClassNotFoundException cnf = null;
            for (String path : this.files) {
                try {
                    return Serializer.deserialize(path);
                }
                catch (IOException ioe) {
                    io = ioe;
                }
                catch (ClassNotFoundException cnfe) {
                    cnf = cnfe;
                }
            }
            if (cnf != null) {
                throw cnf;
            }
            if (io != null) {
                throw io;
            }
        } else {
            return Serializer.deserialize(Serializer.serialize(this.value));
        }
        throw new NoSourcesException();
    }

    public void clear() {
        this.storageId = null;
        this.removeValue();
        for (String path : this.files) {
            FileOpsManager.deleteAsync(new File(path));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tMemory: ");
        if (this.inMemory) {
            sb.append("<").append(this.value).append(">");
        } else {
            sb.append("NOT PRESENT");
        }
        sb.append("\n");
        sb.append("\tStorage ID:").append(this.storageId).append("\n");
        sb.append("\tFiles:\n");
        for (String file : this.files) {
            sb.append("\t- ").append(file).append("\n");
        }
        return sb.toString();
    }
}

