/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.nio.NIOData;
import es.bsc.compss.nio.NIOUri;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.execution.InvocationParam;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.util.List;

public class NIOParam
implements Externalizable,
InvocationParam {
    private String dataMgmtId;
    private DataType type;
    private StdIOStream stream;
    private String prefix;
    private String name;
    private String contentType;
    private double weight;
    private boolean keepRename;
    private boolean preserveSourceData;
    private boolean writeFinalValue;
    private Object value;
    private NIOData source;
    private String originalName;
    private String renamedName;
    private String targetPath;
    private Class<?> valueClass;

    public NIOParam() {
    }

    public NIOParam(String dataMgmtId, DataType type, StdIOStream stream, String prefix, String name, String contentType, double weight, boolean keepRename, boolean preserveSourceData, boolean writeFinalValue, Object value, NIOData data, String originalName) {
        this.dataMgmtId = dataMgmtId;
        this.type = type;
        this.stream = stream;
        this.prefix = prefix;
        this.name = name;
        this.contentType = contentType == null ? "null" : contentType;
        this.weight = weight;
        this.keepRename = keepRename;
        this.value = value;
        this.preserveSourceData = preserveSourceData;
        this.writeFinalValue = writeFinalValue;
        this.source = data;
        this.originalName = originalName;
    }

    public NIOParam(NIOParam p) {
        this.dataMgmtId = p.dataMgmtId;
        this.type = p.type;
        this.stream = p.stream;
        this.prefix = p.prefix;
        this.name = p.name;
        this.contentType = p.contentType;
        this.weight = p.weight;
        this.keepRename = p.keepRename;
        this.value = p.value;
        this.preserveSourceData = p.preserveSourceData;
        this.writeFinalValue = p.writeFinalValue;
        this.source = p.source;
        this.originalName = p.originalName;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public boolean isCollective() {
        return false;
    }

    @Override
    public StdIOStream getStdIOStream() {
        return this.stream;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public boolean isKeepRename() {
        return this.keepRename;
    }

    @Override
    public boolean isPreserveSourceData() {
        return this.preserveSourceData;
    }

    @Override
    public boolean isWriteFinalValue() {
        return this.writeFinalValue;
    }

    @Override
    public String getDataMgmtId() {
        return this.dataMgmtId;
    }

    @Override
    public String getSourceDataId() {
        return this.source != null ? this.source.getDataMgmtId() : null;
    }

    public List<NIOUri> getSources() {
        return this.source.getSources();
    }

    @Override
    public String getOriginalName() {
        return this.originalName;
    }

    @Override
    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    @Override
    public String getRenamedName() {
        return this.renamedName;
    }

    @Override
    public void setRenamedName(String renamedName) {
        this.renamedName = renamedName;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public NIOData getData() {
        return this.source;
    }

    @Override
    public void setType(DataType type) {
        this.type = type;
    }

    @Override
    public void setValue(Object o) {
        this.value = o;
    }

    @Override
    public void setValueClass(Class<?> valueClass) {
        this.valueClass = valueClass;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    @Override
    public void resultIsForwarded() {
    }

    @Override
    public boolean isForwardedResult() {
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dataMgmtId = (String)in.readObject();
        this.type = (DataType)((Object)in.readObject());
        this.stream = (StdIOStream)((Object)in.readObject());
        this.prefix = in.readUTF();
        this.name = in.readUTF();
        this.contentType = in.readUTF();
        this.weight = in.readDouble();
        this.keepRename = in.readBoolean();
        this.preserveSourceData = in.readBoolean();
        this.writeFinalValue = in.readBoolean();
        this.originalName = (String)in.readObject();
        this.value = in.readObject();
        try {
            this.source = (NIOData)in.readObject();
        }
        catch (OptionalDataException e) {
            this.source = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.dataMgmtId);
        out.writeObject((Object)this.type);
        out.writeObject((Object)this.stream);
        out.writeUTF(this.prefix);
        out.writeUTF(this.name);
        out.writeUTF(this.contentType);
        out.writeDouble(this.weight);
        out.writeBoolean(this.keepRename);
        out.writeBoolean(this.preserveSourceData);
        out.writeBoolean(this.writeFinalValue);
        out.writeObject(this.originalName);
        out.writeObject(this.value);
        if (this.source != null) {
            out.writeObject(this.source);
        }
    }

    protected void dumpInternalInfo(StringBuilder sb) {
        sb.append("\"mgmt_id\":\"").append(this.dataMgmtId).append("\",");
        sb.append("\"type\":\"").append((Object)this.type).append("\",");
        sb.append("\"io_stream\":\"").append((Object)this.stream).append("\",");
        sb.append("\"prefix\":\"").append(this.prefix).append("\",");
        sb.append("\"name\":\"").append(this.name).append("\",");
        sb.append("\"content_type\":\"").append(this.contentType).append("\",");
        sb.append("\"keep_rename\":").append(this.keepRename).append(",");
        sb.append("\"preserve_source_data\":").append(this.preserveSourceData).append(",");
        sb.append("\"write_final_value\":").append(this.writeFinalValue).append(",");
        sb.append("\"original_name\":\"").append(this.originalName).append("\",");
        sb.append("\"value\":").append(this.value).append(",");
        sb.append("\"data\":").append(this.source).append(",");
        sb.append("\"stored_path\":").append(this.targetPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        this.dumpInternalInfo(sb);
        sb.append("}");
        return sb.toString();
    }
}

