/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ws.master;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.ws.master.WSJob;
import es.bsc.compss.ws.master.configuration.WSConfiguration;
import java.util.List;

public class ServiceInstance
extends COMPSsWorker {
    private WSConfiguration config;

    public ServiceInstance(String name, WSConfiguration config) {
        super(name, config);
        this.config = config;
    }

    @Override
    public void start() throws InitNodeException {
    }

    public String getWsdl() {
        return this.config.getWsdl();
    }

    public void setServiceName(String serviceName) {
        this.config.setServiceName(serviceName);
    }

    public String getServiceName() {
        return this.config.getServiceName();
    }

    public void setNamespace(String namespace) {
        this.config.setNamespace(namespace);
    }

    public String getNamespace() {
        return this.config.getNamespace();
    }

    public void setPort(String port) {
        this.config.setPort(port);
    }

    public String getPort() {
        return this.config.getPort();
    }

    @Override
    public String getName() {
        return this.config.getWsdl();
    }

    @Override
    public void setInternalURI(MultiURI uri) {
    }

    @Override
    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener) {
        return new WSJob(taskId, taskParams, impl, res, listener);
    }

    @Override
    public void stop(ShutdownListener sl) {
        sl.notifyEnd();
    }

    @Override
    public void sendData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
    }

    @Override
    public void obtainData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        String path = target.getProtocol().getSchema() + target.getPath();
        DataLocation tgtLoc = null;
        try {
            SimpleURI uri = new SimpleURI(path);
            tgtLoc = DataLocation.createLocation(Comm.getAppHost(), uri);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + path, e);
        }
        COMPSsNode node = Comm.getAppHost().getNode();
        node.obtainData(ld, source, tgtLoc, tgtData, reason, listener);
    }

    @Override
    public void updateTaskCount(int processorCoreCount) {
    }

    @Override
    public void announceDestruction() {
    }

    @Override
    public void announceCreation() {
    }

    @Override
    public String getUser() {
        return "";
    }

    @Override
    public SimpleURI getCompletePath(DataType type, String name) {
        String path = null;
        switch (type) {
            case FILE_T: {
                path = DataLocation.Protocol.FILE_URI.getSchema() + Comm.getAppHost().getTempDirPath() + name;
                break;
            }
            case OBJECT_T: {
                path = DataLocation.Protocol.OBJECT_URI.getSchema() + name;
                break;
            }
            case PSCO_T: {
                path = DataLocation.Protocol.PERSISTENT_URI.getSchema() + name;
                break;
            }
            case EXTERNAL_PSCO_T: {
                path = DataLocation.Protocol.PERSISTENT_URI.getSchema() + name;
                break;
            }
            default: {
                return null;
            }
        }
        return new SimpleURI(path);
    }

    @Override
    public void deleteTemporary() {
    }

    @Override
    public boolean generatePackage() {
        return false;
    }

    @Override
    public void shutdownExecutionManager(ExecutorShutdownListener sl) {
    }

    @Override
    public boolean generateWorkersDebugInfo() {
        return false;
    }

    @Override
    public String getClasspath() {
        return "";
    }

    @Override
    public String getPythonpath() {
        return "";
    }

    @Override
    public void increaseComputingCapabilities(int CPUCount, int GPUCount, int FPGACount, int otherCount) {
    }

    @Override
    public void reduceComputingCapabilities(int CPUCount, int GPUCount, int FPGACount, int otherCount) {
    }
}

