/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ws.master;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.CannotLoadException;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.util.RequestDispatcher;
import es.bsc.compss.util.RequestQueue;
import es.bsc.compss.util.ThreadPool;
import es.bsc.compss.ws.master.ServiceInstance;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WSJob
extends Job<ServiceInstance> {
    protected static final Logger logger = LogManager.getLogger("es.bsc.compss.Communication");
    protected static final boolean debug = logger.isDebugEnabled();
    private static RequestQueue<WSJob> callerQueue;
    private static WSCaller caller;
    private static final JaxWsDynamicClientFactory dcf;
    private static final HashMap<String, Client> portToClient;
    private static ThreadPool callerPool;
    private static final int POOL_SIZE = 10;
    private static final String POOL_NAME = "WS";
    private static final String THREAD_POOL_ERR = "Error starting pool of threads";
    private static final String SUBMIT_ERROR = "Error calling Web Service";
    private Object returnValue = null;

    public static void init() throws Exception {
        if (callerQueue == null) {
            callerQueue = new RequestQueue();
        } else {
            callerQueue.clear();
        }
        caller = new WSCaller(callerQueue);
        callerPool = new ThreadPool(10, POOL_NAME, caller);
        try {
            callerPool.startThreads();
        }
        catch (Exception e) {
            logger.error(THREAD_POOL_ERR, (Throwable)e);
            throw e;
        }
    }

    public static void end() {
        try {
            callerPool.stopThreads();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public WSJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, JobListener listener) {
        super(taskId, taskParams, impl, res, listener);
    }

    @Override
    public Implementation.TaskType getType() {
        return Implementation.TaskType.SERVICE;
    }

    @Override
    public void submit() {
        callerQueue.enqueue(this);
    }

    @Override
    public void stop() {
    }

    @Override
    public Object getReturnValue() {
        return this.returnValue;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[[Job id: ").append(this.getJobId()).append("]");
        buffer.append(", ").append(this.taskParams.toString());
        String name = "";
        Object node = this.getResourceNode();
        name = ((COMPSsNode)node).getName();
        buffer.append(", [Target URL: ").append(name).append("]]");
        return buffer.toString();
    }

    @Override
    public String getHostName() {
        return ((ServiceInstance)this.getResourceNode()).getName();
    }

    static {
        dcf = JaxWsDynamicClientFactory.newInstance();
        portToClient = new HashMap();
    }

    private static class WSCaller
    extends RequestDispatcher<WSJob> {
        public WSCaller(RequestQueue<WSJob> queue) {
            super(queue);
        }

        @Override
        public void processRequests() {
            WSJob job;
            while ((job = (WSJob)this.queue.dequeue()) != null) {
                try {
                    ArrayList<Object> input = new ArrayList<Object>();
                    TaskDescription taskParams = job.taskParams;
                    ServiceImplementation service = (ServiceImplementation)job.impl;
                    Parameter[] parameters = taskParams.getParameters();
                    block8: for (int i = 0; i < taskParams.getParameters().length; ++i) {
                        if (parameters[i].getDirection() != Direction.IN) continue;
                        switch (parameters[i].getType()) {
                            case OBJECT_T: 
                            case PSCO_T: 
                            case EXTERNAL_PSCO_T: {
                                DependencyParameter dp = (DependencyParameter)parameters[i];
                                Object o = this.getObjectValue(dp);
                                input.add(o);
                                continue block8;
                            }
                            case FILE_T: {
                                logger.error("Error: WS CAN'T USE BINDING FILES AS A PARAMETER!");
                                continue block8;
                            }
                            case BINDING_OBJECT_T: {
                                logger.error("Error: WS CAN'T USE BINDING OBJECTS AS A PARAMETER!");
                                continue block8;
                            }
                            default: {
                                BasicTypeParameter btParB = (BasicTypeParameter)parameters[i];
                                input.add(btParB.getValue());
                            }
                        }
                    }
                    ServiceInstance si = (ServiceInstance)job.getResourceNode();
                    String portName = service.getRequirements().getPort();
                    String operationName = service.getOperation();
                    if (operationName.compareTo("[unassigned]") == 0) {
                        operationName = taskParams.getName();
                    }
                    Client client = this.getClient(si, portName);
                    ClientCallback cb = new ClientCallback();
                    client.invoke(cb, operationName, input.toArray());
                    Object[] result = cb.get();
                    if (result.length > 0) {
                        job.returnValue = result[0];
                    }
                    job.listener.jobCompleted(job);
                }
                catch (Exception e) {
                    job.listener.jobFailed(job, JobListener.JobEndStatus.EXECUTION_FAILED);
                    logger.error(WSJob.SUBMIT_ERROR, (Throwable)e);
                    return;
                }
            }
        }

        private Client getClient(ServiceInstance si, String portName) {
            Client c = (Client)portToClient.get(si.getName() + "-" + portName);
            if (c == null) {
                c = this.addPort(si, portName);
                portToClient.put(si.getName() + "-" + portName, c);
            }
            return c;
        }

        public synchronized Client addPort(ServiceInstance si, String portName) {
            Client client = (Client)portToClient.get(portName);
            if (client != null) {
                return client;
            }
            QName serviceQName = new QName(si.getNamespace(), si.getServiceName());
            QName portQName = new QName(si.getNamespace(), portName);
            try {
                client = dcf.createClient(si.getWsdl(), serviceQName, portQName);
            }
            catch (Exception e) {
                logger.error("Exception", (Throwable)e);
                return null;
            }
            HTTPConduit http = (HTTPConduit)client.getConduit();
            HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setConnectionTimeout(0L);
            httpClientPolicy.setReceiveTimeout(0L);
            http.setClient(httpClientPolicy);
            portToClient.put(portName, client);
            return client;
        }

        private Object getObjectValue(DependencyParameter dp) throws CannotLoadException {
            String renaming = ((RAccessId)dp.getDataAccessId()).getReadDataInstance().getRenaming();
            LogicalData ld = Comm.getData(renaming);
            if (!ld.isInMemory()) {
                ld.loadFromStorage();
            }
            return ld.getValue();
        }
    }
}

