/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.osgi;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.cxf.bus.blueprint.BlueprintNameSpaceHandlerFactory;
import org.apache.cxf.bus.blueprint.NamespaceHandlerRegisterer;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.DestinationRegistryImpl;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.blueprint.HttpBPHandler;
import org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer;
import org.apache.cxf.transport.http.osgi.HttpServiceTrackerCust;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HTTPTransportActivator
implements BundleActivator {
    private static final String DISABLE_DEFAULT_HTTP_TRANSPORT = "org.apache.cxf.osgi.http.transport.disable";
    private ServiceTracker httpServiceTracker;

    public void start(BundleContext context) throws Exception {
        ConfigAdminHttpConduitConfigurer conduitConfigurer = new ConfigAdminHttpConduitConfigurer();
        this.registerService(context, ManagedServiceFactory.class, conduitConfigurer, "org.apache.cxf.http.conduits");
        this.registerService(context, HTTPConduitConfigurer.class, conduitConfigurer, "org.apache.cxf.http.conduit-configurer");
        if (PropertyUtils.isTrue(context.getProperty(DISABLE_DEFAULT_HTTP_TRANSPORT))) {
            return;
        }
        DestinationRegistryImpl destinationRegistry = new DestinationRegistryImpl();
        HTTPTransportFactory transportFactory = new HTTPTransportFactory(destinationRegistry);
        HttpServiceTrackerCust customizer = new HttpServiceTrackerCust(destinationRegistry, context);
        this.httpServiceTracker = new ServiceTracker(context, HttpService.class.getName(), (ServiceTrackerCustomizer)customizer);
        this.httpServiceTracker.open();
        context.registerService(DestinationRegistry.class.getName(), (Object)destinationRegistry, null);
        context.registerService(HTTPTransportFactory.class.getName(), (Object)transportFactory, null);
        BlueprintNameSpaceHandlerFactory factory = new BlueprintNameSpaceHandlerFactory(){

            @Override
            public Object createNamespaceHandler() {
                return new HttpBPHandler();
            }
        };
        NamespaceHandlerRegisterer.register(context, factory, "http://cxf.apache.org/transports/http/configuration");
    }

    private ServiceRegistration registerService(BundleContext context, Class<?> serviceInterface, Object serviceObject, String servicePid) {
        Properties servProps = new Properties();
        servProps.put("service.pid", servicePid);
        return context.registerService(serviceInterface.getName(), serviceObject, (Dictionary)servProps);
    }

    public void stop(BundleContext context) throws Exception {
    }
}

