/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ws.master;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.CannotLoadException;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.util.RequestDispatcher;
import es.bsc.compss.util.RequestQueue;
import es.bsc.compss.util.ThreadPool;
import es.bsc.compss.worker.COMPSsException;
import es.bsc.compss.ws.master.ServiceInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WSJob
extends Job<ServiceInstance> {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final String SUBMIT_ERROR = "Error calling Web Service";
    private static final int POOL_SIZE = 10;
    private static final String POOL_NAME = "WS";
    private static final JaxWsDynamicClientFactory DCF = JaxWsDynamicClientFactory.newInstance();
    private static final Map<String, Client> PORT2CLIENT = new HashMap<String, Client>();
    private static RequestQueue<WSJob> callerQueue;
    private static WSCaller caller;
    private static ThreadPool callerPool;
    private Object returnValue = null;

    public static void init() {
        if (callerQueue == null) {
            callerQueue = new RequestQueue();
        } else {
            callerQueue.clear();
        }
        caller = new WSCaller(callerQueue);
        callerPool = new ThreadPool(10, POOL_NAME, (RequestDispatcher)caller);
        callerPool.startThreads();
    }

    public static void end() {
        callerPool.stopThreads();
    }

    public WSJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, JobListener listener) {
        super(taskId, taskParams, impl, res, listener);
    }

    public TaskType getType() {
        return TaskType.SERVICE;
    }

    public void submit() {
        callerQueue.enqueue((Object)this);
    }

    public void cancelJob() {
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[[Job id: ").append(this.getJobId()).append("]");
        buffer.append(", ").append(this.taskParams.toString());
        String name = "";
        COMPSsWorker node = this.getResourceNode();
        name = node.getName();
        buffer.append(", [Target URL: ").append(name).append("]]");
        return buffer.toString();
    }

    public String getHostName() {
        return ((ServiceInstance)this.getResourceNode()).getName();
    }

    private static class WSCaller
    extends RequestDispatcher<WSJob> {
        public WSCaller(RequestQueue<WSJob> queue) {
            super(queue);
        }

        public void processRequests() {
            WSJob job;
            while ((job = (WSJob)((Object)this.queue.dequeue())) != null) {
                try {
                    ArrayList<Object> input = new ArrayList<Object>();
                    TaskDescription taskParams = job.taskParams;
                    ServiceImplementation service = (ServiceImplementation)job.impl;
                    block9: for (Parameter par : taskParams.getParameters()) {
                        if (par.getDirection() != Direction.IN) continue;
                        switch (par.getType()) {
                            case OBJECT_T: 
                            case PSCO_T: 
                            case EXTERNAL_PSCO_T: {
                                DependencyParameter dp = (DependencyParameter)par;
                                Object o = this.getObjectValue(dp);
                                input.add(o);
                                continue block9;
                            }
                            case FILE_T: {
                                LOGGER.error("Error: WS CAN'T USE BINDING FILES AS PARAMETERS!");
                                continue block9;
                            }
                            case STREAM_T: 
                            case EXTERNAL_STREAM_T: {
                                LOGGER.error("Error: WS CAN'T USE STREAMS AS PARAMETERS!");
                                continue block9;
                            }
                            case BINDING_OBJECT_T: {
                                LOGGER.error("Error: WS CAN'T USE BINDING OBJECTS AS PARAMETERS!");
                                continue block9;
                            }
                        }
                        BasicTypeParameter btParB = (BasicTypeParameter)par;
                        input.add(btParB.getValue());
                    }
                    ServiceInstance si = (ServiceInstance)job.getResourceNode();
                    String portName = service.getRequirements().getPort();
                    String operationName = service.getOperation();
                    if (operationName.compareTo("[unassigned]") == 0) {
                        operationName = taskParams.getName();
                    }
                    Client client = this.getClient(si, portName);
                    ClientCallback cb = new ClientCallback();
                    client.invoke(cb, operationName, input.toArray());
                    Object[] result = cb.get();
                    if (result.length > 0) {
                        job.returnValue = result[0];
                    }
                    job.listener.jobCompleted((Job)job);
                }
                catch (Exception e) {
                    if (e instanceof COMPSsException) {
                        job.listener.jobFailed((Job)job, JobEndStatus.EXECUTION_FAILED, (COMPSsException)e);
                    } else {
                        job.listener.jobFailed((Job)job, JobEndStatus.EXECUTION_FAILED, null);
                    }
                    LOGGER.error(WSJob.SUBMIT_ERROR, (Throwable)e);
                    return;
                }
            }
        }

        private Client getClient(ServiceInstance si, String portName) {
            Client c = (Client)PORT2CLIENT.get(si.getName() + "-" + portName);
            if (c == null) {
                c = this.addPort(si, portName);
                PORT2CLIENT.put(si.getName() + "-" + portName, c);
            }
            return c;
        }

        public synchronized Client addPort(ServiceInstance si, String portName) {
            Client client = (Client)PORT2CLIENT.get(portName);
            if (client != null) {
                return client;
            }
            QName serviceQName = new QName(si.getNamespace(), si.getServiceName());
            QName portQName = new QName(si.getNamespace(), portName);
            try {
                client = DCF.createClient(si.getWsdl(), serviceQName, portQName);
            }
            catch (Exception e) {
                LOGGER.error("Exception", (Throwable)e);
                return null;
            }
            HTTPConduit http = (HTTPConduit)client.getConduit();
            HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setConnectionTimeout(0L);
            httpClientPolicy.setReceiveTimeout(0L);
            http.setClient(httpClientPolicy);
            PORT2CLIENT.put(portName, client);
            return client;
        }

        private Object getObjectValue(DependencyParameter dp) throws CannotLoadException {
            String renaming = ((RAccessId)dp.getDataAccessId()).getReadDataInstance().getRenaming();
            LogicalData ld = Comm.getData((String)renaming);
            if (!ld.isInMemory()) {
                ld.loadFromStorage();
            }
            return ld.getValue();
        }
    }
}

