/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ws.master;

import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.types.resources.jaxb.PriceType;
import es.bsc.compss.types.resources.jaxb.ServiceType;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.ws.master.ServiceInstance;
import es.bsc.compss.ws.master.WSJob;
import es.bsc.compss.ws.master.configuration.WSConfiguration;
import es.bsc.conn.types.StarterCommand;
import java.util.LinkedList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WSAdaptor
implements CommAdaptor {
    public static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    public static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected static boolean tracing;

    public void init() {
        try {
            WSJob.init();
        }
        catch (Exception e) {
            LOGGER.error("Can not initialize WS Adaptor");
        }
    }

    public Configuration constructConfiguration(Map<String, Object> projectProperties, Map<String, Object> resourcesProperties) throws ConstructConfigurationException {
        es.bsc.compss.types.project.jaxb.ServiceType sProject = (es.bsc.compss.types.project.jaxb.ServiceType)projectProperties.get("Service");
        ServiceType sResources = (ServiceType)resourcesProperties.get("Service");
        String wsdl = null;
        if (sProject != null) {
            wsdl = sProject.getWsdl();
        } else if (sResources != null) {
            wsdl = sResources.getWsdl();
        } else {
            throw new ConstructConfigurationException("Cannot configure service because no WSDL provided");
        }
        WSConfiguration config = new WSConfiguration(this.getClass().getName(), wsdl);
        if (sProject != null) {
            config.setLimitOfTasks(sProject.getLimitOfTasks());
        }
        if (sResources != null) {
            PriceType p;
            config.setServiceName(sResources.getName());
            config.setNamespace(sResources.getNamespace());
            String servicePort = sResources.getPort();
            if (servicePort != null && !servicePort.isEmpty()) {
                config.setPort(sResources.getPort());
            }
            if ((p = sResources.getPrice()) != null) {
                config.setPricePerUnitTime(p.getPricePerUnit());
                config.setPriceUnitTime(p.getTimeUnit());
            }
        }
        return config;
    }

    public COMPSsWorker initWorker(Configuration config, NodeMonitor monitor) {
        WSConfiguration wsCfg = (WSConfiguration)config;
        LOGGER.debug("Init WS Worker Node named " + wsCfg.getWsdl());
        return new ServiceInstance(wsCfg, monitor);
    }

    public void stop() {
        WSJob.end();
    }

    public LinkedList<DataOperation> getPending() {
        return null;
    }

    public void stopSubmittedJobs() {
    }

    public void completeMasterURI(MultiURI u) {
    }

    public StarterCommand getStarterCommand(String workerName, int workerPort, String masterName, String workingDir, String installDir, String appDir, String classpathFromFile, String pythonpathFromFile, String libPathFromFile, int totalCPU, int totalGPU, int totalFPGA, int limitOfTasks, String hostId) {
        return null;
    }
}

